/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.quest;

import com.almasb.fxgl.core.Updatable;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.quest.BooleanQuestObjective;
import com.almasb.fxgl.quest.IntQuestObjective;
import com.almasb.fxgl.quest.QuestObjective;
import com.almasb.fxgl.quest.QuestState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\b2\b\b\u0002\u0010$\u001a\u00020%H\u0007J*\u0010&\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020'2\b\b\u0002\u0010$\u001a\u00020%H\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0006\u0010+\u001a\u00020\u0012J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020)H\u0002J\u000e\u00101\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0015J\r\u00102\u001a\u00020)H\u0000\u00a2\u0006\u0002\b3J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001905J\r\u00106\u001a\u00020)H\u0000\u00a2\u0006\u0002\b7R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015 \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00190\u00190\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00068"}, d2={"Lcom/almasb/fxgl/quest/Quest;", "Lcom/almasb/fxgl/core/Updatable;", "name", "", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "(Ljava/lang/String;Lcom/almasb/fxgl/core/collection/PropertyMap;)V", "isStarted", "", "()Z", "log", "Lcom/almasb/fxgl/logging/Logger;", "value", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "nameProp", "Ljavafx/beans/property/SimpleStringProperty;", "objectives", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/quest/QuestObjective;", "kotlin.jvm.PlatformType", "objectivesReadOnly", "state", "Lcom/almasb/fxgl/quest/QuestState;", "getState", "()Lcom/almasb/fxgl/quest/QuestState;", "stateProp", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "getVars", "()Lcom/almasb/fxgl/core/collection/PropertyMap;", "addBooleanObjective", "desc", "varName", "varValue", "duration", "Ljavafx/util/Duration;", "addIntObjective", "", "addObjective", "", "objective", "nameProperty", "objectivesProperty", "onUpdate", "tpf", "", "rebindStateToObjectives", "removeObjective", "start", "start$fxgl_gameplay", "stateProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "stop", "stop$fxgl_gameplay", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nQuest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quest.kt\ncom/almasb/fxgl/quest/Quest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n1#2:337\n1855#3,2:338\n1855#3,2:340\n1855#3,2:342\n1549#3:344\n1620#3,3:345\n1819#3,8:348\n1549#3:356\n1620#3,3:357\n1819#3,8:360\n*S KotlinDebug\n*F\n+ 1 Quest.kt\ncom/almasb/fxgl/quest/Quest\n*L\n106#1:338,2\n116#1:340,2\n120#1:342,2\n122#1:344\n122#1:345,3\n123#1:348,8\n127#1:356\n127#1:357,3\n128#1:360,8\n*E\n"})
public final class Quest
implements Updatable {
    @NotNull
    private final PropertyMap vars;
    @NotNull
    private final Logger log;
    @NotNull
    private final SimpleStringProperty nameProp;
    private final ObservableList<QuestObjective> objectives;
    private final ObservableList<QuestObjective> objectivesReadOnly;
    @NotNull
    private final ReadOnlyObjectWrapper<QuestState> stateProp;

    @JvmOverloads
    public Quest(@NotNull String name, @NotNull PropertyMap vars) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(vars, "vars");
        this.vars = vars;
        this.log = Logger.Companion.get(this.getClass());
        this.nameProp = new SimpleStringProperty(name);
        this.objectives = FXCollections.observableArrayList();
        this.objectivesReadOnly = FXCollections.unmodifiableObservableList(this.objectives);
        this.stateProp = new ReadOnlyObjectWrapper<QuestState>(QuestState.NOT_STARTED);
    }

    public /* synthetic */ Quest(String string, PropertyMap propertyMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            propertyMap = new PropertyMap();
        }
        this(string, propertyMap);
    }

    @NotNull
    public final PropertyMap getVars() {
        return this.vars;
    }

    @NotNull
    public final String getName() {
        String string = this.nameProp.getValue();
        Intrinsics.checkNotNullExpressionValue(string, "nameProp.value");
        return string;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.nameProp.setValue(value);
    }

    @NotNull
    public final SimpleStringProperty nameProperty() {
        return this.nameProp;
    }

    @NotNull
    public final ObservableList<QuestObjective> objectivesProperty() {
        ObservableList<QuestObjective> observableList = this.objectivesReadOnly;
        Intrinsics.checkNotNullExpressionValue(observableList, "objectivesReadOnly");
        return observableList;
    }

    @NotNull
    public final QuestState getState() {
        Object t = this.stateProp.get();
        Intrinsics.checkNotNullExpressionValue(t, "stateProp.get()");
        return (QuestState)((Object)t);
    }

    @NotNull
    public final ReadOnlyObjectProperty<QuestState> stateProperty() {
        ReadOnlyObjectProperty<QuestState> readOnlyObjectProperty = this.stateProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue(readOnlyObjectProperty, "stateProp.readOnlyProperty");
        return readOnlyObjectProperty;
    }

    public final boolean isStarted() {
        return this.getState() != QuestState.NOT_STARTED;
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addIntObjective(@NotNull String desc, @NotNull String varName, int varValue, @NotNull Duration duration) {
        IntQuestObjective intQuestObjective;
        Intrinsics.checkNotNullParameter(desc, "desc");
        Intrinsics.checkNotNullParameter(varName, "varName");
        Intrinsics.checkNotNullParameter(duration, "duration");
        IntQuestObjective it = intQuestObjective = new IntQuestObjective(desc, this.vars, varName, varValue, duration);
        boolean bl = false;
        this.addObjective(it);
        return intQuestObjective;
    }

    public static /* synthetic */ QuestObjective addIntObjective$default(Quest quest, String string, String string2, int n, Duration duration, int n2, Object object) {
        if ((n2 & 8) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue(duration2, "ZERO");
            duration = duration2;
        }
        return quest.addIntObjective(string, string2, n, duration);
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addBooleanObjective(@NotNull String desc, @NotNull String varName, boolean varValue, @NotNull Duration duration) {
        BooleanQuestObjective booleanQuestObjective;
        Intrinsics.checkNotNullParameter(desc, "desc");
        Intrinsics.checkNotNullParameter(varName, "varName");
        Intrinsics.checkNotNullParameter(duration, "duration");
        BooleanQuestObjective it = booleanQuestObjective = new BooleanQuestObjective(desc, this.vars, varName, varValue, duration);
        boolean bl = false;
        this.addObjective(it);
        return booleanQuestObjective;
    }

    public static /* synthetic */ QuestObjective addBooleanObjective$default(Quest quest, String string, String string2, boolean bl, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue(duration2, "ZERO");
            duration = duration2;
        }
        return quest.addBooleanObjective(string, string2, bl, duration);
    }

    private final void addObjective(QuestObjective objective) {
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, "objectives");
        ((Collection)observableList).add(objective);
        if (this.isStarted()) {
            this.rebindStateToObjectives();
        }
    }

    public final void removeObjective(@NotNull QuestObjective objective) {
        Intrinsics.checkNotNullParameter(objective, "objective");
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, "objectives");
        ((Collection)observableList).remove(objective);
        if (this.isStarted()) {
            this.rebindStateToObjectives();
        }
    }

    public final void start$fxgl_gameplay() {
        if (this.objectives.isEmpty()) {
            this.log.warning("Cannot start quest " + this.getName() + " because it has no objectives");
            return;
        }
        if (this.isStarted()) {
            this.log.warning("Cannot start quest " + this.getName() + " because it has already been started");
            return;
        }
        this.rebindStateToObjectives();
    }

    @Override
    public void onUpdate(double tpf) {
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, "objectives");
        Iterable $this$forEach$iv = observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QuestObjective it = (QuestObjective)element$iv;
            boolean bl = false;
            it.onUpdate(tpf);
        }
    }

    public final void stop$fxgl_gameplay() {
        this.stateProp.unbind();
        this.stateProp.setValue(QuestState.NOT_STARTED);
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, "objectives");
        Iterable $this$forEach$iv = observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QuestObjective it = (QuestObjective)element$iv;
            boolean bl = false;
            it.unbindFromVars$fxgl_gameplay();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rebindStateToObjectives() {
        void $this$foldRight$iv;
        void $this$mapTo$iv$iv;
        Object state;
        void $this$foldRight$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        ObservableList<QuestObjective> observableList = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList, "objectives");
        Iterable $this$forEach$iv = observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            QuestObjective it = (QuestObjective)element$iv2;
            boolean bl = false;
            it.bindToVars$fxgl_gameplay();
        }
        ObservableList<QuestObjective> observableList2 = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList2, "objectives");
        Iterable $this$map$iv = observableList2;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            QuestObjective questObjective = (QuestObjective)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.stateProperty());
        }
        $this$map$iv = (List)destination$iv$iv;
        BooleanBinding initial$iv = Bindings.createBooleanBinding(Quest::rebindStateToObjectives$lambda$6, new Observable[0]);
        boolean $i$f$foldRight = false;
        Object accumulator$iv = initial$iv;
        if (!$this$foldRight$iv2.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv2.listIterator($this$foldRight$iv2.size());
            while (iterator$iv.hasPrevious()) {
                void binding;
                Object object = accumulator$iv;
                state = (ReadOnlyObjectProperty)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv = ((ObjectExpression)state).isEqualTo((Object)QuestState.FAILED).or((ObservableBooleanValue)binding);
            }
        }
        BooleanBinding failedBinding = accumulator$iv;
        ObservableList<QuestObjective> observableList3 = this.objectives;
        Intrinsics.checkNotNullExpressionValue(observableList3, "objectives");
        Iterable $this$map$iv2 = observableList3;
        boolean $i$f$map2 = false;
        accumulator$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            QuestObjective bl = (QuestObjective)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.stateProperty());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        BooleanBinding initial$iv2 = Bindings.createBooleanBinding(Quest::rebindStateToObjectives$lambda$9, new Observable[0]);
        boolean $i$f$foldRight2 = false;
        BooleanBinding accumulator$iv2 = initial$iv2;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void binding;
                state = accumulator$iv2;
                ReadOnlyObjectProperty state2 = (ReadOnlyObjectProperty)iterator$iv.previous();
                boolean bl = false;
                accumulator$iv2 = state2.isEqualTo((Object)QuestState.COMPLETED).and((ObservableBooleanValue)binding);
            }
        }
        BooleanBinding completedBinding = accumulator$iv2;
        ObjectBinding<QuestState> intermediateBinding = Bindings.when(completedBinding).then(QuestState.COMPLETED).otherwise(QuestState.ACTIVE);
        ObjectBinding<QuestState> finalBinding = Bindings.when(failedBinding).then(QuestState.FAILED).otherwise((QuestState)((Object)intermediateBinding));
        this.stateProp.bind((ObservableValue<QuestState>)finalBinding);
    }

    @JvmOverloads
    public Quest(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this(name, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addIntObjective(@NotNull String desc, @NotNull String varName, int varValue) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        Intrinsics.checkNotNullParameter(varName, "varName");
        return Quest.addIntObjective$default(this, desc, varName, varValue, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final QuestObjective addBooleanObjective(@NotNull String desc, @NotNull String varName, boolean varValue) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        Intrinsics.checkNotNullParameter(varName, "varName");
        return Quest.addBooleanObjective$default(this, desc, varName, varValue, null, 8, null);
    }

    private static final Boolean rebindStateToObjectives$lambda$6() {
        return false;
    }

    private static final Boolean rebindStateToObjectives$lambda$9() {
        return true;
    }
}

