/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.procedural;

import com.almasb.fxgl.core.collection.grid.Cell;
import com.almasb.fxgl.core.collection.grid.CellGenerator;
import com.almasb.fxgl.core.math.FXGLMath;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\r\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/procedural/HeightMapGenerator;", "Lcom/almasb/fxgl/core/collection/grid/CellGenerator;", "Lcom/almasb/fxgl/procedural/HeightMapGenerator$HeightData;", "width", "", "height", "frequency", "", "(IID)V", "getFrequency", "()D", "setFrequency", "(D)V", "getHeight", "()I", "getWidth", "apply", "x", "y", "HeightData", "fxgl-entity"})
public class HeightMapGenerator
implements CellGenerator<HeightData> {
    private final int width;
    private final int height;
    private double frequency;

    @JvmOverloads
    public HeightMapGenerator(int width, int height, double frequency) {
        this.width = width;
        this.height = height;
        this.frequency = frequency;
    }

    public /* synthetic */ HeightMapGenerator(int n, int n2, double d, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            d = 10.0;
        }
        this(n, n2, d);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final double getFrequency() {
        return this.frequency;
    }

    public final void setFrequency(double d) {
        this.frequency = d;
    }

    @Override
    @NotNull
    public HeightData apply(int x, int y) {
        double nx = (double)x * 1.0 / (double)this.width - 0.5;
        double ny = (double)y * 1.0 / (double)this.height - 0.5;
        double height = FXGLMath.noise2D(this.frequency * nx, this.frequency * ny);
        return new HeightData(x, y, height);
    }

    @JvmOverloads
    public HeightMapGenerator(int width, int height) {
        this(width, height, 0.0, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/procedural/HeightMapGenerator$HeightData;", "Lcom/almasb/fxgl/core/collection/grid/Cell;", "x", "", "y", "height", "", "(IID)V", "getHeight", "()D", "setHeight", "(D)V", "fxgl-entity"})
    public static final class HeightData
    extends Cell {
        private double height;

        public HeightData(int x, int y, double height) {
            super(x, y);
            this.height = height;
        }

        public final double getHeight() {
            return this.height;
        }

        public final void setHeight(double d) {
            this.height = d;
        }
    }
}

