/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.pooling;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.math.Vec3;
import com.almasb.fxgl.physics.box2d.collision.Collision;
import com.almasb.fxgl.physics.box2d.collision.Distance;
import com.almasb.fxgl.physics.box2d.collision.TimeOfImpact;
import com.almasb.fxgl.physics.box2d.common.Mat22;
import com.almasb.fxgl.physics.box2d.common.Mat33;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ChainAndCircleContact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ChainAndPolygonContact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.CircleContact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.EdgeAndCircleContact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.EdgeAndPolygonContact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.PolygonAndCircleContact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.PolygonContact;
import com.almasb.fxgl.physics.box2d.pooling.IDynamicStack;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;
import com.almasb.fxgl.physics.box2d.pooling.MutableStack;
import com.almasb.fxgl.physics.box2d.pooling.OrderedStack;
import java.util.HashMap;

public class DefaultWorldPool
implements IWorldPool {
    private static final int CONTACT_STACK_INIT_SIZE = 10;
    private final OrderedStack<Vec2> vecs;
    private final OrderedStack<Vec3> vec3s;
    private final OrderedStack<Mat22> mats;
    private final OrderedStack<Mat33> mat33s;
    private final OrderedStack<Rotation> rots;
    private final HashMap<Integer, Vec2[]> avecs = new HashMap();
    private final IWorldPool world = this;
    private final MutableStack<Contact> pcstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new PolygonContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new PolygonContact[size];
        }
    };
    private final MutableStack<Contact> ccstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new CircleContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new CircleContact[size];
        }
    };
    private final MutableStack<Contact> cpstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new PolygonAndCircleContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new PolygonAndCircleContact[size];
        }
    };
    private final MutableStack<Contact> ecstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new EdgeAndCircleContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new EdgeAndCircleContact[size];
        }
    };
    private final MutableStack<Contact> epstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new EdgeAndPolygonContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new EdgeAndPolygonContact[size];
        }
    };
    private final MutableStack<Contact> chcstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new ChainAndCircleContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new ChainAndCircleContact[size];
        }
    };
    private final MutableStack<Contact> chpstack = new MutableStack<Contact>(10){

        @Override
        protected Contact newInstance() {
            return new ChainAndPolygonContact(DefaultWorldPool.this.world);
        }

        protected Contact[] newArray(int size) {
            return new ChainAndPolygonContact[size];
        }
    };
    private final Collision collision;
    private final TimeOfImpact toi;
    private final Distance dist = new Distance();

    public DefaultWorldPool(int argSize, int argContainerSize) {
        this.vecs = new OrderedStack<Vec2>(this, argSize, argContainerSize){

            @Override
            protected Vec2 newInstance() {
                return new Vec2();
            }
        };
        this.vec3s = new OrderedStack<Vec3>(this, argSize, argContainerSize){

            @Override
            protected Vec3 newInstance() {
                return new Vec3();
            }
        };
        this.mats = new OrderedStack<Mat22>(this, argSize, argContainerSize){

            @Override
            protected Mat22 newInstance() {
                return new Mat22();
            }
        };
        this.rots = new OrderedStack<Rotation>(this, argSize, argContainerSize){

            @Override
            protected Rotation newInstance() {
                return new Rotation();
            }
        };
        this.mat33s = new OrderedStack<Mat33>(this, argSize, argContainerSize){

            @Override
            protected Mat33 newInstance() {
                return new Mat33();
            }
        };
        this.collision = new Collision();
        this.toi = new TimeOfImpact(this);
    }

    @Override
    public final IDynamicStack<Contact> getPolyContactStack() {
        return this.pcstack;
    }

    @Override
    public final IDynamicStack<Contact> getCircleContactStack() {
        return this.ccstack;
    }

    @Override
    public final IDynamicStack<Contact> getPolyCircleContactStack() {
        return this.cpstack;
    }

    @Override
    public IDynamicStack<Contact> getEdgeCircleContactStack() {
        return this.ecstack;
    }

    @Override
    public IDynamicStack<Contact> getEdgePolyContactStack() {
        return this.epstack;
    }

    @Override
    public IDynamicStack<Contact> getChainCircleContactStack() {
        return this.chcstack;
    }

    @Override
    public IDynamicStack<Contact> getChainPolyContactStack() {
        return this.chpstack;
    }

    @Override
    public final Vec2 popVec2() {
        return this.vecs.pop();
    }

    @Override
    public final Vec2[] popVec2(int argNum) {
        return this.vecs.pop(argNum);
    }

    @Override
    public final void pushVec2(int argNum) {
        this.vecs.push(argNum);
    }

    @Override
    public final Vec3 popVec3() {
        return this.vec3s.pop();
    }

    @Override
    public final Vec3[] popVec3(int argNum) {
        return this.vec3s.pop(argNum);
    }

    @Override
    public final void pushVec3(int argNum) {
        this.vec3s.push(argNum);
    }

    @Override
    public final Mat22 popMat22() {
        return this.mats.pop();
    }

    @Override
    public final Mat22[] popMat22(int argNum) {
        return this.mats.pop(argNum);
    }

    @Override
    public final void pushMat22(int argNum) {
        this.mats.push(argNum);
    }

    @Override
    public final Mat33 popMat33() {
        return this.mat33s.pop();
    }

    @Override
    public final void pushMat33(int argNum) {
        this.mat33s.push(argNum);
    }

    @Override
    public final Rotation popRot() {
        return this.rots.pop();
    }

    @Override
    public final void pushRot(int num) {
        this.rots.push(num);
    }

    @Override
    public final Collision getCollision() {
        return this.collision;
    }

    @Override
    public final TimeOfImpact getTimeOfImpact() {
        return this.toi;
    }

    @Override
    public final Distance getDistance() {
        return this.dist;
    }

    @Override
    public final Vec2[] getVec2Array(int argLength) {
        if (!this.avecs.containsKey(argLength)) {
            Vec2[] ray = new Vec2[argLength];
            for (int i2 = 0; i2 < argLength; ++i2) {
                ray[i2] = new Vec2();
            }
            this.avecs.put(argLength, ray);
        }
        assert (this.avecs.get(argLength).length == argLength) : "Array not built with correct length";
        return this.avecs.get(argLength);
    }
}

