/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.joints;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.SolverData;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Position;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Velocity;
import com.almasb.fxgl.physics.box2d.dynamics.joints.ConstantVolumeJointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.DistanceJoint;
import com.almasb.fxgl.physics.box2d.dynamics.joints.DistanceJointDef;
import com.almasb.fxgl.physics.box2d.dynamics.joints.Joint;

public class ConstantVolumeJoint
extends Joint {
    private final Body[] bodies;
    private float[] targetLengths;
    private float targetVolume;
    private Vec2[] normals;
    private float m_impulse = 0.0f;
    private World world;
    private DistanceJoint[] distanceJoints;

    public ConstantVolumeJoint(World argWorld, ConstantVolumeJointDef def) {
        super(argWorld.getPool(), def);
        this.world = argWorld;
        if (def.bodies.size() <= 2) {
            throw new IllegalArgumentException("You cannot create a constant volume joint with less than three bodies.");
        }
        this.bodies = def.bodies.toArray(new Body[0]);
        this.targetLengths = new float[this.bodies.length];
        for (int i2 = 0; i2 < this.targetLengths.length; ++i2) {
            float dist;
            int next = i2 == this.targetLengths.length - 1 ? 0 : i2 + 1;
            this.targetLengths[i2] = dist = this.bodies[i2].getWorldCenter().sub(this.bodies[next].getWorldCenter()).length();
        }
        this.targetVolume = this.getBodyArea();
        if (def.joints != null && def.joints.size() != def.bodies.size()) {
            throw new IllegalArgumentException("Incorrect joint definition. Joints have to correspond to the bodies");
        }
        if (def.joints == null) {
            DistanceJointDef djd = new DistanceJointDef();
            this.distanceJoints = new DistanceJoint[this.bodies.length];
            for (int i3 = 0; i3 < this.targetLengths.length; ++i3) {
                int next = i3 == this.targetLengths.length - 1 ? 0 : i3 + 1;
                djd.frequencyHz = def.frequencyHz;
                djd.dampingRatio = def.dampingRatio;
                djd.setBodyCollisionAllowed(def.isBodyCollisionAllowed());
                djd.initialize(this.bodies[i3], this.bodies[next], this.bodies[i3].getWorldCenter(), this.bodies[next].getWorldCenter());
                this.distanceJoints[i3] = this.world.createJoint(djd);
            }
        } else {
            this.distanceJoints = def.joints.toArray(new DistanceJoint[0]);
        }
        this.normals = new Vec2[this.bodies.length];
        for (int i4 = 0; i4 < this.normals.length; ++i4) {
            this.normals[i4] = new Vec2();
        }
    }

    @Override
    public void destructor() {
        for (int i2 = 0; i2 < this.distanceJoints.length; ++i2) {
            this.world.destroyJoint(this.distanceJoints[i2]);
        }
    }

    public Body[] getBodies() {
        return this.bodies;
    }

    public DistanceJoint[] getJoints() {
        return this.distanceJoints;
    }

    public void inflate(float factor) {
        this.targetVolume *= factor;
    }

    private float getBodyArea() {
        float area = 0.0f;
        for (int i2 = 0; i2 < this.bodies.length; ++i2) {
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            area += this.bodies[i2].getWorldCenter().x * this.bodies[next].getWorldCenter().y - this.bodies[next].getWorldCenter().x * this.bodies[i2].getWorldCenter().y;
        }
        return area *= 0.5f;
    }

    private float getSolverArea(Position[] positions) {
        float area = 0.0f;
        for (int i2 = 0; i2 < this.bodies.length; ++i2) {
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            area += positions[this.bodies[i2].m_islandIndex].c.x * positions[this.bodies[next].m_islandIndex].c.y - positions[this.bodies[next].m_islandIndex].c.x * positions[this.bodies[i2].m_islandIndex].c.y;
        }
        return area *= 0.5f;
    }

    private boolean constrainEdges(Position[] positions) {
        float perimeter = 0.0f;
        for (int i2 = 0; i2 < this.bodies.length; ++i2) {
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            float dx = positions[this.bodies[next].m_islandIndex].c.x - positions[this.bodies[i2].m_islandIndex].c.x;
            float dy = positions[this.bodies[next].m_islandIndex].c.y - positions[this.bodies[i2].m_islandIndex].c.y;
            float dist = FXGLMath.sqrtF(dx * dx + dy * dy);
            if (dist < 1.1920929E-7f) {
                dist = 1.0f;
            }
            this.normals[i2].x = dy / dist;
            this.normals[i2].y = -dx / dist;
            perimeter += dist;
        }
        Vec2 delta = this.pool.popVec2();
        float deltaArea = this.targetVolume - this.getSolverArea(positions);
        float toExtrude = 0.5f * deltaArea / perimeter;
        boolean done = true;
        for (int i3 = 0; i3 < this.bodies.length; ++i3) {
            int next = i3 == this.bodies.length - 1 ? 0 : i3 + 1;
            delta.set(toExtrude * (this.normals[i3].x + this.normals[next].x), toExtrude * (this.normals[i3].y + this.normals[next].y));
            float normSqrd = delta.lengthSquared();
            if (normSqrd > JBoxSettings.maxLinearCorrection * JBoxSettings.maxLinearCorrection) {
                delta.mulLocal(JBoxSettings.maxLinearCorrection / FXGLMath.sqrtF(normSqrd));
            }
            if (normSqrd > JBoxSettings.linearSlop * JBoxSettings.linearSlop) {
                done = false;
            }
            positions[this.bodies[next].m_islandIndex].c.x += delta.x;
            positions[this.bodies[next].m_islandIndex].c.y += delta.y;
        }
        this.pool.pushVec2(1);
        return done;
    }

    @Override
    public void initVelocityConstraints(SolverData step) {
        int i2;
        Velocity[] velocities = step.velocities;
        Position[] positions = step.positions;
        Vec2[] d = this.pool.getVec2Array(this.bodies.length);
        for (i2 = 0; i2 < this.bodies.length; ++i2) {
            int prev = i2 == 0 ? this.bodies.length - 1 : i2 - 1;
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            d[i2].set(positions[this.bodies[next].m_islandIndex].c);
            d[i2].subLocal(positions[this.bodies[prev].m_islandIndex].c);
        }
        if (step.step.warmStarting) {
            this.m_impulse *= step.step.dtRatio;
            for (i2 = 0; i2 < this.bodies.length; ++i2) {
                velocities[this.bodies[i2].m_islandIndex].v.x += this.bodies[i2].m_invMass * d[i2].y * 0.5f * this.m_impulse;
                velocities[this.bodies[i2].m_islandIndex].v.y += this.bodies[i2].m_invMass * -d[i2].x * 0.5f * this.m_impulse;
            }
        } else {
            this.m_impulse = 0.0f;
        }
    }

    @Override
    public boolean solvePositionConstraints(SolverData step) {
        return this.constrainEdges(step.positions);
    }

    @Override
    public void solveVelocityConstraints(SolverData step) {
        float crossMassSum = 0.0f;
        float dotMassSum = 0.0f;
        Velocity[] velocities = step.velocities;
        Position[] positions = step.positions;
        Vec2[] d = this.pool.getVec2Array(this.bodies.length);
        for (int i2 = 0; i2 < this.bodies.length; ++i2) {
            int prev = i2 == 0 ? this.bodies.length - 1 : i2 - 1;
            int next = i2 == this.bodies.length - 1 ? 0 : i2 + 1;
            d[i2].set(positions[this.bodies[next].m_islandIndex].c);
            d[i2].subLocal(positions[this.bodies[prev].m_islandIndex].c);
            dotMassSum += d[i2].lengthSquared() / this.bodies[i2].getMass();
            crossMassSum += Vec2.cross(velocities[this.bodies[i2].m_islandIndex].v, d[i2]);
        }
        float lambda = -2.0f * crossMassSum / dotMassSum;
        this.m_impulse += lambda;
        for (int i3 = 0; i3 < this.bodies.length; ++i3) {
            velocities[this.bodies[i3].m_islandIndex].v.x += this.bodies[i3].m_invMass * d[i3].y * 0.5f * lambda;
            velocities[this.bodies[i3].m_islandIndex].v.y += this.bodies[i3].m_invMass * -d[i3].x * 0.5f * lambda;
        }
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return 0.0f;
    }
}

