/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.callbacks.ContactImpulse;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.Sweep;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.SolverData;
import com.almasb.fxgl.physics.box2d.dynamics.TimeStep;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactEdge;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactSolver;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactVelocityConstraint;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Position;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Velocity;
import com.almasb.fxgl.physics.box2d.dynamics.joints.Joint;

class Island {
    private ContactListener listener;
    private Body[] bodies;
    private Contact[] contacts;
    private Joint[] joints;
    private Position[] positions;
    private Velocity[] velocities;
    private int bodyCount;
    private int jointCount;
    private int contactCount;
    private int bodyCapacity;
    private int contactCapacity;
    private final ContactSolver contactSolver = new ContactSolver();
    private final SolverData solverData = new SolverData();
    private final ContactSolver.ContactSolverDef solverDef = new ContactSolver.ContactSolverDef();
    private final ContactSolver toiContactSolver = new ContactSolver();
    private final ContactSolver.ContactSolverDef toiSolverDef = new ContactSolver.ContactSolverDef();
    private final ContactImpulse impulse = new ContactImpulse();

    Island() {
    }

    void init(int bodyCapacity, int contactCapacity, int jointCapacity, ContactListener listener2) {
        int i2;
        Object[] old;
        this.bodyCapacity = bodyCapacity;
        this.contactCapacity = contactCapacity;
        this.listener = listener2;
        this.clear();
        if (this.bodies == null || bodyCapacity > this.bodies.length) {
            this.bodies = new Body[bodyCapacity];
        }
        if (this.joints == null || jointCapacity > this.joints.length) {
            this.joints = new Joint[jointCapacity];
        }
        if (this.contacts == null || contactCapacity > this.contacts.length) {
            this.contacts = new Contact[contactCapacity];
        }
        if (this.velocities == null || bodyCapacity > this.velocities.length) {
            old = this.velocities == null ? new Velocity[]{} : this.velocities;
            this.velocities = new Velocity[bodyCapacity];
            System.arraycopy(old, 0, this.velocities, 0, old.length);
            for (i2 = old.length; i2 < this.velocities.length; ++i2) {
                this.velocities[i2] = new Velocity();
            }
        }
        if (this.positions == null || bodyCapacity > this.positions.length) {
            old = this.positions == null ? new Position[]{} : this.positions;
            this.positions = new Position[bodyCapacity];
            System.arraycopy(old, 0, this.positions, 0, old.length);
            for (i2 = old.length; i2 < this.positions.length; ++i2) {
                this.positions[i2] = new Position();
            }
        }
    }

    void clear() {
        this.bodyCount = 0;
        this.contactCount = 0;
        this.jointCount = 0;
    }

    void solve(TimeStep step, Vec2 gravity, boolean allowSleep) {
        int i2;
        int i3;
        float h = step.dt;
        for (i3 = 0; i3 < this.bodyCount; ++i3) {
            Body b = this.bodies[i3];
            Sweep bm_sweep = b.m_sweep;
            Vec2 c = bm_sweep.c;
            float a = bm_sweep.a;
            Vec2 v = b.getLinearVelocity();
            float w = b.getAngularVelocity();
            bm_sweep.c0.set(bm_sweep.c);
            bm_sweep.a0 = bm_sweep.a;
            if (b.getType() == BodyType.DYNAMIC) {
                v.x += h * (b.getGravityScale() * gravity.x + b.m_invMass * b.getForce().x);
                v.y += h * (b.getGravityScale() * gravity.y + b.m_invMass * b.getForce().y);
                w += h * b.m_invI * b.getTorque();
                v.x *= 1.0f / (1.0f + h * b.getLinearDamping());
                v.y *= 1.0f / (1.0f + h * b.getLinearDamping());
                w *= 1.0f / (1.0f + h * b.getAngularDamping());
            }
            this.positions[i3].c.x = c.x;
            this.positions[i3].c.y = c.y;
            this.positions[i3].a = a;
            this.velocities[i3].v.x = v.x;
            this.velocities[i3].v.y = v.y;
            this.velocities[i3].w = w;
        }
        this.solverData.step = step;
        this.solverData.positions = this.positions;
        this.solverData.velocities = this.velocities;
        this.solverDef.step = step;
        this.solverDef.contacts = this.contacts;
        this.solverDef.count = this.contactCount;
        this.solverDef.positions = this.positions;
        this.solverDef.velocities = this.velocities;
        this.contactSolver.init(this.solverDef);
        this.contactSolver.initializeVelocityConstraints();
        if (step.warmStarting) {
            this.contactSolver.warmStart();
        }
        for (i3 = 0; i3 < this.jointCount; ++i3) {
            this.joints[i3].initVelocityConstraints(this.solverData);
        }
        for (i3 = 0; i3 < step.velocityIterations; ++i3) {
            for (int j = 0; j < this.jointCount; ++j) {
                this.joints[j].solveVelocityConstraints(this.solverData);
            }
            this.contactSolver.solveVelocityConstraints();
        }
        this.contactSolver.storeImpulses();
        for (i3 = 0; i3 < this.bodyCount; ++i3) {
            float w;
            float rotation;
            Vec2 v = this.velocities[i3].v;
            float tX = v.x * h;
            float tY = v.y * h;
            float translationSquared = tX * tX + tY * tY;
            if (translationSquared > JBoxSettings.maxTranslationSquared) {
                float ratio = JBoxSettings.maxTranslation / FXGLMath.sqrtF(translationSquared);
                v.mulLocal(ratio);
            }
            if ((rotation = h * (w = this.velocities[i3].w)) * rotation > JBoxSettings.maxRotationSquared) {
                float ratio = JBoxSettings.maxRotation / FXGLMath.abs(rotation);
                w *= ratio;
            }
            Vec2 c = this.positions[i3].c;
            c.x += h * v.x;
            c.y += h * v.y;
            this.positions[i3].a += h * w;
            this.velocities[i3].w = w;
        }
        boolean positionSolved = false;
        for (i2 = 0; i2 < step.positionIterations; ++i2) {
            boolean contactsOkay = this.contactSolver.solvePositionConstraints();
            boolean jointsOkay = true;
            for (int j = 0; j < this.jointCount; ++j) {
                boolean jointOkay = this.joints[j].solvePositionConstraints(this.solverData);
                jointsOkay = jointsOkay && jointOkay;
            }
            if (!contactsOkay || !jointsOkay) continue;
            positionSolved = true;
            break;
        }
        for (i2 = 0; i2 < this.bodyCount; ++i2) {
            Body body2 = this.bodies[i2];
            body2.m_sweep.c.x = this.positions[i2].c.x;
            body2.m_sweep.c.y = this.positions[i2].c.y;
            body2.m_sweep.a = this.positions[i2].a;
            body2.setLinearVelocityDirectly(this.velocities[i2].v.x, this.velocities[i2].v.y);
            body2.setAngularVelocityDirectly(this.velocities[i2].w);
            body2.synchronizeTransform();
        }
        this.report(this.contactSolver.getVelocityConstraints());
        if (allowSleep) {
            int i4;
            float minSleepTime = Float.MAX_VALUE;
            float linTolSqr = JBoxSettings.linearSleepTolerance * JBoxSettings.linearSleepTolerance;
            float angTolSqr = JBoxSettings.angularSleepTolerance * JBoxSettings.angularSleepTolerance;
            for (i4 = 0; i4 < this.bodyCount; ++i4) {
                Body b = this.bodies[i4];
                if (b.getType() == BodyType.STATIC) continue;
                if (!b.isSleepingAllowed() || b.getAngularVelocity() * b.getAngularVelocity() > angTolSqr || Vec2.dot(b.getLinearVelocity(), b.getLinearVelocity()) > linTolSqr) {
                    b.setSleepTime(0.0f);
                    minSleepTime = 0.0f;
                    continue;
                }
                b.setSleepTime(b.getSleepTime() + h);
                minSleepTime = Math.min(minSleepTime, b.getSleepTime());
            }
            if (minSleepTime >= JBoxSettings.timeToSleep && positionSolved) {
                for (i4 = 0; i4 < this.bodyCount; ++i4) {
                    Body b = this.bodies[i4];
                    b.setAwake(false);
                }
            }
        }
    }

    void solveTOI(TimeStep subStep, int toiIndexA, int toiIndexB) {
        boolean contactsOkay;
        int i2;
        assert (toiIndexA < this.bodyCount);
        assert (toiIndexB < this.bodyCount);
        for (i2 = 0; i2 < this.bodyCount; ++i2) {
            this.positions[i2].c.x = this.bodies[i2].m_sweep.c.x;
            this.positions[i2].c.y = this.bodies[i2].m_sweep.c.y;
            this.positions[i2].a = this.bodies[i2].m_sweep.a;
            this.velocities[i2].v.x = this.bodies[i2].getLinearVelocity().x;
            this.velocities[i2].v.y = this.bodies[i2].getLinearVelocity().y;
            this.velocities[i2].w = this.bodies[i2].getAngularVelocity();
        }
        this.toiSolverDef.contacts = this.contacts;
        this.toiSolverDef.count = this.contactCount;
        this.toiSolverDef.step = subStep;
        this.toiSolverDef.positions = this.positions;
        this.toiSolverDef.velocities = this.velocities;
        this.toiContactSolver.init(this.toiSolverDef);
        for (i2 = 0; i2 < subStep.positionIterations && !(contactsOkay = this.toiContactSolver.solveTOIPositionConstraints(toiIndexA, toiIndexB)); ++i2) {
        }
        this.bodies[toiIndexA].m_sweep.c0.x = this.positions[toiIndexA].c.x;
        this.bodies[toiIndexA].m_sweep.c0.y = this.positions[toiIndexA].c.y;
        this.bodies[toiIndexA].m_sweep.a0 = this.positions[toiIndexA].a;
        this.bodies[toiIndexB].m_sweep.c0.set(this.positions[toiIndexB].c);
        this.bodies[toiIndexB].m_sweep.a0 = this.positions[toiIndexB].a;
        this.toiContactSolver.initializeVelocityConstraints();
        for (i2 = 0; i2 < subStep.velocityIterations; ++i2) {
            this.toiContactSolver.solveVelocityConstraints();
        }
        float h = subStep.dt;
        for (int i3 = 0; i3 < this.bodyCount; ++i3) {
            float w;
            float rotation;
            Vec2 v = this.velocities[i3].v;
            float tX = v.x * h;
            float tY = v.y * h;
            float translationSquared = tX * tX + tY * tY;
            if (translationSquared > JBoxSettings.maxTranslationSquared) {
                float ratio = JBoxSettings.maxTranslation / FXGLMath.sqrtF(translationSquared);
                v.mulLocal(ratio);
            }
            if ((rotation = h * (w = this.velocities[i3].w)) * rotation > JBoxSettings.maxRotationSquared) {
                float ratio = JBoxSettings.maxRotation / FXGLMath.abs(rotation);
                w *= ratio;
            }
            Vec2 c = this.positions[i3].c;
            c.x += v.x * h;
            c.y += v.y * h;
            float a = this.positions[i3].a;
            this.positions[i3].c.x = c.x;
            this.positions[i3].c.y = c.y;
            this.positions[i3].a = a += h * w;
            this.velocities[i3].v.x = v.x;
            this.velocities[i3].v.y = v.y;
            this.velocities[i3].w = w;
            Body body2 = this.bodies[i3];
            body2.m_sweep.c.x = c.x;
            body2.m_sweep.c.y = c.y;
            body2.m_sweep.a = a;
            body2.setLinearVelocityDirectly(v.x, v.y);
            body2.setAngularVelocityDirectly(w);
            body2.synchronizeTransform();
        }
        this.report(this.toiContactSolver.getVelocityConstraints());
    }

    void add(Body body2) {
        body2.m_islandIndex = this.bodyCount;
        this.bodies[this.bodyCount] = body2;
        ++this.bodyCount;
    }

    void add(Contact contact) {
        this.contacts[this.contactCount++] = contact;
    }

    void add(Joint joint) {
        this.joints[this.jointCount++] = joint;
    }

    boolean isBodyCountEqualToCapacity() {
        return this.bodyCount == this.bodyCapacity;
    }

    boolean isContactCountEqualToCapacity() {
        return this.contactCount == this.contactCapacity;
    }

    private void report(ContactVelocityConstraint[] constraints) {
        if (this.listener == null) {
            return;
        }
        for (int i2 = 0; i2 < this.contactCount; ++i2) {
            Contact c = this.contacts[i2];
            ContactVelocityConstraint vc = constraints[i2];
            this.impulse.count = vc.pointCount;
            for (int j = 0; j < vc.pointCount; ++j) {
                this.impulse.normalImpulses[j] = vc.points[j].normalImpulse;
                this.impulse.tangentImpulses[j] = vc.points[j].tangentImpulse;
            }
            this.listener.postSolve(c, this.impulse);
        }
    }

    void resetFlagsAndSynchronizeBroadphaseProxies() {
        for (int i2 = 0; i2 < this.bodyCount; ++i2) {
            Body body2 = this.bodies[i2];
            body2.setIslandFlag(false);
            if (body2.getType() != BodyType.DYNAMIC) continue;
            body2.synchronizeFixtures();
            ContactEdge ce = body2.m_contactList;
            while (ce != null) {
                ce.contact.m_flags &= 0xFFFFFFDE;
                ce = ce.next;
            }
        }
    }

    void postSolveCleanup() {
        for (int i2 = 0; i2 < this.bodyCount; ++i2) {
            Body b = this.bodies[i2];
            if (b.getType() != BodyType.STATIC) continue;
            b.setIslandFlag(false);
        }
    }
}

