/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.common;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import java.io.Serializable;

public final class Rotation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float[] sinLUT = new float[JBoxSettings.SINCOS_LUT_LENGTH];
    public float s;
    public float c;

    public Rotation() {
        this.setIdentity();
    }

    public Rotation(float angle) {
        this.set(angle);
    }

    public Rotation set(float angle) {
        this.s = Rotation.sin(angle);
        this.c = Rotation.cos(angle);
        return this;
    }

    public Rotation set(Rotation other) {
        this.s = other.s;
        this.c = other.c;
        return this;
    }

    public Rotation setIdentity() {
        this.s = 0.0f;
        this.c = 1.0f;
        return this;
    }

    public float getAngle() {
        return (float)FXGLMath.atan2(this.s, this.c);
    }

    public String toString() {
        return "Rot(s:" + this.s + ", c:" + this.c + ")";
    }

    public static void mul(Rotation q, Rotation r, Rotation out) {
        float tempc = q.c * r.c - q.s * r.s;
        out.s = q.s * r.c + q.c * r.s;
        out.c = tempc;
    }

    public static void mulUnsafe(Rotation q, Rotation r, Rotation out) {
        assert (r != out);
        assert (q != out);
        out.s = q.s * r.c + q.c * r.s;
        out.c = q.c * r.c - q.s * r.s;
    }

    public static void mulTrans(Rotation q, Rotation r, Rotation out) {
        float tempc = q.c * r.c + q.s * r.s;
        out.s = q.c * r.s - q.s * r.c;
        out.c = tempc;
    }

    public static void mulTransUnsafe(Rotation q, Rotation r, Rotation out) {
        out.s = q.c * r.s - q.s * r.c;
        out.c = q.c * r.c + q.s * r.s;
    }

    public static void mulToOut(Rotation q, Vec2 v, Vec2 out) {
        float tempy = q.s * v.x + q.c * v.y;
        out.x = q.c * v.x - q.s * v.y;
        out.y = tempy;
    }

    public static void mulToOutUnsafe(Rotation q, Vec2 v, Vec2 out) {
        out.x = q.c * v.x - q.s * v.y;
        out.y = q.s * v.x + q.c * v.y;
    }

    public static void mulTrans(Rotation q, Vec2 v, Vec2 out) {
        float tempy = -q.s * v.x + q.c * v.y;
        out.x = q.c * v.x + q.s * v.y;
        out.y = tempy;
    }

    public static void mulTransUnsafe(Rotation q, Vec2 v, Vec2 out) {
        out.x = q.c * v.x + q.s * v.y;
        out.y = -q.s * v.x + q.c * v.y;
    }

    private static float sin(float x) {
        return Rotation.sinLUT(x);
    }

    private static float cos(float x) {
        return Rotation.sinLUT(1.5707964f - x);
    }

    private static float sinLUT(float x) {
        if ((x %= (float)Math.PI * 2) < 0.0f) {
            x += (float)Math.PI * 2;
        }
        return sinLUT[FXGLMath.floor(x / 1.1E-4f + 0.5f) % JBoxSettings.SINCOS_LUT_LENGTH];
    }

    static {
        for (int i2 = 0; i2 < JBoxSettings.SINCOS_LUT_LENGTH; ++i2) {
            Rotation.sinLUT[i2] = (float)Math.sin((float)i2 * 1.1E-4f);
        }
    }
}

