/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.common;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.math.Vec3;
import java.io.Serializable;

public final class Mat33
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final Vec3 ex = new Vec3();
    public final Vec3 ey = new Vec3();
    public final Vec3 ez = new Vec3();

    public static void mul22ToOutUnsafe(Mat33 A, Vec2 v, Vec2 out) {
        assert (v != out);
        out.y = A.ex.y * v.x + A.ey.y * v.y;
        out.x = A.ex.x * v.x + A.ey.x * v.y;
    }

    public static void mulToOutUnsafe(Mat33 A, Vec3 v, Vec3 out) {
        assert (out != v);
        out.x = v.x * A.ex.x + v.y * A.ey.x + v.z * A.ez.x;
        out.y = v.x * A.ex.y + v.y * A.ey.y + v.z * A.ez.y;
        out.z = v.x * A.ex.z + v.y * A.ey.z + v.z * A.ez.z;
    }

    public void solve22ToOut(Vec2 b, Vec2 out) {
        float a11 = this.ex.x;
        float a22 = this.ey.y;
        float a12 = this.ey.x;
        float a21 = this.ex.y;
        float det = a11 * a22 - a12 * a21;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        out.x = det * (a22 * b.x - a12 * b.y);
        out.y = det * (a11 * b.y - a21 * b.x);
    }

    public void solve33ToOut(Vec3 b, Vec3 out) {
        assert (b != out);
        Mat33.crossToOutUnsafe(this.ey, this.ez, out);
        float det = Vec3.dot(this.ex, out);
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        Mat33.crossToOutUnsafe(this.ey, this.ez, out);
        float x = det * Vec3.dot(b, out);
        Mat33.crossToOutUnsafe(b, this.ez, out);
        float y = det * Vec3.dot(this.ex, out);
        Mat33.crossToOutUnsafe(this.ey, b, out);
        float z = det * Vec3.dot(this.ex, out);
        out.x = x;
        out.y = y;
        out.z = z;
    }

    public void getInverse22(Mat33 M) {
        float a = this.ex.x;
        float d = this.ey.y;
        float b = this.ey.x;
        float c = this.ex.y;
        float det = a * d - b * c;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        M.ex.x = det * d;
        M.ey.x = -det * b;
        M.ex.z = 0.0f;
        M.ex.y = -det * c;
        M.ey.y = det * a;
        M.ey.z = 0.0f;
        M.ez.x = 0.0f;
        M.ez.y = 0.0f;
        M.ez.z = 0.0f;
    }

    public void getSymInverse33(Mat33 M) {
        float bx = this.ey.y * this.ez.z - this.ey.z * this.ez.y;
        float by = this.ey.z * this.ez.x - this.ey.x * this.ez.z;
        float bz = this.ey.x * this.ez.y - this.ey.y * this.ez.x;
        float det = this.ex.x * bx + this.ex.y * by + this.ex.z * bz;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        float a11 = this.ex.x;
        float a12 = this.ey.x;
        float a13 = this.ez.x;
        float a22 = this.ey.y;
        float a23 = this.ez.y;
        float a33 = this.ez.z;
        M.ex.x = det * (a22 * a33 - a23 * a23);
        M.ex.y = det * (a13 * a23 - a12 * a33);
        M.ex.z = det * (a12 * a23 - a13 * a22);
        M.ey.x = M.ex.y;
        M.ey.y = det * (a11 * a33 - a13 * a13);
        M.ey.z = det * (a13 * a12 - a11 * a23);
        M.ez.x = M.ex.z;
        M.ez.y = M.ey.z;
        M.ez.z = det * (a11 * a22 - a12 * a12);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ex.hashCode();
        result = 31 * result + this.ey.hashCode();
        result = 31 * result + this.ez.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mat33 other = (Mat33)obj;
        if (!this.ex.equals(other.ex)) {
            return false;
        }
        if (!this.ey.equals(other.ey)) {
            return false;
        }
        return this.ez.equals(other.ez);
    }

    private static void crossToOutUnsafe(Vec3 a, Vec3 b, Vec3 out) {
        assert (out != b);
        assert (out != a);
        out.x = a.y * b.z - a.z * b.y;
        out.y = a.z * b.x - a.x * b.z;
        out.z = a.x * b.y - a.y * b.x;
    }
}

