/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.shapes;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.collision.shapes.MassData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.common.Transform;

public final class CircleShape
extends Shape {
    public final Vec2 center = new Vec2();

    public CircleShape(float radius) {
        this(0.0f, 0.0f, radius);
    }

    public CircleShape(Vec2 center, float radius) {
        this(center.x, center.y, radius);
    }

    public CircleShape(float centerX, float centerY, float radius) {
        super(ShapeType.CIRCLE, radius);
        this.center.set(centerX, centerY);
    }

    @Override
    public Shape clone() {
        return new CircleShape(this.center, this.getRadius());
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public boolean containsPoint(Transform transform, Vec2 point) {
        Rotation q = transform.q;
        Vec2 tp = transform.p;
        float centerx = -(q.c * this.center.x - q.s * this.center.y + tp.x - point.x);
        float centery = -(q.s * this.center.x + q.c * this.center.y + tp.y - point.y);
        return centerx * centerx + centery * centery <= this.getRadius() * this.getRadius();
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        Rotation xfq = xf.q;
        float centerx = xfq.c * this.center.x - xfq.s * this.center.y + xf.p.x;
        float centery = xfq.s * this.center.x + xfq.c * this.center.y + xf.p.y;
        float dx = p.x - centerx;
        float dy = p.y - centery;
        float d1 = FXGLMath.sqrtF(dx * dx + dy * dy);
        normalOut.x = dx * 1.0f / d1;
        normalOut.y = dy * 1.0f / d1;
        return d1 - this.getRadius();
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform transform, int childIndex) {
        Vec2 inputp1 = input.p1;
        Vec2 inputp2 = input.p2;
        Rotation tq = transform.q;
        Vec2 tp = transform.p;
        float positionx = tq.c * this.center.x - tq.s * this.center.y + tp.x;
        float sx = inputp1.x - positionx;
        float rx = inputp2.x - inputp1.x;
        float positiony = tq.s * this.center.x + tq.c * this.center.y + tp.y;
        float sy = inputp1.y - positiony;
        float ry = inputp2.y - inputp1.y;
        float c = sx * rx + sy * ry;
        float rr = rx * rx + ry * ry;
        float b = sx * sx + sy * sy - this.getRadius() * this.getRadius();
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return false;
        }
        float a = -(c + FXGLMath.sqrtF(sigma));
        if (0.0f <= a && a <= input.maxFraction * rr) {
            output.fraction = a /= rr;
            output.normal.x = rx * a + sx;
            output.normal.y = ry * a + sy;
            output.normal.getLengthAndNormalize();
            return true;
        }
        return false;
    }

    @Override
    public void computeAABB(AABB aabb, Transform transform, int childIndex) {
        float px = transform.mulX(this.center);
        float py = transform.mulY(this.center);
        aabb.lowerBound.x = px - this.getRadius();
        aabb.lowerBound.y = py - this.getRadius();
        aabb.upperBound.x = px + this.getRadius();
        aabb.upperBound.y = py + this.getRadius();
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = density * (float)Math.PI * this.getRadius() * this.getRadius();
        massData.center.x = this.center.x;
        massData.center.y = this.center.y;
        massData.I = massData.mass * (0.5f * this.getRadius() * this.getRadius() + this.center.x * this.center.x + this.center.y * this.center.y);
    }
}

