/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.shapes;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.collision.shapes.ChainType;
import com.almasb.fxgl.physics.box2d.collision.shapes.EdgeShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.MassData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.Transform;

public final class ChainShape
extends Shape {
    private Vec2[] m_vertices = null;
    private int m_count = 0;
    private final Vec2 prevVertex = new Vec2();
    private final Vec2 nextVertex = new Vec2();
    private boolean hasPrevVertex = false;
    private boolean hasNextVertex = false;
    private final EdgeShape pool0 = new EdgeShape();

    public ChainShape(ChainType type, Vec2[] initialVertices) {
        super(ShapeType.CHAIN, JBoxSettings.polygonRadius);
        if (type == ChainType.CLOSED) {
            this.createLoop(initialVertices, initialVertices.length);
        } else {
            this.createChain(initialVertices, initialVertices.length);
        }
    }

    @Override
    public Shape clone() {
        ChainShape clone = new ChainShape(ChainType.OPEN, this.m_vertices);
        clone.prevVertex.set(this.prevVertex);
        clone.nextVertex.set(this.nextVertex);
        clone.hasPrevVertex = this.hasPrevVertex;
        clone.hasNextVertex = this.hasNextVertex;
        return clone;
    }

    @Override
    public int getChildCount() {
        return this.m_count - 1;
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        EdgeShape edge = this.pool0;
        this.getChildEdge(edge, childIndex);
        return edge.computeDistanceToOut(xf, p, 0, normalOut);
    }

    @Override
    public boolean containsPoint(Transform xf, Vec2 point) {
        return false;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.m_count) {
            i2 = 0;
        }
        EdgeShape edgeShape = this.pool0;
        edgeShape.m_vertex1.set(this.m_vertices[i1]);
        edgeShape.m_vertex2.set(this.m_vertices[i2]);
        return edgeShape.raycast(output, input, xf, 0);
    }

    @Override
    public void computeAABB(AABB aabb, Transform transform, int childIndex) {
        Vec2 lower = aabb.lowerBound;
        Vec2 upper = aabb.upperBound;
        int i1 = childIndex;
        int i2 = childIndex + 1;
        if (i2 == this.m_count) {
            i2 = 0;
        }
        Vec2 vi1 = this.m_vertices[i1];
        Vec2 vi2 = this.m_vertices[i2];
        float v1x = transform.mulX(vi1);
        float v1y = transform.mulY(vi1);
        float v2x = transform.mulX(vi2);
        float v2y = transform.mulY(vi2);
        lower.x = FXGLMath.min(v1x, v2x);
        lower.y = FXGLMath.min(v1y, v2y);
        upper.x = FXGLMath.max(v1x, v2x);
        upper.y = FXGLMath.max(v1y, v2y);
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = 0.0f;
        massData.center.setZero();
        massData.I = 0.0f;
    }

    public void getChildEdge(EdgeShape edge, int index) {
        assert (0 <= index && index < this.m_count - 1);
        edge.setRadius(this.getRadius());
        edge.m_vertex1.set(this.m_vertices[index + 0]);
        edge.m_vertex2.set(this.m_vertices[index + 1]);
        if (index > 0) {
            edge.m_vertex0.set(this.m_vertices[index - 1]);
            edge.m_hasVertex0 = true;
        } else {
            edge.m_vertex0.set(this.prevVertex);
            edge.m_hasVertex0 = this.hasPrevVertex;
        }
        if (index < this.m_count - 2) {
            edge.m_vertex3.set(this.m_vertices[index + 2]);
            edge.m_hasVertex3 = true;
        } else {
            edge.m_vertex3.set(this.nextVertex);
            edge.m_hasVertex3 = this.hasNextVertex;
        }
    }

    private void createLoop(Vec2[] vertices2, int count) {
        int i2;
        assert (this.m_vertices == null && this.m_count == 0);
        assert (count >= 3);
        this.m_count = count + 1;
        this.m_vertices = new Vec2[this.m_count];
        for (i2 = 1; i2 < count; ++i2) {
            Vec2 v1 = vertices2[i2 - 1];
            Vec2 v2 = vertices2[i2];
            if (!(v1.distanceSquared(v2) < JBoxSettings.linearSlop * JBoxSettings.linearSlop)) continue;
            throw new RuntimeException("Vertices of chain shape are too close together");
        }
        for (i2 = 0; i2 < count; ++i2) {
            this.m_vertices[i2] = new Vec2(vertices2[i2]);
        }
        this.m_vertices[count] = new Vec2(this.m_vertices[0]);
        this.prevVertex.set(this.m_vertices[this.m_count - 2]);
        this.nextVertex.set(this.m_vertices[1]);
        this.hasPrevVertex = true;
        this.hasNextVertex = true;
    }

    private void createChain(Vec2[] vertices2, int count) {
        int i2;
        assert (this.m_vertices == null && this.m_count == 0);
        assert (count >= 2);
        this.m_count = count;
        this.m_vertices = new Vec2[this.m_count];
        for (i2 = 1; i2 < this.m_count; ++i2) {
            Vec2 v1 = vertices2[i2 - 1];
            Vec2 v2 = vertices2[i2];
            if (!(v1.distanceSquared(v2) < JBoxSettings.linearSlop * JBoxSettings.linearSlop)) continue;
            throw new RuntimeException("Vertices of chain shape are too close together");
        }
        for (i2 = 0; i2 < this.m_count; ++i2) {
            this.m_vertices[i2] = new Vec2(vertices2[i2]);
        }
        this.hasPrevVertex = false;
        this.hasNextVertex = false;
        this.prevVertex.setZero();
        this.nextVertex.setZero();
    }

    public void setPrevVertex(Vec2 prevVertex) {
        this.prevVertex.set(prevVertex);
        this.hasPrevVertex = true;
    }

    public void setNextVertex(Vec2 nextVertex) {
        this.nextVertex.set(nextVertex);
        this.hasNextVertex = true;
    }

    public int getCount() {
        return this.m_count;
    }

    public Vec2 getVertex(int index) {
        return this.m_vertices[index];
    }
}

