/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.broadphase;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.callbacks.PairCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeRayCastCallback;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhase;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhaseStrategy;
import com.almasb.fxgl.physics.box2d.collision.broadphase.Pair;
import java.util.Arrays;

public final class DefaultBroadPhaseBuffer
implements TreeCallback,
BroadPhase {
    private final BroadPhaseStrategy tree;
    private int moveCapacity = 16;
    private int[] moveBuffer = new int[this.moveCapacity];
    private int moveCount = 0;
    private int pairCapacity = 16;
    private Pair[] pairBuffer = new Pair[this.pairCapacity];
    private int pairCount = 0;
    private int m_queryProxyId = -1;

    public DefaultBroadPhaseBuffer(BroadPhaseStrategy strategy) {
        for (int i2 = 0; i2 < this.pairCapacity; ++i2) {
            this.pairBuffer[i2] = new Pair();
        }
        this.tree = strategy;
    }

    @Override
    public int createProxy(AABB aabb, Object userData) {
        int proxyId = this.tree.createProxy(aabb, userData);
        this.bufferMove(proxyId);
        return proxyId;
    }

    @Override
    public void destroyProxy(int proxyId) {
        this.unbufferMove(proxyId);
        this.tree.destroyProxy(proxyId);
    }

    @Override
    public void moveProxy(int proxyId, AABB aabb, Vec2 displacement) {
        boolean buffer = this.tree.moveProxy(proxyId, aabb, displacement);
        if (buffer) {
            this.bufferMove(proxyId);
        }
    }

    @Override
    public void touchProxy(int proxyId) {
        this.bufferMove(proxyId);
    }

    @Override
    public Object getUserData(int proxyId) {
        return this.tree.getUserData(proxyId);
    }

    @Override
    public boolean testOverlap(int proxyIdA, int proxyIdB) {
        AABB a = this.tree.getFatAABB(proxyIdA);
        AABB b = this.tree.getFatAABB(proxyIdB);
        return AABB.testOverlap(a, b);
    }

    @Override
    public void updatePairs(PairCallback callback) {
        int i2;
        this.pairCount = 0;
        for (i2 = 0; i2 < this.moveCount; ++i2) {
            this.m_queryProxyId = this.moveBuffer[i2];
            if (this.m_queryProxyId == -1) continue;
            AABB fatAABB = this.tree.getFatAABB(this.m_queryProxyId);
            this.tree.query(this, fatAABB);
        }
        this.moveCount = 0;
        Arrays.sort(this.pairBuffer, 0, this.pairCount);
        i2 = 0;
        block1: while (i2 < this.pairCount) {
            Pair primaryPair = this.pairBuffer[i2];
            Object userDataA = this.tree.getUserData(primaryPair.proxyIdA);
            Object userDataB = this.tree.getUserData(primaryPair.proxyIdB);
            callback.addPair(userDataA, userDataB);
            ++i2;
            while (i2 < this.pairCount) {
                Pair pair = this.pairBuffer[i2];
                if (pair.proxyIdA != primaryPair.proxyIdA || pair.proxyIdB != primaryPair.proxyIdB) continue block1;
                ++i2;
            }
        }
    }

    @Override
    public void query(TreeCallback callback, AABB aabb) {
        this.tree.query(callback, aabb);
    }

    @Override
    public void raycast(TreeRayCastCallback callback, RayCastInput input) {
        this.tree.raycast(callback, input);
    }

    private void bufferMove(int proxyId) {
        if (this.moveCount == this.moveCapacity) {
            int[] old = this.moveBuffer;
            this.moveCapacity *= 2;
            this.moveBuffer = new int[this.moveCapacity];
            System.arraycopy(old, 0, this.moveBuffer, 0, old.length);
        }
        this.moveBuffer[this.moveCount] = proxyId;
        ++this.moveCount;
    }

    private void unbufferMove(int proxyId) {
        for (int i2 = 0; i2 < this.moveCount; ++i2) {
            if (this.moveBuffer[i2] != proxyId) continue;
            this.moveBuffer[i2] = -1;
        }
    }

    @Override
    public boolean treeCallback(int proxyId) {
        if (proxyId == this.m_queryProxyId) {
            return true;
        }
        if (this.pairCount == this.pairCapacity) {
            Pair[] oldBuffer = this.pairBuffer;
            this.pairCapacity *= 2;
            this.pairBuffer = new Pair[this.pairCapacity];
            System.arraycopy(oldBuffer, 0, this.pairBuffer, 0, oldBuffer.length);
            for (int i2 = oldBuffer.length; i2 < this.pairCapacity; ++i2) {
                this.pairBuffer[i2] = new Pair();
            }
        }
        if (proxyId < this.m_queryProxyId) {
            this.pairBuffer[this.pairCount].proxyIdA = proxyId;
            this.pairBuffer[this.pairCount].proxyIdB = this.m_queryProxyId;
        } else {
            this.pairBuffer[this.pairCount].proxyIdA = this.m_queryProxyId;
            this.pairBuffer[this.pairCount].proxyIdB = proxyId;
        }
        ++this.pairCount;
        return true;
    }
}

