/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.shapes.ChainShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.CircleShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.EdgeShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.PolygonShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;

final class DistanceProxy {
    private final Vec2[] vertices = new Vec2[JBoxSettings.maxPolygonVertices];
    private final Vec2[] buffer = new Vec2[2];
    private int count = 0;
    private float radius = 0.0f;

    DistanceProxy() {
        for (int i2 = 0; i2 < this.vertices.length; ++i2) {
            this.vertices[i2] = new Vec2();
        }
    }

    float getRadius() {
        return this.radius;
    }

    void set(Shape shape, int index) {
        switch (shape.getType()) {
            case CIRCLE: {
                CircleShape circle = (CircleShape)shape;
                this.vertices[0].set(circle.center);
                this.count = 1;
                this.radius = circle.getRadius();
                break;
            }
            case POLYGON: {
                PolygonShape poly = (PolygonShape)shape;
                this.count = poly.getVertexCount();
                this.radius = poly.getRadius();
                for (int i2 = 0; i2 < this.count; ++i2) {
                    this.vertices[i2].set(poly.m_vertices[i2]);
                }
                break;
            }
            case CHAIN: {
                ChainShape chain = (ChainShape)shape;
                assert (0 <= index && index < chain.getCount());
                this.buffer[0] = chain.getVertex(index);
                this.buffer[1] = index + 1 < chain.getCount() ? chain.getVertex(index + 1) : chain.getVertex(0);
                this.vertices[0].set(this.buffer[0]);
                this.vertices[1].set(this.buffer[1]);
                this.count = 2;
                this.radius = chain.getRadius();
                break;
            }
            case EDGE: {
                EdgeShape edge = (EdgeShape)shape;
                this.vertices[0].set(edge.m_vertex1);
                this.vertices[1].set(edge.m_vertex2);
                this.count = 2;
                this.radius = edge.getRadius();
            }
        }
    }

    int getSupport(Vec2 d) {
        int bestIndex = 0;
        float bestValue = Vec2.dot(this.vertices[0], d);
        for (int i2 = 1; i2 < this.count; ++i2) {
            float value = Vec2.dot(this.vertices[i2], d);
            if (!(value > bestValue)) continue;
            bestIndex = i2;
            bestValue = value;
        }
        return bestIndex;
    }

    Vec2 getVertex(int index) {
        assert (0 <= index && index < this.count);
        return this.vertices[index];
    }
}

