/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.SAT;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import java.io.Serializable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;

public final class HitBox
implements Serializable {
    private String name;
    private BoundingShape shape;
    private Bounds bounds;
    Vec2[] axes = new Vec2[2];
    Vec2[] corners = new Vec2[4];
    private transient DoubleProperty minXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty minYWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxYWorld = new SimpleDoubleProperty();
    float fastMinX;
    float fastMinY;
    float fastMaxX;
    float fastMaxY;
    SAT.MinMax axis1MinMax = new SAT.MinMax();
    SAT.MinMax axis2MinMax = new SAT.MinMax();

    public HitBox(BoundingShape shape) {
        this(String.valueOf(shape.hashCode()), shape);
    }

    public HitBox(Point2D localOrigin, BoundingShape shape) {
        this(String.valueOf(shape.hashCode()), localOrigin, shape);
    }

    public HitBox(String name, BoundingShape shape) {
        this(name, Point2D.ZERO, shape);
    }

    public HitBox(String name, Point2D localOrigin, BoundingShape shape) {
        this.name = name;
        this.shape = shape;
        this.bounds = new BoundingBox(localOrigin.getX(), localOrigin.getY(), shape.getSize().getWidth(), shape.getSize().getHeight());
        this.axes[0] = new Vec2();
        this.axes[1] = new Vec2();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.corners[i2] = new Vec2();
        }
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public BoundingShape getShape() {
        return this.shape;
    }

    public double getMinX() {
        return this.bounds.getMinX();
    }

    public double getMinY() {
        return this.bounds.getMinY();
    }

    public double getMaxX() {
        return this.bounds.getMaxX();
    }

    public double getMaxY() {
        return this.bounds.getMaxY();
    }

    public double getWidth() {
        return this.getMaxXWorld() - this.getMinXWorld();
    }

    public double getHeight() {
        return this.getMaxYWorld() - this.getMinYWorld();
    }

    public String getName() {
        return this.name;
    }

    public void bindXY(TransformComponent transform) {
        DoubleBinding x1 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMinX()) * transform.getScaleX() + transform.getX(), transform.scaleOriginXProperty(), transform.scaleXProperty(), transform.xProperty());
        DoubleBinding x2 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMaxX()) * transform.getScaleX() + transform.getX(), transform.scaleOriginXProperty(), transform.scaleXProperty(), transform.xProperty());
        DoubleBinding y1 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMinY()) * transform.getScaleY() + transform.getY(), transform.scaleOriginYProperty(), transform.scaleYProperty(), transform.yProperty());
        DoubleBinding y2 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMaxY()) * transform.getScaleY() + transform.getY(), transform.scaleOriginYProperty(), transform.scaleYProperty(), transform.yProperty());
        BooleanBinding isX1GreaterX2 = x1.greaterThan(x2);
        BooleanBinding isY1GreaterY2 = y1.greaterThan(y2);
        this.minXWorld.bind(Bindings.when(isX1GreaterX2).then(x2).otherwise(x1));
        this.maxXWorld.bind(Bindings.when(isX1GreaterX2).then(x1).otherwise(x2));
        this.minYWorld.bind(Bindings.when(isY1GreaterY2).then(y2).otherwise(y1));
        this.maxYWorld.bind(Bindings.when(isY1GreaterY2).then(y1).otherwise(y2));
    }

    public void unbind() {
        this.minXWorld.unbind();
        this.maxXWorld.unbind();
        this.minYWorld.unbind();
        this.maxYWorld.unbind();
    }

    public double getMinXWorld() {
        return this.minXWorld.get();
    }

    public double getMaxXWorld() {
        return this.maxXWorld.get();
    }

    public double getMinYWorld() {
        return this.minYWorld.get();
    }

    public double getMaxYWorld() {
        return this.maxYWorld.get();
    }

    public Point2D getCenterWorld() {
        return new Point2D((this.getMinXWorld() + this.getMaxXWorld()) / 2.0, (this.getMinYWorld() + this.getMaxYWorld()) / 2.0);
    }

    public Point2D centerLocal() {
        return new Point2D((this.bounds.getMinX() + this.bounds.getMaxX()) / 2.0, (this.bounds.getMinY() + this.bounds.getMaxY()) / 2.0);
    }

    public Point2D centerWorld(double x, double y) {
        return this.centerLocal().add(x, y);
    }

    public Shape toBox2DShape(BoundingBoxComponent bbox, PhysicsUnitConverter converter) {
        return this.shape.toBox2DShape(this, bbox, converter);
    }

    public float getFastMinX() {
        return this.fastMinX;
    }

    public float getFastMinY() {
        return this.fastMinY;
    }

    public float getFastMaxX() {
        return this.fastMaxX;
    }

    public float getFastMaxY() {
        return this.fastMaxY;
    }

    public void applyTransform(TransformComponent transform) {
        double x1 = transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMinX()) * transform.getScaleX() + transform.getX();
        double x2 = transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMaxX()) * transform.getScaleX() + transform.getX();
        double y1 = transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMinY()) * transform.getScaleY() + transform.getY();
        double y2 = transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMaxY()) * transform.getScaleY() + transform.getY();
        this.fastMinX = (float)Math.min(x1, x2);
        this.fastMinY = (float)Math.min(y1, y2);
        this.fastMaxX = (float)Math.max(x1, x2);
        this.fastMaxY = (float)Math.max(y1, y2);
        double angle = transform.getAngle();
        float cos = FXGLMath.cosDegF(angle);
        float sin = FXGLMath.sinDegF(angle);
        this.axes[0].set(cos, sin).normalizeLocal();
        this.axes[1].set(FXGLMath.cosDegF(angle + 90.0), FXGLMath.sinDegF(angle + 90.0)).normalizeLocal();
        this.corners[0].set(this.fastMinX, this.fastMinY);
        this.corners[1].set(this.fastMaxX, this.fastMinY);
        this.corners[2].set(this.fastMaxX, this.fastMaxY);
        this.corners[3].set(this.fastMinX, this.fastMaxY);
        if (angle != 0.0) {
            Point2D origin = transform.getRotationOrigin();
            double originX = origin.getX() + transform.getX();
            double originY = origin.getY() + transform.getY();
            for (Vec2 v : this.corners) {
                v.subLocal(originX, originY);
                v.set(v.x * cos - v.y * sin, v.x * sin + v.y * cos);
                v.addLocal(originX, originY);
            }
        }
        SAT.computeMinMax(this.corners, this.axes[0], this.axis1MinMax);
        SAT.computeMinMax(this.corners, this.axes[1], this.axis2MinMax);
    }

    public String toString() {
        return "HitBox(" + this.name + "," + String.valueOf(this.shape) + ")";
    }
}

