/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.box2d.collision.shapes.PolygonShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/almasb/fxgl/physics/BoxShapeData;", "Lcom/almasb/fxgl/physics/BoundingShape;", "width", "", "height", "(DD)V", "getHeight", "()D", "getWidth", "toBox2DShape", "Lcom/almasb/fxgl/physics/box2d/collision/shapes/Shape;", "box", "Lcom/almasb/fxgl/physics/HitBox;", "bboxComp", "Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "conv", "Lcom/almasb/fxgl/physics/PhysicsUnitConverter;", "fxgl-entity"})
public final class BoxShapeData
extends BoundingShape {
    private final double width;
    private final double height;

    public BoxShapeData(double width, double height) {
        super(new Dimension2D(width, height), null);
        this.width = width;
        this.height = height;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public Shape toBox2DShape(@NotNull HitBox box, @NotNull BoundingBoxComponent bboxComp, @NotNull PhysicsUnitConverter conv) {
        Intrinsics.checkNotNullParameter(box, "box");
        Intrinsics.checkNotNullParameter(bboxComp, "bboxComp");
        Intrinsics.checkNotNullParameter(conv, "conv");
        Point2D boundsCenterLocal = box.getCenterWorld().subtract(bboxComp.getCenterWorld());
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(conv.toMetersF(box.getWidth() / (double)2), conv.toMetersF(box.getHeight() / (double)2), conv.toVector(boundsCenterLocal), 0.0f);
        return shape;
    }
}

