/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.physics.Box3DShapeData;
import com.almasb.fxgl.physics.BoxShapeData;
import com.almasb.fxgl.physics.ChainShapeData;
import com.almasb.fxgl.physics.CircleShapeData;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsUnitConverter;
import com.almasb.fxgl.physics.PolygonShapeData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\u0012\u0013\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/physics/BoundingShape;", "", "size", "Ljavafx/geometry/Dimension2D;", "(Ljavafx/geometry/Dimension2D;)V", "getSize", "()Ljavafx/geometry/Dimension2D;", "toBox2DShape", "Lcom/almasb/fxgl/physics/box2d/collision/shapes/Shape;", "box", "Lcom/almasb/fxgl/physics/HitBox;", "bboxComp", "Lcom/almasb/fxgl/entity/components/BoundingBoxComponent;", "conv", "Lcom/almasb/fxgl/physics/PhysicsUnitConverter;", "toString", "", "Companion", "Lcom/almasb/fxgl/physics/Box3DShapeData;", "Lcom/almasb/fxgl/physics/BoxShapeData;", "Lcom/almasb/fxgl/physics/ChainShapeData;", "Lcom/almasb/fxgl/physics/CircleShapeData;", "Lcom/almasb/fxgl/physics/PolygonShapeData;", "fxgl-entity"})
public abstract class BoundingShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dimension2D size;

    private BoundingShape(Dimension2D size) {
        this.size = size;
    }

    @NotNull
    public final Dimension2D getSize() {
        return this.size;
    }

    @NotNull
    public abstract Shape toBox2DShape(@NotNull HitBox var1, @NotNull BoundingBoxComponent var2, @NotNull PhysicsUnitConverter var3);

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string, "javaClass.simpleName");
        return StringsKt.substringBefore$default(string, "ShapeData", null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape circle(double radius) {
        return Companion.circle(radius);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape box(double width, double height) {
        return Companion.box(width, height);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape chain(Point2D ... points) {
        return Companion.chain(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygon(@NotNull List<? extends Point2D> points) {
        return Companion.polygon(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygonFromDoubles(@NotNull List<Double> points) {
        return Companion.polygonFromDoubles(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygon(double ... points) {
        return Companion.polygon(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape polygon(Point2D ... points) {
        return Companion.polygon(points);
    }

    @JvmStatic
    @NotNull
    public static final BoundingShape box3D(double width, double height, double depth) {
        return Companion.box3D(width, height, depth);
    }

    public /* synthetic */ BoundingShape(Dimension2D size, DefaultConstructorMarker $constructor_marker) {
        this(size);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J!\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J!\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u0011\u001a\u00020\u00042\n\u0010\u000b\u001a\u00020\u0012\"\u00020\u0006H\u0007J\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0007J\u0016\u0010\u0014\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/physics/BoundingShape$Companion;", "", "()V", "box", "Lcom/almasb/fxgl/physics/BoundingShape;", "width", "", "height", "box3D", "depth", "chain", "points", "", "Ljavafx/geometry/Point2D;", "([Ljavafx/geometry/Point2D;)Lcom/almasb/fxgl/physics/BoundingShape;", "circle", "radius", "polygon", "", "", "polygonFromDoubles", "fxgl-entity"})
    @SourceDebugExtension(value={"SMAP\nBoundingShape.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundingShape.kt\ncom/almasb/fxgl/physics/BoundingShape$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,216:1\n37#2,2:217\n*S KotlinDebug\n*F\n+ 1 BoundingShape.kt\ncom/almasb/fxgl/physics/BoundingShape$Companion\n*L\n80#1:217,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BoundingShape circle(double radius) {
            return new CircleShapeData(radius);
        }

        @JvmStatic
        @NotNull
        public final BoundingShape box(double width, double height) {
            return new BoxShapeData(width, height);
        }

        @JvmStatic
        @NotNull
        public final BoundingShape chain(Point2D ... points) {
            Intrinsics.checkNotNullParameter(points, "points");
            if (points.length < 2) {
                throw new IllegalArgumentException("Chain shape requires at least 2 points. Given points: " + points.length);
            }
            double maxX = points[0].getX();
            double maxY = points[0].getY();
            int n = points.length;
            for (int j = 0; j < n; ++j) {
                Point2D p = points[j];
                if (p.getX() > maxX) {
                    maxX = p.getX();
                }
                if (!(p.getY() > maxY)) continue;
                maxY = p.getY();
            }
            return new ChainShapeData(new Dimension2D(maxX, maxY), points);
        }

        @JvmStatic
        @NotNull
        public final BoundingShape polygon(@NotNull List<? extends Point2D> points) {
            Intrinsics.checkNotNullParameter(points, "points");
            Collection $this$toTypedArray$iv = points;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Point2D[] point2DArray = thisCollection$iv.toArray(new Point2D[0]);
            return this.polygon(Arrays.copyOf(point2DArray, point2DArray.length));
        }

        @JvmStatic
        @NotNull
        public final BoundingShape polygonFromDoubles(@NotNull List<Double> points) {
            Intrinsics.checkNotNullParameter(points, "points");
            double[] array = new double[points.size()];
            int n = points.size();
            for (int i2 = 0; i2 < n; ++i2) {
                array[i2] = ((Number)points.get(i2)).doubleValue();
            }
            double[] dArray = CollectionsKt.toDoubleArray((Collection<Double>)points);
            return this.polygon(Arrays.copyOf(dArray, dArray.length));
        }

        @JvmStatic
        @NotNull
        public final BoundingShape polygon(double ... points) {
            Intrinsics.checkNotNullParameter(points, "points");
            int n = 0;
            int n2 = points.length / 2;
            Point2D[] point2DArray = new Point2D[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNullExpressionValue(Point2D.ZERO, "ZERO");
            }
            Point2D[] array = point2DArray;
            n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double x = points[i2 * 2];
                double y = points[i2 * 2 + 1];
                array[i2] = new Point2D(x, y);
            }
            return this.polygon(Arrays.copyOf(array, array.length));
        }

        @JvmStatic
        @NotNull
        public final BoundingShape polygon(Point2D ... points) {
            Intrinsics.checkNotNullParameter(points, "points");
            if (points.length < 3) {
                throw new IllegalArgumentException("Polygon shape requires at least 3 points. Given points: " + points.length);
            }
            double maxX = points[0].getX();
            double maxY = points[0].getY();
            int n = points.length;
            for (int j = 0; j < n; ++j) {
                Point2D p = points[j];
                if (p.getX() > maxX) {
                    maxX = p.getX();
                }
                if (!(p.getY() > maxY)) continue;
                maxY = p.getY();
            }
            return new PolygonShapeData(new Dimension2D(maxX, maxY), points);
        }

        @JvmStatic
        @NotNull
        public final BoundingShape box3D(double width, double height, double depth) {
            return new Box3DShapeData(width, height, depth);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

