/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.dungeon;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.astar.TraversableGrid;
import com.almasb.fxgl.pathfinding.dungeon.DungeonCell;
import com.almasb.fxgl.pathfinding.dungeon.DungeonConfig;
import java.util.Random;

public class DungeonGrid
extends TraversableGrid<DungeonCell> {
    private static final DungeonConfig DEFAULT = new DungeonConfig(FXGLMath.getRandom(), 6, 4, 9, 4, 9);
    private DungeonCell[][] tileMap = (DungeonCell[][])this.getData();
    private DungeonConfig config;

    public DungeonGrid(int width, int height) {
        this(width, height, DEFAULT);
    }

    public DungeonGrid(int width, int height, DungeonConfig config) {
        super(DungeonCell.class, width, height, DungeonCell::new);
        this.config = config;
        this.generateDungeon();
    }

    private void generateDungeon() {
        int i2;
        if (this.config.numRooms() < 1) {
            throw new IllegalArgumentException("A dungeon must have at least 1 room.");
        }
        if (this.config.minRoomWidth() < 2) {
            throw new IllegalArgumentException("Minimum room width must be at least 2.");
        }
        if (this.config.minRoomHeight() < 2) {
            throw new IllegalArgumentException("Minimum room height must be at least 2.");
        }
        Random random = this.config.random();
        record Pos(int x, int y) {
        }
        Pos[] roomPositions = new Pos[this.config.numRooms()];
        for (i2 = 0; i2 < roomPositions.length; ++i2) {
            roomPositions[i2] = new Pos(random.nextInt(this.getWidth()), random.nextInt(this.getHeight()));
        }
        for (i2 = 0; i2 < roomPositions.length; ++i2) {
            if (random.nextInt(3) == 0) {
                this.clearCircle(roomPositions[i2].x, roomPositions[i2].y, random.nextInt(3) + 1);
            } else {
                this.clearRect(roomPositions[i2].x, roomPositions[i2].y, this.randomRectWidth(), this.randomRectHeight());
            }
            if (this.config.numRooms() == 1) break;
            int randomRoom = random.nextInt(roomPositions.length);
            while (randomRoom == i2) {
                randomRoom = random.nextInt(roomPositions.length);
            }
            this.clearPath(roomPositions[i2].x, roomPositions[i2].y, roomPositions[randomRoom].x, roomPositions[randomRoom].y);
        }
    }

    private void clearRect(int x, int y, int width, int height) {
        for (int i2 = 0; i2 < this.tileMap.length; ++i2) {
            for (int j = 0; j < this.tileMap[0].length; ++j) {
                int xDis = Math.abs(i2 - x);
                int yDis = Math.abs(j - y);
                if (xDis > width / 2 || yDis > height / 2) continue;
                this.tileMap[i2][j].setState(CellState.WALKABLE);
            }
        }
    }

    private void clearCircle(int xPos, int yPos, int radius) {
        for (int i2 = 0; i2 < this.tileMap.length; ++i2) {
            for (int j = 0; j < this.tileMap[0].length; ++j) {
                int yDis;
                int xDis = Math.abs(i2 - xPos);
                double tileDis = Math.sqrt(xDis * xDis + (yDis = Math.abs(j - yPos)) * yDis);
                if (!(tileDis <= (double)radius)) continue;
                this.tileMap[i2][j].setState(CellState.WALKABLE);
            }
        }
    }

    private void clearPath(int xStart, int yStart, int xEnd, int yEnd) {
        int[] clearPos = new int[]{xStart, yStart};
        while (clearPos[0] != xEnd || clearPos[1] != yEnd) {
            if (clearPos[0] < xEnd) {
                clearPos[0] = clearPos[0] + 1;
            } else if (clearPos[0] > xEnd) {
                clearPos[0] = clearPos[0] - 1;
            } else if (clearPos[1] < yEnd) {
                clearPos[1] = clearPos[1] + 1;
            } else if (clearPos[1] > yEnd) {
                clearPos[1] = clearPos[1] - 1;
            }
            this.tileMap[clearPos[0]][clearPos[1]].setState(CellState.WALKABLE);
        }
    }

    private int randomRectWidth() {
        return this.config.minRoomWidth() + this.config.random().nextInt(this.config.maxRoomWidth() - this.config.minRoomWidth() + 1);
    }

    private int randomRectHeight() {
        return this.config.minRoomHeight() + this.config.random().nextInt(this.config.maxRoomHeight() - this.config.minRoomHeight() + 1);
    }
}

