/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.core.collection.grid.Cell;
import com.almasb.fxgl.core.collection.grid.NeighborDirection;
import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.Pathfinder;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import com.almasb.fxgl.pathfinding.astar.CacheKey;
import com.almasb.fxgl.pathfinding.astar.TraversableGrid;
import com.almasb.fxgl.pathfinding.heuristic.DiagonalHeuristic;
import com.almasb.fxgl.pathfinding.heuristic.Heuristic;
import com.almasb.fxgl.pathfinding.heuristic.ManhattanDistance;
import com.almasb.fxgl.pathfinding.heuristic.OctileDistance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class AStarPathfinder<T extends AStarCell>
implements Pathfinder<T> {
    private final TraversableGrid<T> grid;
    private final Heuristic<T> defaultHeuristic;
    private final DiagonalHeuristic<T> diagonalHeuristic;
    private boolean isCachingPaths = false;
    private Map<CacheKey, List<T>> cache = new HashMap<CacheKey, List<T>>();

    public AStarPathfinder(TraversableGrid<T> grid) {
        this(grid, new ManhattanDistance(), new OctileDistance());
    }

    public AStarPathfinder(TraversableGrid<T> grid, Heuristic<T> defaultHeuristic, DiagonalHeuristic<T> diagonalHeuristic) {
        this.grid = grid;
        this.defaultHeuristic = defaultHeuristic;
        this.diagonalHeuristic = diagonalHeuristic;
    }

    public TraversableGrid<T> getGrid() {
        return this.grid;
    }

    public void setCachingPaths(boolean isCachingPaths) {
        this.isCachingPaths = isCachingPaths;
    }

    public boolean isCachingPaths() {
        return this.isCachingPaths;
    }

    @Override
    public List<T> findPath(int sourceX, int sourceY, int targetX, int targetY) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), new AStarCell[0]);
    }

    @Override
    public List<T> findPath(int sourceX, int sourceY, int targetX, int targetY, NeighborDirection neighborDirection) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), neighborDirection, new AStarCell[0]);
    }

    @Override
    public List<T> findPath(int sourceX, int sourceY, int targetX, int targetY, List<T> busyCells) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), NeighborDirection.FOUR_DIRECTIONS, busyCells.toArray(new AStarCell[0]));
    }

    @Override
    public List<T> findPath(int sourceX, int sourceY, int targetX, int targetY, NeighborDirection neighborDirection, List<T> busyCells) {
        return this.findPath((AStarCell[][])this.grid.getData(), (AStarCell)this.grid.get(sourceX, sourceY), (AStarCell)this.grid.get(targetX, targetY), neighborDirection, busyCells.toArray(new AStarCell[0]));
    }

    public List<T> findPath(T[][] grid, T start2, T target, T ... busyNodes) {
        return this.findPath((AStarCell[][])grid, (AStarCell)start2, (AStarCell)target, NeighborDirection.FOUR_DIRECTIONS, (AStarCell[])busyNodes);
    }

    public List<T> findPath(T[][] grid, T start2, T target, NeighborDirection neighborDirection, AStarCell ... busyNodes) {
        List<T> path;
        if (start2 == target || ((AStarCell)target).getState() == CellState.NOT_WALKABLE) {
            return Collections.emptyList();
        }
        CacheKey cacheKey = new CacheKey(((Cell)start2).getX(), ((Cell)start2).getY(), ((Cell)target).getX(), ((Cell)target).getY());
        if (this.isCachingPaths && (path = this.cache.get(cacheKey)) != null) {
            return new ArrayList<T>(path);
        }
        Heuristic<T> heuristic = neighborDirection == NeighborDirection.FOUR_DIRECTIONS ? this.defaultHeuristic : this.diagonalHeuristic;
        for (int y = 0; y < grid[0].length; ++y) {
            for (int x = 0; x < grid.length; ++x) {
                ((AStarCell)grid[x][y]).setHCost(heuristic.getCost(x, y, ((Cell)target).getX(), ((Cell)target).getY()));
                ((AStarCell)grid[x][y]).setParent(null);
                ((AStarCell)grid[x][y]).setGCost(0);
            }
        }
        HashSet<AStarCell> open = new HashSet<AStarCell>();
        HashSet<T> closed = new HashSet<T>();
        T current = start2;
        boolean found = false;
        while (!found && !closed.contains(target)) {
            for (AStarCell neighbor : this.getValidNeighbors(current, neighborDirection, busyNodes)) {
                if (neighbor == target) {
                    ((AStarCell)target).setParent((AStarCell)current);
                    found = true;
                    closed.add(target);
                    break;
                }
                if (closed.contains(neighbor)) continue;
                int gCost = this.isDiagonal((Cell)current, neighbor) ? this.diagonalHeuristic.getDiagonalWeight() : this.defaultHeuristic.getWeight();
                int newGCost = ((AStarCell)current).getGCost() + (gCost *= neighbor.getMovementCost());
                if (open.contains(neighbor)) {
                    if (newGCost >= neighbor.getGCost()) continue;
                    neighbor.setParent((AStarCell)current);
                    neighbor.setGCost(newGCost);
                    continue;
                }
                neighbor.setParent((AStarCell)current);
                neighbor.setGCost(newGCost);
                open.add(neighbor);
            }
            if (found) continue;
            closed.add(current);
            open.remove(current);
            if (open.isEmpty()) {
                return Collections.emptyList();
            }
            AStarCell acc = null;
            for (AStarCell a : open) {
                if (acc == null) {
                    acc = a;
                    continue;
                }
                acc = a.getFCost() < acc.getFCost() ? a : acc;
            }
            current = acc;
        }
        List<T> path2 = this.buildPath(start2, target);
        if (this.isCachingPaths) {
            this.cache.put(cacheKey, path2);
        }
        return new ArrayList<T>(path2);
    }

    private List<T> buildPath(T start2, T target) {
        ArrayList<T> path = new ArrayList<T>();
        Object tmp = target;
        do {
            path.add(tmp);
        } while ((tmp = ((AStarCell)tmp).getParent()) != start2);
        Collections.reverse(path);
        return path;
    }

    private List<T> getValidNeighbors(T node, NeighborDirection neighborDirection, AStarCell ... busyNodes) {
        List result = this.grid.getNeighbors(((Cell)node).getX(), ((Cell)node).getY(), neighborDirection);
        result.removeAll(Arrays.asList(busyNodes));
        result.removeIf(cell -> !this.grid.isTraversableInSingleMove((AStarCell)node, (AStarCell)cell));
        return result;
    }

    private boolean isDiagonal(Cell current, Cell neighbor) {
        return neighbor.getX() - current.getX() != 0 && neighbor.getY() - current.getY() != 0;
    }
}

