/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.astar.AStarGrid;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class AStarGridView
extends Parent {
    public AStarGridView(AStarGrid grid, int cellWidth, int cellHeight) {
        Line line;
        Group rectGroup = new Group();
        Group linesGroup = new Group();
        Group coordGroup = new Group();
        grid.forEach(cell -> {
            Rectangle rect = new Rectangle(cellWidth, cellHeight, cell.getState() == CellState.NOT_WALKABLE ? Color.color(0.8, 0.0, 0.0, 0.75) : Color.color(0.0, 0.8, 0.0, 0.75));
            rect.setTranslateX(cell.getX() * cellWidth);
            rect.setTranslateY(cell.getY() * cellHeight);
            rectGroup.getChildren().add(rect);
            int midX = cell.getX() * cellWidth + cellWidth / 2;
            int midY = cell.getY() * cellHeight + cellHeight / 2;
            Text text = new Text(cell.getX() + "," + cell.getY());
            text.setTranslateX((double)midX - text.getLayoutBounds().getWidth() / 2.0);
            text.setTranslateY(midY);
            coordGroup.getChildren().add(text);
        });
        for (int x = 0; x < grid.getWidth(); ++x) {
            line = new Line(x * cellWidth, 0.0, x * cellWidth, grid.getHeight() * cellHeight);
            linesGroup.getChildren().add(line);
        }
        for (int y = 0; y < grid.getHeight(); ++y) {
            line = new Line(0.0, y * cellHeight, grid.getWidth() * cellWidth, y * cellHeight);
            linesGroup.getChildren().add(line);
        }
        this.getChildren().addAll((Node[])new Node[]{rectGroup, linesGroup, coordGroup});
    }
}

