/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.pathfinding.CellState;
import com.almasb.fxgl.pathfinding.astar.AStarCell;
import com.almasb.fxgl.pathfinding.astar.TraversableGrid;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.geometry.Rectangle2D;

public final class AStarGrid
extends TraversableGrid<AStarCell> {
    public AStarGrid(int width, int height) {
        super(AStarCell.class, width, height, (x, y) -> new AStarCell((int)x, (int)y, CellState.WALKABLE));
    }

    public static AStarGrid fromWorld(GameWorld world, int worldWidth, int worldHeight, int cellWidth, int cellHeight, Function<Object, CellState> mapping) {
        AStarGrid grid = new AStarGrid(worldWidth, worldHeight);
        grid.populate((x, y) -> {
            int worldY;
            int worldX = x * cellWidth + cellWidth / 2;
            List collidingTypes = world.getEntitiesInRange(new Rectangle2D(worldX - 2, (worldY = y * cellHeight + cellHeight / 2) - 2, 4.0, 4.0)).stream().map(Entity::getType).collect(Collectors.toList());
            boolean isWalkable = collidingTypes.isEmpty() ? mapping.apply("") == CellState.WALKABLE : collidingTypes.stream().map(mapping).noneMatch(state -> state == CellState.NOT_WALKABLE);
            return new AStarCell((int)x, (int)y, isWalkable ? CellState.WALKABLE : CellState.NOT_WALKABLE);
        });
        return grid;
    }
}

