/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.pathfinding.astar;

import com.almasb.fxgl.core.collection.grid.Cell;
import com.almasb.fxgl.pathfinding.CellState;

public class AStarCell
extends Cell {
    private static final int DEFAULT_MOVEMENT_COST = 30;
    private AStarCell parent;
    private CellState state;
    private int movementCost;
    private int gCost;
    private int hCost;

    public AStarCell(int x, int y, CellState state) {
        this(x, y, state, 30);
    }

    public AStarCell(int x, int y, CellState state, int movementCost) {
        super(x, y);
        this.state = state;
        this.movementCost = movementCost;
    }

    public final void setMovementCost(int movementCost) {
        this.movementCost = movementCost;
    }

    public final int getMovementCost() {
        return this.movementCost;
    }

    public final void setParent(AStarCell parent) {
        this.parent = parent;
    }

    public final AStarCell getParent() {
        return this.parent;
    }

    public final void setHCost(int hCost) {
        this.hCost = hCost;
    }

    public final int getHCost() {
        return this.hCost;
    }

    public final void setGCost(int gCost) {
        this.gCost = gCost;
    }

    public final int getGCost() {
        return this.gCost;
    }

    public final void setState(CellState state) {
        this.state = state;
    }

    public final CellState getState() {
        return this.state;
    }

    public final boolean isWalkable() {
        return this.state.isWalkable();
    }

    public final int getFCost() {
        return this.gCost + this.hCost;
    }

    @Override
    public String toString() {
        return "A* Cell[x=" + this.getX() + ",y=" + this.getY() + "," + String.valueOf((Object)this.state) + "]";
    }
}

