/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net.http;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.core.util.LazyValue;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.Map;

public final class HttpClientService
extends EngineService {
    private LazyValue<HttpClient> client = new LazyValue<HttpClient>(HttpClient::newHttpClient);

    public IOTask<HttpResponse<String>> sendGETRequestTask(String url) {
        return this.sendGETRequestTask(url, Collections.emptyMap());
    }

    public IOTask<HttpResponse<String>> sendGETRequestTask(String url, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).GET();
        headers.forEach(builder::header);
        return this.sendRequestTask(builder.build());
    }

    public <T> IOTask<HttpResponse<T>> sendGETRequestTask(String url, Map<String, String> headers, HttpResponse.BodyHandler<T> handler) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).GET();
        headers.forEach(builder::header);
        return this.sendRequestTask(builder.build(), handler);
    }

    public IOTask<HttpResponse<String>> sendPUTRequestTask(String url, String body2) {
        return this.sendPUTRequestTask(url, body2, Collections.emptyMap());
    }

    public IOTask<HttpResponse<String>> sendPUTRequestTask(String url, String body2, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).PUT(HttpRequest.BodyPublishers.ofString(body2));
        headers.forEach(builder::header);
        return this.sendRequestTask(builder.build());
    }

    public IOTask<HttpResponse<String>> sendPOSTRequestTask(String url, String body2) {
        return this.sendPOSTRequestTask(url, body2, Collections.emptyMap());
    }

    public IOTask<HttpResponse<String>> sendPOSTRequestTask(String url, String body2, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(body2));
        headers.forEach(builder::header);
        return this.sendRequestTask(builder.build());
    }

    public IOTask<HttpResponse<String>> sendDELETERequestTask(String url) {
        return this.sendDELETERequestTask(url, Collections.emptyMap());
    }

    public IOTask<HttpResponse<String>> sendDELETERequestTask(String url, Map<String, String> headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(url)).DELETE();
        headers.forEach(builder::header);
        return this.sendRequestTask(builder.build());
    }

    public IOTask<HttpResponse<String>> sendRequestTask(HttpRequest request) {
        return this.sendRequestTask(request, HttpResponse.BodyHandlers.ofString());
    }

    public <T> IOTask<HttpResponse<T>> sendRequestTask(HttpRequest request, HttpResponse.BodyHandler<T> handler) {
        return IOTask.of("sendRequestTask", () -> this.client.get().send(request, handler));
    }
}

