/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.BundleTCPMessageWriter;
import com.almasb.fxgl.net.BundleUDPMessageWriter;
import com.almasb.fxgl.net.ByteArrayTCPMessageWriter;
import com.almasb.fxgl.net.StringTCPMessageWriter;
import com.almasb.fxgl.net.TCPMessageWriter;
import com.almasb.fxgl.net.TCPWriterFactory;
import com.almasb.fxgl.net.UDPMessageWriter;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\bJ(\u0010\u0011\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000bJ(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0014\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00072\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006j\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\n\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0006j\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/net/Writers;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "tcpWriters", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lcom/almasb/fxgl/net/TCPWriterFactory;", "Lkotlin/collections/HashMap;", "udpWriters", "Lcom/almasb/fxgl/net/UDPMessageWriter;", "addTCPWriter", "", "T", "type", "factory", "addUDPWriter", "writer", "getTCPWriter", "Lcom/almasb/fxgl/net/TCPMessageWriter;", "out", "Ljava/io/OutputStream;", "getUDPWriter", "fxgl-io"})
public final class Writers {
    @NotNull
    public static final Writers INSTANCE = new Writers();
    @NotNull
    private static final Logger log = Logger.Companion.get(INSTANCE.getClass());
    @NotNull
    private static final HashMap<Class<?>, TCPWriterFactory<?>> tcpWriters = new HashMap();
    @NotNull
    private static final HashMap<Class<?>, UDPMessageWriter<?>> udpWriters = new HashMap();

    private Writers() {
    }

    public final <T> void addTCPWriter(@NotNull Class<T> type, @NotNull TCPWriterFactory<T> factory) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(factory, "factory");
        ((Map)tcpWriters).put(type, factory);
    }

    public final <T> void addUDPWriter(@NotNull Class<T> type, @NotNull UDPMessageWriter<T> writer) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(writer, "writer");
        ((Map)udpWriters).put(type, writer);
    }

    @NotNull
    public final <T> TCPMessageWriter<T> getTCPWriter(@NotNull Class<T> type, @NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(out, "out");
        log.debug("Getting TCPMessageWriter for " + type);
        TCPWriterFactory<?> tCPWriterFactory = tcpWriters.get(type);
        if (tCPWriterFactory == null) {
            throw new RuntimeException("No TCP message writer factory for type: " + type);
        }
        TCPWriterFactory<?> writerFactory = tCPWriterFactory;
        TCPMessageWriter<?> tCPMessageWriter = writerFactory.create(out);
        Intrinsics.checkNotNull(tCPMessageWriter, "null cannot be cast to non-null type com.almasb.fxgl.net.TCPMessageWriter<T of com.almasb.fxgl.net.Writers.getTCPWriter>");
        TCPMessageWriter<?> writer = tCPMessageWriter;
        log.debug("Constructed TCPMessageWriter for " + type + ": " + writer.getClass().getSimpleName());
        return writer;
    }

    @NotNull
    public final <T> UDPMessageWriter<T> getUDPWriter(@NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, "type");
        log.debug("Getting UDPMessageWriter for " + type);
        UDPMessageWriter<?> uDPMessageWriter = udpWriters.get(type);
        UDPMessageWriter<?> uDPMessageWriter2 = uDPMessageWriter instanceof UDPMessageWriter ? uDPMessageWriter : null;
        if (uDPMessageWriter2 == null) {
            throw new RuntimeException("No UDP message writer for type: " + type);
        }
        UDPMessageWriter<?> writer = uDPMessageWriter2;
        log.debug("Constructed UDPMessageWriter for " + type + ": " + writer.getClass().getSimpleName());
        return writer;
    }

    static {
        INSTANCE.addTCPWriter(Bundle.class, new TCPWriterFactory<Bundle>(){

            @Override
            @NotNull
            public TCPMessageWriter<Bundle> create(@NotNull OutputStream out) {
                Intrinsics.checkNotNullParameter(out, "out");
                return new BundleTCPMessageWriter(out);
            }
        });
        INSTANCE.addTCPWriter(byte[].class, new TCPWriterFactory<byte[]>(){

            @Override
            @NotNull
            public TCPMessageWriter<byte[]> create(@NotNull OutputStream out) {
                Intrinsics.checkNotNullParameter(out, "out");
                return new ByteArrayTCPMessageWriter(out);
            }
        });
        INSTANCE.addTCPWriter(String.class, new TCPWriterFactory<String>(){

            @Override
            @NotNull
            public TCPMessageWriter<String> create(@NotNull OutputStream out) {
                Intrinsics.checkNotNullParameter(out, "out");
                return new StringTCPMessageWriter(out);
            }
        });
        INSTANCE.addUDPWriter(Bundle.class, new BundleUDPMessageWriter());
    }
}

