/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.net;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.Connection;
import com.almasb.fxgl.net.Readers;
import com.almasb.fxgl.net.TCPMessageReader;
import com.almasb.fxgl.net.TCPMessageWriter;
import com.almasb.fxgl.net.UDPMessageReader;
import com.almasb.fxgl.net.Writers;
import com.almasb.fxgl.net.tcp.TCPConnection;
import com.almasb.fxgl.net.udp.UDPConnection;
import java.io.EOFException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class Endpoint<T> {
    private static final Logger log = Logger.get(Endpoint.class);
    private List<Connection<T>> connections = new ArrayList<Connection<T>>();
    private Consumer<Connection<T>> onConnected = c -> {};
    private Consumer<Connection<T>> onDisconnected = c -> {};

    public final void broadcast(T message2) {
        for (int i2 = 0; i2 < this.connections.size(); ++i2) {
            this.connections.get(i2).send(message2);
        }
    }

    public final void setOnConnected(Consumer<Connection<T>> onConnected) {
        this.onConnected = onConnected;
    }

    public final void setOnDisconnected(Consumer<Connection<T>> onDisconnected) {
        this.onDisconnected = onDisconnected;
    }

    protected final void openTCPConnection(Socket socket, int connectionNum, Class<T> messageType) throws Exception {
        log.debug(this.getClass().getSimpleName() + " opening new connection (" + connectionNum + ") from " + String.valueOf(socket.getInetAddress()) + ":" + socket.getPort() + " type: " + String.valueOf(messageType));
        socket.setTcpNoDelay(true);
        TCPConnection connection = new TCPConnection(socket, connectionNum);
        this.onConnectionOpened(connection);
        String sendThreadName = this.getClass().getSimpleName() + "_SendThread-" + connectionNum;
        String recvThreadName = this.getClass().getSimpleName() + "_RecvThread-" + connectionNum;
        new ConnectionThread(sendThreadName, () -> {
            try {
                TCPMessageWriter writer = Writers.INSTANCE.getTCPWriter(messageType, socket.getOutputStream());
                while (connection.isConnected()) {
                    Object message2 = connection.messageQueue.take();
                    writer.write(message2);
                }
            }
            catch (Exception e) {
                log.warning(sendThreadName + " crashed", e);
            }
        }).start();
        new ConnectionThread(recvThreadName, () -> {
            try {
                TCPMessageReader reader = Readers.INSTANCE.getTCPReader(messageType, socket.getInputStream());
                while (connection.isConnected()) {
                    try {
                        Object message2 = reader.read();
                        connection.notifyMessageReceived(message2);
                    }
                    catch (EOFException e) {
                        log.debug("Connection " + connectionNum + " was correctly closed from remote endpoint.");
                        connection.terminate();
                    }
                    catch (SocketException e) {
                        if (connection.isClosedLocally()) continue;
                        log.debug("Connection " + connectionNum + " was unexpectedly disconnected: " + e.getMessage());
                        connection.terminate();
                    }
                    catch (Exception e) {
                        log.warning("Connection " + connectionNum + " had unspecified error during receive()", e);
                        connection.terminate();
                    }
                }
            }
            catch (Exception e) {
                log.warning(recvThreadName + " crashed", e);
            }
            this.onConnectionClosed(connection);
        }).start();
    }

    protected final void openUDPConnection(UDPConnection<T> connection, Class<T> messageType) {
        log.debug("Opening UDP connection (" + connection.getConnectionNum() + ")");
        this.onConnectionOpened(connection);
        String sendThreadName = this.getClass().getSimpleName() + "_SendThread-" + connection.getConnectionNum();
        String recvThreadName = this.getClass().getSimpleName() + "_RecvThread-" + connection.getConnectionNum();
        new ConnectionThread(sendThreadName, () -> {
            try {
                while (connection.isConnected()) {
                    Object message2 = connection.messageQueue.take();
                    byte[] bytes = Writers.INSTANCE.getUDPWriter(messageType).write(message2);
                    connection.sendUDP(bytes);
                }
            }
            catch (Exception e) {
                log.warning(sendThreadName + " crashed", e);
            }
        }).start();
        new ConnectionThread(recvThreadName, () -> {
            try {
                UDPMessageReader reader = Readers.INSTANCE.getUDPReader(messageType);
                while (connection.isConnected()) {
                    byte[] bytes = connection.getRecvQueue().take();
                    Object message2 = reader.read(bytes);
                    connection.notifyMessageReceived(message2);
                }
            }
            catch (Exception e) {
                log.warning(recvThreadName + " crashed", e);
            }
        }).start();
    }

    private void onConnectionOpened(Connection<T> connection) {
        log.debug(this.getClass().getSimpleName() + " successfully opened connection (" + connection.getConnectionNum() + ")");
        this.connections.add(connection);
        try {
            this.onConnected.accept(connection);
        }
        catch (Exception e) {
            log.warning("Exception occurred in onConnected callback", e);
        }
    }

    protected final void onConnectionClosed(Connection<T> connection) {
        log.debug(this.getClass().getSimpleName() + " connection (" + connection.getConnectionNum() + ") was closed");
        this.connections.remove(connection);
        this.onDisconnected.accept(connection);
    }

    public final List<Connection<T>> getConnections() {
        return List.copyOf(this.connections);
    }

    private static class ConnectionThread
    extends Thread {
        ConnectionThread(String name, Runnable action) {
            super(action, name);
            this.setDaemon(true);
        }
    }
}

