/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.minigames.triggersequence;

import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.TriggerListener;
import com.almasb.fxgl.minigames.MiniGame;
import com.almasb.fxgl.minigames.MiniGameView;
import com.almasb.fxgl.minigames.triggersequence.TriggerSequenceMiniGame;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001aH\u0002J\b\u0010$\u001a\u00020\u001aH\u0002R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceView;", "Lcom/almasb/fxgl/minigames/MiniGameView;", "Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame;", "miniGame", "(Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame;)V", "animationBad", "Lcom/almasb/fxgl/animation/Animation;", "animationGood", "bad", "Ljavafx/scene/image/ImageView;", "bg", "Ljavafx/scene/shape/Circle;", "circle", "Ljavafx/scene/layout/StackPane;", "currentTriggerIndex", "", "firstTime", "", "good", "line1", "Ljavafx/scene/shape/Line;", "line2", "numCorrectTriggers", "triggerViews", "Ljavafx/scene/Group;", "checkTriggerPosition", "", "currentTriggerView", "Ljavafx/scene/Node;", "onInitInput", "input", "Lcom/almasb/fxgl/input/Input;", "onUpdate", "tpf", "", "startAnimationBad", "startAnimationGood", "fxgl-gameplay"})
public final class TriggerSequenceView
extends MiniGameView<TriggerSequenceMiniGame> {
    @NotNull
    private final Animation<?> animationGood;
    @NotNull
    private final Animation<?> animationBad;
    @NotNull
    private final StackPane circle;
    @NotNull
    private final Circle bg;
    @NotNull
    private final Line line1;
    @NotNull
    private final Line line2;
    @NotNull
    private final Group triggerViews;
    private int numCorrectTriggers;
    private int currentTriggerIndex;
    @NotNull
    private final ImageView good;
    @NotNull
    private final ImageView bad;
    private boolean firstTime;

    public TriggerSequenceView(@NotNull TriggerSequenceMiniGame miniGame) {
        Intrinsics.checkNotNullParameter(miniGame, "miniGame");
        super((MiniGame)miniGame);
        this.circle = new StackPane();
        this.bg = new Circle(40.0, 40.0, 40.0, Color.GREEN);
        this.line1 = new Line(0.0, 0.0, 0.0, 300.0);
        this.line2 = new Line(150.0, 0.0, 150.0, 300.0);
        this.triggerViews = new Group();
        this.good = new ImageView(new Image(this.getClass().getResourceAsStream("checkmark.png")));
        this.bad = new ImageView(new Image(this.getClass().getResourceAsStream("cross.png")));
        this.line1.setStrokeWidth(2.0);
        this.line2.setStrokeWidth(2.0);
        this.circle.setOpacity(0.0);
        Node[] nodeArray = new Node[]{this.bg, this.good};
        this.circle.getChildren().addAll((Node[])nodeArray);
        AnimationBuilder animationBuilder = new AnimationBuilder(null, 1, null);
        Duration duration = Duration.seconds(0.49);
        Intrinsics.checkNotNullExpressionValue(duration, "seconds(0.49)");
        nodeArray = new Node[]{this.circle};
        this.animationGood = animationBuilder.duration(duration).interpolator(Interpolators.ELASTIC.EASE_OUT()).onFinished(() -> TriggerSequenceView._init_$lambda$0(this)).translate(nodeArray).from(new Point2D(25.0, 40.0)).to(new Point2D(25.0, -40.0)).build();
        AnimationBuilder animationBuilder2 = new AnimationBuilder(null, 1, null);
        Duration duration2 = Duration.seconds(0.49);
        Intrinsics.checkNotNullExpressionValue(duration2, "seconds(0.49)");
        nodeArray = new Node[]{this.circle};
        this.animationBad = animationBuilder2.duration(duration2).onFinished(() -> TriggerSequenceView._init_$lambda$1(this)).interpolator(Interpolators.ELASTIC.EASE_OUT()).translate(nodeArray).from(new Point2D(25.0, 40.0)).to(new Point2D(25.0, 190.0)).build();
        nodeArray = new Node[]{this.line1, this.line2, this.circle, this.triggerViews};
        this.getChildren().addAll((Node[])nodeArray);
        this.firstTime = true;
    }

    public /* synthetic */ TriggerSequenceView(TriggerSequenceMiniGame triggerSequenceMiniGame, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            triggerSequenceMiniGame = new TriggerSequenceMiniGame(1.0);
        }
        this(triggerSequenceMiniGame);
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.firstTime) {
            this.firstTime = false;
            this.triggerViews.getChildren().addAll((Collection<Node>)((TriggerSequenceMiniGame)this.getMiniGame()).getViews());
        }
        this.animationGood.onUpdate(tpf);
        this.animationBad.onUpdate(tpf);
        ObservableList<Node> observableList = this.triggerViews.getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "triggerViews.children");
        if (!((Collection)observableList).isEmpty()) {
            Object e = this.triggerViews.getChildren().get(0);
            Intrinsics.checkNotNullExpressionValue(e, "triggerViews.children[0]");
            this.checkTriggerPosition((Node)e);
        } else {
            ((TriggerSequenceMiniGame)this.getMiniGame()).endGame(this.numCorrectTriggers);
        }
    }

    private final void checkTriggerPosition(Node currentTriggerView) {
        if (currentTriggerView.getTranslateX() < this.line1.getStartX()) {
            this.triggerViews.getChildren().remove(currentTriggerView);
            int n = this.currentTriggerIndex;
            this.currentTriggerIndex = n + 1;
            this.startAnimationBad();
        }
    }

    private final void startAnimationGood() {
        this.circle.setOpacity(1.0);
        this.animationGood.start();
        this.bg.setFill(Color.GREEN);
        this.circle.getChildren().set(1, this.good);
    }

    private final void startAnimationBad() {
        this.circle.setOpacity(1.0);
        this.animationBad.start();
        this.bg.setFill(Color.RED);
        this.circle.getChildren().set(1, this.bad);
    }

    @Override
    public void onInitInput(@NotNull Input input) {
        Intrinsics.checkNotNullParameter(input, "input");
        input.addTriggerListener(new TriggerListener(this){
            final /* synthetic */ TriggerSequenceView this$0;
            {
                this.this$0 = $receiver;
            }

            protected void onActionBegin(@NotNull Trigger trigger) {
                Intrinsics.checkNotNullParameter(trigger, "trigger");
                if (trigger instanceof KeyTrigger) {
                    int n;
                    TriggerSequenceView triggerSequenceView;
                    KeyCode key = ((KeyTrigger)trigger).getKey();
                    if (TriggerSequenceView.access$getTriggerViews$p(this.this$0).getChildren().isEmpty()) {
                        return;
                    }
                    Node currentTrigger = (Node)TriggerSequenceView.access$getTriggerViews$p(this.this$0).getChildren().remove(0);
                    if (((TriggerSequenceMiniGame)this.this$0.getMiniGame()).isCorrect(key, TriggerSequenceView.access$getCurrentTriggerIndex$p(this.this$0)) && currentTrigger.getTranslateX() >= TriggerSequenceView.access$getLine1$p(this.this$0).getStartX() && currentTrigger.getTranslateX() <= TriggerSequenceView.access$getLine2$p(this.this$0).getStartX()) {
                        TriggerSequenceView.access$startAnimationGood(this.this$0);
                        triggerSequenceView = this.this$0;
                        n = TriggerSequenceView.access$getNumCorrectTriggers$p(triggerSequenceView);
                        TriggerSequenceView.access$setNumCorrectTriggers$p(triggerSequenceView, n + 1);
                    } else {
                        TriggerSequenceView.access$startAnimationBad(this.this$0);
                    }
                    triggerSequenceView = this.this$0;
                    n = TriggerSequenceView.access$getCurrentTriggerIndex$p(triggerSequenceView);
                    TriggerSequenceView.access$setCurrentTriggerIndex$p(triggerSequenceView, n + 1);
                }
            }
        });
    }

    private static final void _init_$lambda$0(TriggerSequenceView this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.circle.setOpacity(0.0);
    }

    private static final void _init_$lambda$1(TriggerSequenceView this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.circle.setOpacity(0.0);
    }

    public TriggerSequenceView() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Group access$getTriggerViews$p(TriggerSequenceView $this) {
        return $this.triggerViews;
    }

    public static final /* synthetic */ int access$getCurrentTriggerIndex$p(TriggerSequenceView $this) {
        return $this.currentTriggerIndex;
    }

    public static final /* synthetic */ Line access$getLine1$p(TriggerSequenceView $this) {
        return $this.line1;
    }

    public static final /* synthetic */ Line access$getLine2$p(TriggerSequenceView $this) {
        return $this.line2;
    }

    public static final /* synthetic */ void access$startAnimationGood(TriggerSequenceView $this) {
        $this.startAnimationGood();
    }

    public static final /* synthetic */ int access$getNumCorrectTriggers$p(TriggerSequenceView $this) {
        return $this.numCorrectTriggers;
    }

    public static final /* synthetic */ void access$setNumCorrectTriggers$p(TriggerSequenceView $this, int n) {
        $this.numCorrectTriggers = n;
    }

    public static final /* synthetic */ void access$startAnimationBad(TriggerSequenceView $this) {
        $this.startAnimationBad();
    }

    public static final /* synthetic */ void access$setCurrentTriggerIndex$p(TriggerSequenceView $this, int n) {
        $this.currentTriggerIndex = n;
    }
}

