/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.minigames.triggersequence;

import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.view.TriggerView;
import com.almasb.fxgl.minigames.MiniGame;
import com.almasb.fxgl.minigames.MiniGameResult;
import com.almasb.fxgl.minigames.triggersequence.TriggerSequenceResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.beans.binding.DoubleBinding;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tJ\u0016\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tJ\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR!\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0014j\b\u0012\u0004\u0012\u00020\u001a`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame;", "Lcom/almasb/fxgl/minigames/MiniGame;", "Lcom/almasb/fxgl/minigames/triggersequence/TriggerSequenceResult;", "winRatio", "", "(D)V", "firstTime", "", "moveSpeed", "", "getMoveSpeed", "()I", "setMoveSpeed", "(I)V", "numTriggers", "getNumTriggers", "numTriggersForSuccess", "getNumTriggersForSuccess", "setNumTriggersForSuccess", "triggers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/input/KeyTrigger;", "Lkotlin/collections/ArrayList;", "getTriggers", "()Ljava/util/ArrayList;", "views", "Lcom/almasb/fxgl/input/view/TriggerView;", "getViews", "getWinRatio", "()D", "endGame", "", "numCorrectTriggers", "isCorrect", "key", "Ljavafx/scene/input/KeyCode;", "currentIndex", "onUpdate", "tpf", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nTriggerSequenceMiniGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TriggerSequenceMiniGame.kt\ncom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1549#2:196\n1620#2,3:197\n1864#2,3:200\n1855#2,2:203\n*S KotlinDebug\n*F\n+ 1 TriggerSequenceMiniGame.kt\ncom/almasb/fxgl/minigames/triggersequence/TriggerSequenceMiniGame\n*L\n169#1:196\n169#1:197,3\n170#1:200,3\n179#1:203,2\n*E\n"})
public final class TriggerSequenceMiniGame
extends MiniGame<TriggerSequenceResult> {
    private final double winRatio;
    private int numTriggersForSuccess;
    private int moveSpeed;
    @NotNull
    private final ArrayList<KeyTrigger> triggers;
    @NotNull
    private final ArrayList<TriggerView> views;
    private boolean firstTime;

    public TriggerSequenceMiniGame(double winRatio) {
        this.winRatio = winRatio;
        this.moveSpeed = 350;
        this.triggers = new ArrayList();
        this.views = new ArrayList();
        this.firstTime = true;
    }

    public final double getWinRatio() {
        return this.winRatio;
    }

    public final int getNumTriggersForSuccess() {
        return this.numTriggersForSuccess;
    }

    public final void setNumTriggersForSuccess(int n) {
        this.numTriggersForSuccess = n;
    }

    public final int getNumTriggers() {
        return this.triggers.size();
    }

    public final int getMoveSpeed() {
        return this.moveSpeed;
    }

    public final void setMoveSpeed(int n) {
        this.moveSpeed = n;
    }

    @NotNull
    public final ArrayList<KeyTrigger> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public final ArrayList<TriggerView> getViews() {
        return this.views;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onUpdate(double tpf) {
        if (this.firstTime) {
            Iterator $this$mapTo$iv$iv;
            this.numTriggersForSuccess = this.triggers.size();
            Collection collection = this.views;
            Iterable $this$map$iv = this.triggers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            int $i$f$mapTo = 0;
            Object object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                void it;
                Object item$iv$iv = object.next();
                KeyTrigger keyTrigger = (KeyTrigger)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Trigger trigger = (Trigger)it;
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "GRAY");
                collection2.add(new TriggerView(trigger, color, 74.0));
            }
            $this$map$iv = (List)destination$iv$iv;
            CollectionsKt.addAll(collection, $this$map$iv);
            Iterable $this$forEachIndexed$iv = this.views;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void item;
                if (($i$f$mapTo = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (TriggerView)item$iv;
                int i2 = $i$f$mapTo;
                boolean bl = false;
                item.setTranslateX(400.0 + (double)(300 * i2));
                item.setTranslateY(100.0);
                item.opacityProperty().bind(((DoubleBinding)item.translateXProperty().divide((double)this.getNumTriggers() * 100.0).negate()).add(1));
            }
            this.firstTime = false;
        }
        Iterable $this$forEach$iv = this.views;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TriggerView it = (TriggerView)element$iv;
            boolean bl = false;
            it.setTranslateX(it.getTranslateX() - (double)this.moveSpeed * tpf);
        }
    }

    public final void endGame(int numCorrectTriggers) {
        this.setDone(true);
        double ratio = (double)numCorrectTriggers / (double)this.getNumTriggers();
        this.setResult((MiniGameResult)new TriggerSequenceResult(ratio >= this.winRatio, ratio));
    }

    public final boolean isCorrect(@NotNull KeyCode key, int currentIndex) {
        Intrinsics.checkNotNullParameter((Object)key, "key");
        return this.triggers.get(currentIndex).getKey() == key;
    }
}

