/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.minigames.triggermash;

import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.minigames.MiniGame;
import com.almasb.fxgl.minigames.MiniGameView;
import com.almasb.fxgl.minigames.triggermash.TriggerMashMiniGame;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/minigames/triggermash/CircleTriggerMashView;", "Lcom/almasb/fxgl/minigames/MiniGameView;", "Lcom/almasb/fxgl/minigames/triggermash/TriggerMashMiniGame;", "trigger", "Lcom/almasb/fxgl/input/KeyTrigger;", "miniGame", "(Lcom/almasb/fxgl/input/KeyTrigger;Lcom/almasb/fxgl/minigames/triggermash/TriggerMashMiniGame;)V", "animation", "Lcom/almasb/fxgl/animation/Animation;", "onInitInput", "", "input", "Lcom/almasb/fxgl/input/Input;", "onUpdate", "tpf", "", "fxgl-gameplay"})
public final class CircleTriggerMashView
extends MiniGameView<TriggerMashMiniGame> {
    @NotNull
    private final Animation<?> animation;

    public CircleTriggerMashView(@NotNull KeyTrigger trigger, @NotNull TriggerMashMiniGame miniGame) {
        Intrinsics.checkNotNullParameter(trigger, "trigger");
        Intrinsics.checkNotNullParameter(miniGame, "miniGame");
        super((MiniGame)miniGame);
        Circle circle = new Circle(100.0, 100.0, 40.0, null);
        circle.setStroke(Color.DARKGREEN);
        circle.setStrokeWidth(5.0);
        Arc arc = new Arc();
        arc.setCenterX(100.0);
        arc.setCenterY(100.0);
        arc.setRadiusX(circle.getRadius());
        arc.setRadiusY(circle.getRadius());
        arc.setStartAngle(90.0);
        arc.setType(ArcType.OPEN);
        arc.setFill(null);
        arc.setStroke(Color.YELLOW);
        arc.setStrokeWidth(3.0);
        arc.getTransforms().add(new Scale(-1.0, 1.0, arc.getCenterX(), arc.getCenterY()));
        arc.lengthProperty().bind(miniGame.getFillValue().divide(100.0).multiply(360));
        Text letter = new Text(miniGame.getTrigger().toString());
        letter.setFont(Font.font(36.0));
        letter.setStroke(Color.BLACK);
        letter.setFill(Color.YELLOW);
        letter.setStrokeWidth(1.5);
        letter.setTextOrigin(VPos.TOP);
        letter.setTranslateX(100.0 - letter.getLayoutBounds().getWidth() / (double)2);
        letter.setTranslateY(100.0 - letter.getLayoutBounds().getHeight() / (double)2 - 1.5);
        Circle letterCircle = new Circle(100.0, 100.0, 20.0, null);
        letterCircle.setStroke(Color.color(0.76, 0.9, 0.0, 0.76));
        AnimationBuilder animationBuilder = new AnimationBuilder(null, 1, null);
        Duration duration = Duration.seconds(0.09);
        Intrinsics.checkNotNullExpressionValue(duration, "seconds(0.09)");
        Node[] nodeArray = new Node[]{letter, letterCircle};
        this.animation = animationBuilder.duration(duration).autoReverse(true).repeat(2).scale(nodeArray).from(new Point2D(1.0, 1.0)).to(new Point2D(1.4, 1.4)).build();
        Object[] objectArray = new Stop[]{new Stop(0.1, Color.color(0.1, 0.4, 0.9, 0.8)), new Stop(0.9, Color.color(0.1, 0.9, 0.1, 0.4))};
        Circle bg = new Circle(100.0, 100.0, 100.0, new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, (Stop[])objectArray));
        this.setEffect(new DropShadow(20.0, Color.BLACK));
        objectArray = new Node[]{bg, circle, arc, letter, letterCircle};
        this.getChildren().addAll((Node[])objectArray);
    }

    public /* synthetic */ CircleTriggerMashView(KeyTrigger keyTrigger, TriggerMashMiniGame triggerMashMiniGame, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            triggerMashMiniGame = new TriggerMashMiniGame(keyTrigger);
        }
        this(keyTrigger, triggerMashMiniGame);
    }

    @Override
    public void onUpdate(double tpf) {
        this.animation.onUpdate(tpf);
    }

    @Override
    public void onInitInput(@NotNull Input input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Input.addAction$default(input, new UserAction(this){
            final /* synthetic */ CircleTriggerMashView this$0;
            {
                this.this$0 = $receiver;
                super("Button Mash");
            }

            protected void onActionBegin() {
                CircleTriggerMashView.access$getAnimation$p(this.this$0).start();
                ((TriggerMashMiniGame)this.this$0.getMiniGame()).boost();
            }
        }, ((TriggerMashMiniGame)this.getMiniGame()).getTrigger().getKey(), null, 4, null);
    }

    public static final /* synthetic */ Animation access$getAnimation$p(CircleTriggerMashView $this) {
        return $this.animation;
    }
}

