/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.minigames.sweetspot;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.minigames.MiniGame;
import com.almasb.fxgl.minigames.MiniGameResult;
import com.almasb.fxgl.minigames.sweetspot.SweetSpotResult;
import javafx.beans.property.SimpleIntegerProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/minigames/sweetspot/SweetSpotMiniGame;", "Lcom/almasb/fxgl/minigames/MiniGame;", "Lcom/almasb/fxgl/minigames/sweetspot/SweetSpotResult;", "()V", "cursorAccumulator", "", "cursorValue", "Ljavafx/beans/property/SimpleIntegerProperty;", "getCursorValue", "()Ljavafx/beans/property/SimpleIntegerProperty;", "isIncreasing", "", "maxSuccessValue", "getMaxSuccessValue", "minSuccessValue", "getMinSuccessValue", "click", "", "onUpdate", "tpf", "randomizeRange", "successRange", "", "fxgl-gameplay"})
public final class SweetSpotMiniGame
extends MiniGame<SweetSpotResult> {
    private boolean isIncreasing = true;
    @NotNull
    private final SimpleIntegerProperty cursorValue = new SimpleIntegerProperty(0);
    private double cursorAccumulator;
    @NotNull
    private final SimpleIntegerProperty minSuccessValue = new SimpleIntegerProperty(0);
    @NotNull
    private final SimpleIntegerProperty maxSuccessValue = new SimpleIntegerProperty(0);

    @NotNull
    public final SimpleIntegerProperty getCursorValue() {
        return this.cursorValue;
    }

    @NotNull
    public final SimpleIntegerProperty getMinSuccessValue() {
        return this.minSuccessValue;
    }

    @NotNull
    public final SimpleIntegerProperty getMaxSuccessValue() {
        return this.maxSuccessValue;
    }

    public final void click() {
        Integer n = this.minSuccessValue.getValue();
        Intrinsics.checkNotNullExpressionValue(n, "minSuccessValue.value");
        int n2 = ((Number)n).intValue();
        Integer n3 = this.maxSuccessValue.getValue();
        Intrinsics.checkNotNullExpressionValue(n3, "maxSuccessValue.value");
        int n4 = ((Number)n3).intValue();
        Integer n5 = this.cursorValue.getValue();
        Intrinsics.checkNotNullExpressionValue(n5, "cursorValue.value");
        int n6 = ((Number)n5).intValue();
        boolean bl = n2 <= n6 ? n6 <= n4 : false;
        if (bl) {
            this.setResult((MiniGameResult)new SweetSpotResult(true));
        } else {
            this.setResult((MiniGameResult)new SweetSpotResult(false));
        }
        this.setDone(true);
    }

    public final void randomizeRange(int successRange) {
        if (!(0 <= successRange ? successRange < 101 : false)) {
            boolean bl = false;
            String string = "Success range must be in 0..100";
            throw new IllegalArgumentException(string.toString());
        }
        this.minSuccessValue.setValue(FXGLMath.random(0, 100 - successRange));
        this.maxSuccessValue.setValue(this.minSuccessValue.getValue() + successRange);
    }

    @Override
    public void onUpdate(double tpf) {
        int ratePerSecond = 140;
        double speed = tpf * (double)ratePerSecond;
        this.cursorAccumulator = this.isIncreasing ? (this.cursorAccumulator += speed) : (this.cursorAccumulator -= speed);
        if (this.cursorAccumulator > 100.0) {
            this.cursorAccumulator = 100.0;
            this.isIncreasing = false;
        }
        if (this.cursorAccumulator < 0.0) {
            this.cursorAccumulator = 0.0;
            this.isIncreasing = true;
        }
        this.cursorValue.setValue((int)this.cursorAccumulator);
    }
}

