/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.minigames.circuitbreaker;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.minigames.MiniGame;
import com.almasb.fxgl.minigames.MiniGameResult;
import com.almasb.fxgl.minigames.circuitbreaker.CircuitBreakerResult;
import com.almasb.fxgl.minigames.circuitbreaker.Maze;
import com.almasb.fxgl.minigames.circuitbreaker.MazeCell;
import javafx.geometry.Point2D;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\u0006\u0010*\u001a\u00020#J\u0010\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0006\u0010-\u001a\u00020#J\u0006\u0010.\u001a\u00020#R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u001f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/almasb/fxgl/minigames/circuitbreaker/CircuitBreakerMiniGame;", "Lcom/almasb/fxgl/minigames/MiniGame;", "Lcom/almasb/fxgl/minigames/circuitbreaker/CircuitBreakerResult;", "mazeWidth", "", "mazeHeight", "playerSize", "", "playerSpeed", "initialDelay", "Ljavafx/util/Duration;", "(IIDDLjavafx/util/Duration;)V", "DIR_DOWN", "Ljavafx/geometry/Point2D;", "DIR_LEFT", "DIR_RIGHT", "DIR_UP", "direction", "endPoint", "getEndPoint", "()Ljavafx/geometry/Point2D;", "maze", "Lcom/almasb/fxgl/minigames/circuitbreaker/Maze;", "getMaze", "()Lcom/almasb/fxgl/minigames/circuitbreaker/Maze;", "<set-?>", "playerPosition", "getPlayerPosition", "getPlayerSize", "()D", "getPlayerSpeed", "startPoint", "getStartPoint", "t", "down", "", "getMazeCell", "Lcom/almasb/fxgl/minigames/circuitbreaker/MazeCell;", "p", "isPlayerCollidingWithBounds", "", "isPlayerCollidingWithWalls", "left", "onUpdate", "tpf", "right", "up", "fxgl-gameplay"})
public final class CircuitBreakerMiniGame
extends MiniGame<CircuitBreakerResult> {
    private final double playerSize;
    private final double playerSpeed;
    @NotNull
    private final Duration initialDelay;
    @NotNull
    private final Maze maze;
    @NotNull
    private final Point2D startPoint;
    @NotNull
    private final Point2D endPoint;
    @NotNull
    private final Point2D DIR_UP;
    @NotNull
    private final Point2D DIR_DOWN;
    @NotNull
    private final Point2D DIR_LEFT;
    @NotNull
    private final Point2D DIR_RIGHT;
    @NotNull
    private Point2D direction;
    @NotNull
    private Point2D playerPosition;
    private double t;

    public CircuitBreakerMiniGame(int mazeWidth, int mazeHeight, double playerSize, double playerSpeed, @NotNull Duration initialDelay) {
        Intrinsics.checkNotNullParameter(initialDelay, "initialDelay");
        this.playerSize = playerSize;
        this.playerSpeed = playerSpeed;
        this.initialDelay = initialDelay;
        this.maze = new Maze(mazeWidth, mazeHeight);
        this.startPoint = new Point2D(700.0 / (double)this.maze.getWidth() * 0.5, 500.0 / (double)this.maze.getHeight() * 0.5);
        this.endPoint = new Point2D(700.0 - 700.0 / (double)this.maze.getWidth() * 0.5, 500.0 - 500.0 / (double)this.maze.getHeight() * 0.5);
        this.DIR_UP = new Point2D(0.0, -1.0);
        this.DIR_DOWN = new Point2D(0.0, 1.0);
        this.DIR_LEFT = new Point2D(-1.0, 0.0);
        this.DIR_RIGHT = new Point2D(1.0, 0.0);
        this.direction = new Point2D(1.0, 0.0);
        this.playerPosition = this.startPoint;
    }

    public final double getPlayerSize() {
        return this.playerSize;
    }

    public final double getPlayerSpeed() {
        return this.playerSpeed;
    }

    @NotNull
    public final Maze getMaze() {
        return this.maze;
    }

    @NotNull
    public final Point2D getStartPoint() {
        return this.startPoint;
    }

    @NotNull
    public final Point2D getEndPoint() {
        return this.endPoint;
    }

    @NotNull
    public final Point2D getPlayerPosition() {
        return this.playerPosition;
    }

    @Override
    public void onUpdate(double tpf) {
        this.t += tpf;
        if (this.t < this.initialDelay.toSeconds()) {
            return;
        }
        Point2D point2D = this.playerPosition.add(this.direction.multiply(tpf * this.playerSpeed));
        Intrinsics.checkNotNullExpressionValue(point2D, "playerPosition.add(direc\u2026tiply(tpf * playerSpeed))");
        this.playerPosition = point2D;
        if (this.isPlayerCollidingWithBounds() || this.isPlayerCollidingWithWalls()) {
            this.setDone(true);
            this.setResult((MiniGameResult)new CircuitBreakerResult(false));
        }
        if (this.playerPosition.distance(this.endPoint) < this.playerSize) {
            this.setDone(true);
            this.setResult((MiniGameResult)new CircuitBreakerResult(true));
        }
    }

    private final boolean isPlayerCollidingWithBounds() {
        return this.playerPosition.getX() < 0.0 || this.playerPosition.getY() < 0.0 || this.playerPosition.getX() + this.playerSize > 700.0 || this.playerPosition.getY() + this.playerSize > 500.0;
    }

    private final boolean isPlayerCollidingWithWalls() {
        MazeCell tl = this.getMazeCell(this.playerPosition);
        Point2D point2D = this.playerPosition.add(this.playerSize, 0.0);
        Intrinsics.checkNotNullExpressionValue(point2D, "playerPosition.add(playerSize, 0.0)");
        MazeCell tr = this.getMazeCell(point2D);
        Point2D point2D2 = this.playerPosition.add(0.0, this.playerSize);
        Intrinsics.checkNotNullExpressionValue(point2D2, "playerPosition.add(0.0, playerSize)");
        MazeCell bl = this.getMazeCell(point2D2);
        Point2D point2D3 = this.playerPosition.add(this.playerSize, this.playerSize);
        Intrinsics.checkNotNullExpressionValue(point2D3, "playerPosition.add(playerSize, playerSize)");
        MazeCell br = this.getMazeCell(point2D3);
        if (tl != tr && tr.getHasLeftWall$fxgl_gameplay()) {
            return true;
        }
        if (tl != bl && bl.getHasTopWall$fxgl_gameplay()) {
            return true;
        }
        if (tr != br && br.getHasTopWall$fxgl_gameplay()) {
            return true;
        }
        return bl != br && br.getHasLeftWall$fxgl_gameplay();
    }

    private final MazeCell getMazeCell(Point2D p) {
        int x = (int)Math.floor(FXGLMath.map(p.getX(), 0.0, 700.0, 0.0, this.maze.getWidth()));
        int y = (int)Math.floor(FXGLMath.map(p.getY(), 0.0, 500.0, 0.0, this.maze.getHeight()));
        if (!(x < this.maze.getWidth() && y < this.maze.getHeight())) {
            boolean bl = false;
            String string = "Bug: point " + p + " is at (" + x + "," + y + ") is outside of the maze (" + this.maze.getWidth() + "," + this.maze.getHeight() + ")";
            throw new IllegalStateException(string.toString());
        }
        return this.maze.getMazeCell(x, y);
    }

    public final void up() {
        if (this.direction != this.DIR_DOWN) {
            this.direction = this.DIR_UP;
        }
    }

    public final void down() {
        if (this.direction != this.DIR_UP) {
            this.direction = this.DIR_DOWN;
        }
    }

    public final void left() {
        if (this.direction != this.DIR_RIGHT) {
            this.direction = this.DIR_LEFT;
        }
    }

    public final void right() {
        if (this.direction != this.DIR_LEFT) {
            this.direction = this.DIR_RIGHT;
        }
    }
}

