/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.logging;

import com.almasb.fxgl.logging.DefaultMessageFormatter;
import com.almasb.fxgl.logging.LoggerConfig;
import com.almasb.fxgl.logging.LoggerKt;
import com.almasb.fxgl.logging.LoggerLevel;
import com.almasb.fxgl.logging.LoggerOutput;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ'\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/logging/Logger;", "", "name", "", "(Ljava/lang/String;)V", "debug", "", "message", "debugf", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "fatal", "error", "", "fatalf", "info", "infof", "warning", "warningf", "Companion", "fxgl-core"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final ArrayList<LoggerOutput> outputs = new ArrayList();
    @NotNull
    private static final ArrayList<LoggerOutput> debug = new ArrayList();
    @NotNull
    private static final ArrayList<LoggerOutput> info = new ArrayList();
    @NotNull
    private static final ArrayList<LoggerOutput> warning = new ArrayList();
    @NotNull
    private static final ArrayList<LoggerOutput> fatal = new ArrayList();
    @NotNull
    private static LoggerConfig config = new LoggerConfig();
    private static boolean isConfigured;
    private static boolean isClosed;

    private Logger(String name) {
        this.name = name;
    }

    public final void info(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.INFO);
    }

    public final void infof(@NotNull String format, Object ... args2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args2, "args");
        Object[] objectArray = Arrays.copyOf(args2, args2.length);
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        this.info(string);
    }

    public final void debug(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.DEBUG);
    }

    public final void debugf(@NotNull String format, Object ... args2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args2, "args");
        Object[] objectArray = Arrays.copyOf(args2, args2.length);
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        this.debug(string);
    }

    public final void warning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.WARN);
    }

    public final void warning(@NotNull String message2, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(error, "error");
        String trace = LoggerKt.stackTraceToString(error);
        this.warning(message2 + "\n" + trace);
    }

    public final void warningf(@NotNull String format, Object ... args2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args2, "args");
        Object[] objectArray = Arrays.copyOf(args2, args2.length);
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        this.warning(string);
    }

    public final void fatal(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.FATAL);
    }

    public final void fatal(@NotNull String message2, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(error, "error");
        String trace = LoggerKt.stackTraceToString(error);
        this.fatal(message2 + "\n" + trace);
    }

    public final void fatalf(@NotNull String format, Object ... args2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(args2, "args");
        Object[] objectArray = Arrays.copyOf(args2, args2.length);
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        this.fatal(string);
    }

    @JvmStatic
    public static final boolean isConfigured() {
        return Companion.isConfigured();
    }

    @JvmStatic
    public static final void configure(@NotNull LoggerConfig config) {
        Companion.configure(config);
    }

    @JvmStatic
    public static final void addOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
        Companion.addOutput(loggerOutput, level);
    }

    @JvmStatic
    public static final void removeOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
        Companion.removeOutput(loggerOutput, level);
    }

    @JvmStatic
    public static final void removeAllOutputs() {
        Companion.removeAllOutputs();
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull String name) {
        return Companion.get(name);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull Class<?> caller) {
        return Companion.get(caller);
    }

    @JvmStatic
    public static final void close() {
        Companion.close();
    }

    public /* synthetic */ Logger(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0011H\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0011\u0010\u001b\u001a\u00020\u001c\"\u0006\b\u0000\u0010\u001d\u0018\u0001H\u0086\bJ\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0019H\u0007J\b\u0010\r\u001a\u00020\fH\u0007J \u0010!\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0007J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/almasb/fxgl/logging/Logger$Companion;", "", "()V", "config", "Lcom/almasb/fxgl/logging/LoggerConfig;", "debug", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/logging/LoggerOutput;", "Lkotlin/collections/ArrayList;", "fatal", "info", "isClosed", "", "isConfigured", "outputs", "warning", "addOutput", "", "loggerOutput", "level", "Lcom/almasb/fxgl/logging/LoggerLevel;", "close", "configure", "doLog", "loggerName", "", "loggerMessage", "get", "Lcom/almasb/fxgl/logging/Logger;", "T", "caller", "Ljava/lang/Class;", "name", "makeMessage", "removeAllOutputs", "removeOutput", "fxgl-core"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1855#2,2:281\n1855#2,2:283\n1855#2,2:285\n1855#2,2:287\n1855#2,2:289\n*S KotlinDebug\n*F\n+ 1 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n*L\n130#1:281,2\n134#1:283,2\n138#1:285,2\n142#1:287,2\n170#1:289,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isConfigured() {
            return isConfigured;
        }

        @JvmStatic
        public final void configure(@NotNull LoggerConfig config) {
            Intrinsics.checkNotNullParameter(config, "config");
            if (isConfigured) {
                this.doLog("Logger", "Logger already configured", LoggerLevel.WARN);
                return;
            }
            config = config.copy$fxgl_core();
            isConfigured = true;
            this.doLog("Logger", "Configured Logger", LoggerLevel.DEBUG);
        }

        @JvmStatic
        public final void addOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
            Intrinsics.checkNotNullParameter(loggerOutput, "loggerOutput");
            Intrinsics.checkNotNullParameter((Object)level, "level");
            outputs.add(loggerOutput);
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    debug.add(loggerOutput);
                    info.add(loggerOutput);
                    warning.add(loggerOutput);
                    fatal.add(loggerOutput);
                    break;
                }
                case 2: {
                    info.add(loggerOutput);
                    warning.add(loggerOutput);
                    fatal.add(loggerOutput);
                    break;
                }
                case 3: {
                    warning.add(loggerOutput);
                    fatal.add(loggerOutput);
                    break;
                }
                case 4: {
                    fatal.add(loggerOutput);
                }
            }
        }

        @JvmStatic
        public final void removeOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
            Intrinsics.checkNotNullParameter(loggerOutput, "loggerOutput");
            Intrinsics.checkNotNullParameter((Object)level, "level");
            outputs.remove(loggerOutput);
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    debug.remove(loggerOutput);
                    info.remove(loggerOutput);
                    warning.remove(loggerOutput);
                    fatal.remove(loggerOutput);
                    break;
                }
                case 2: {
                    info.remove(loggerOutput);
                    warning.remove(loggerOutput);
                    fatal.remove(loggerOutput);
                    break;
                }
                case 3: {
                    warning.remove(loggerOutput);
                    fatal.remove(loggerOutput);
                    break;
                }
                case 4: {
                    fatal.remove(loggerOutput);
                }
            }
        }

        @JvmStatic
        public final void removeAllOutputs() {
            outputs.clear();
            debug.clear();
            info.clear();
            warning.clear();
            fatal.clear();
        }

        private final void doLog(String loggerName, String loggerMessage, LoggerLevel level) {
            Lazy message2 = LazyKt.lazy((Function0)new Function0<String>(loggerName, loggerMessage, level){
                final /* synthetic */ String $loggerName;
                final /* synthetic */ String $loggerMessage;
                final /* synthetic */ LoggerLevel $level;
                {
                    this.$loggerName = $loggerName;
                    this.$loggerMessage = $loggerMessage;
                    this.$level = $level;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return com.almasb.fxgl.logging.Logger$Companion.access$makeMessage(Logger.Companion, this.$loggerName, this.$loggerMessage, this.$level);
                }
            });
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    Iterable $this$forEach$iv = debug;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 2: {
                    Iterable $this$forEach$iv = info;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 3: {
                    Iterable $this$forEach$iv = warning;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 4: {
                    Iterable $this$forEach$iv = fatal;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
            }
        }

        private final String makeMessage(String loggerName, String loggerMessage, LoggerLevel level) {
            String time = LocalTime.now().format(config.getDateTimeFormatter());
            String threadName = Thread.currentThread().getName();
            DefaultMessageFormatter defaultMessageFormatter = config.getMessageFormatter();
            Intrinsics.checkNotNullExpressionValue(time, "time");
            Intrinsics.checkNotNullExpressionValue(threadName, "threadName");
            return defaultMessageFormatter.makeMessage(time, threadName, String.valueOf((Object)level), loggerName, loggerMessage);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Logger(name, null);
        }

        public final /* synthetic */ <T> Logger get() {
            boolean $i$f$get = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this.get(Object.class);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull Class<?> caller) {
            Intrinsics.checkNotNullParameter(caller, "caller");
            String string = caller.getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "caller.simpleName");
            return this.get(string);
        }

        @JvmStatic
        public final void close() {
            if (isClosed) {
                this.doLog("Logger", "Logger already closed", LoggerLevel.WARN);
                return;
            }
            this.doLog("Logger", "Closing Logger", LoggerLevel.DEBUG);
            Iterable $this$forEach$iv = outputs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LoggerOutput p0 = (LoggerOutput)element$iv;
                boolean bl = false;
                p0.close();
            }
            isClosed = true;
        }

        public static final /* synthetic */ String access$makeMessage(Companion $this, String loggerName, String loggerMessage, LoggerLevel level) {
            return $this.makeMessage(loggerName, loggerMessage, level);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LoggerLevel.values().length];
                try {
                    nArray[LoggerLevel.DEBUG.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LoggerLevel.INFO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LoggerLevel.WARN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LoggerLevel.FATAL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

