/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.io;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.fxgl.io.FileSystemAccess;
import com.almasb.fxgl.io.FileSystemService;
import com.almasb.fxgl.logging.Logger;
import com.gluonhq.attach.storage.StorageService;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0010J\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J\"\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J0\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001d0\r\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0013\u001a\u00020\u0010J:\u0010!\u001a&\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e \"*\u0012\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0010J@\u0010!\u001a&\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e \"*\u0012\u0012\f\u0012\n \"*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/almasb/fxgl/io/FileSystemService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "fs", "Lcom/almasb/fxgl/io/FileSystemAccess;", "isFileSystemWriteAllowed", "", "isMobile", "log", "Lcom/almasb/fxgl/logging/Logger;", "checkWriteAllowed", "", "createDirectoryTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "Ljava/lang/Void;", "dirName", "", "deleteDirectoryTask", "deleteFileTask", "fileName", "exists", "pathName", "loadDirectoryNamesTask", "", "recursive", "loadFileNamesTask", "extensions", "Lcom/almasb/fxgl/io/FileExtension;", "loadLastModifiedFileTask", "T", "normalize", "onInit", "readDataTask", "writeDataTask", "kotlin.jvm.PlatformType", "data", "Ljava/io/Serializable;", "text", "fxgl-io"})
public final class FileSystemService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    @Inject(value="isMobile")
    private boolean isMobile;
    @Inject(value="isFileSystemWriteAllowed")
    private boolean isFileSystemWriteAllowed = true;
    private FileSystemAccess fs;

    @Override
    public void onInit() {
        File rootStorage2 = !this.isMobile ? new File(System.getProperty("user.dir") + "/") : (File)StorageService.create().flatMap(arg_0 -> FileSystemService.onInit$lambda$0(onInit.rootStorage.1.INSTANCE, arg_0)).orElseThrow(FileSystemService::onInit$lambda$1);
        Intrinsics.checkNotNullExpressionValue(rootStorage2, "rootStorage");
        this.fs = new FileSystemAccess(rootStorage2);
    }

    public final boolean exists(@NotNull String pathName) {
        Intrinsics.checkNotNullParameter(pathName, "pathName");
        FileSystemAccess fileSystemAccess = this.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        return fileSystemAccess.exists(pathName);
    }

    @NotNull
    public final IOTask<Void> createDirectoryTask(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter(dirName, "dirName");
        IOTask<Void> iOTask = IOTask.ofVoid("createDirectoryTask(" + dirName + ")", () -> FileSystemService.createDirectoryTask$lambda$2(this, dirName));
        Intrinsics.checkNotNullExpressionValue(iOTask, "ofVoid(\"createDirectoryT\u2026eDirectory(dirName)\n    }");
        return iOTask;
    }

    public final IOTask<Void> writeDataTask(@NotNull Serializable data, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return IOTask.ofVoid("writeDataTask(" + fileName + ")", () -> FileSystemService.writeDataTask$lambda$3(this, data, fileName));
    }

    public final IOTask<Void> writeDataTask(@NotNull List<String> text, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return IOTask.ofVoid("writeDataTask(" + fileName + ")", () -> FileSystemService.writeDataTask$lambda$4(this, text, fileName));
    }

    @NotNull
    public final <T> IOTask<T> readDataTask(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        IOTask<Object> iOTask = IOTask.of("readDataTask(" + fileName + ")", () -> FileSystemService.readDataTask$lambda$5(this, fileName));
        Intrinsics.checkNotNullExpressionValue(iOTask, "of(\"readDataTask($fileNa\u2026adData<T>(fileName)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter(dirName, "dirName");
        IOTask<List<String>> iOTask = IOTask.of("loadFileNamesTask(" + dirName + ", " + recursive + ")", () -> FileSystemService.loadFileNamesTask$lambda$6(this, dirName, recursive));
        Intrinsics.checkNotNullExpressionValue(iOTask, "of(\"loadFileNamesTask($d\u2026dirName, recursive)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<String>> loadFileNamesTask(@NotNull String dirName, boolean recursive, @NotNull List<FileExtension> extensions) {
        Intrinsics.checkNotNullParameter(dirName, "dirName");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        IOTask<List<String>> iOTask = IOTask.of("loadFileNamesTask(" + dirName + ", " + recursive + ", " + extensions + ")", () -> FileSystemService.loadFileNamesTask$lambda$7(this, dirName, recursive, extensions));
        Intrinsics.checkNotNullExpressionValue(iOTask, "of(\"loadFileNamesTask($d\u2026ursive, extensions)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<List<String>> loadDirectoryNamesTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter(dirName, "dirName");
        IOTask<List<String>> iOTask = IOTask.of("loadDirectoryNamesTask(" + dirName + ", " + recursive + ")", () -> FileSystemService.loadDirectoryNamesTask$lambda$8(this, dirName, recursive));
        Intrinsics.checkNotNullExpressionValue(iOTask, "of(\"loadDirectoryNamesTa\u2026dirName, recursive)\n    }");
        return iOTask;
    }

    @NotNull
    public final <T> IOTask<T> loadLastModifiedFileTask(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkNotNullParameter(dirName, "dirName");
        IOTask iOTask = IOTask.of("loadLastModifiedFileTask(" + dirName + ", " + recursive + ")", () -> FileSystemService.loadLastModifiedFileTask$lambda$9(this, dirName, recursive)).then(arg_0 -> FileSystemService.loadLastModifiedFileTask$lambda$10(this, dirName, arg_0));
        Intrinsics.checkNotNullExpressionValue(iOTask, "of(\"loadLastModifiedFile\u2026ze(dirName) + fileName) }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> deleteFileTask(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        IOTask<Void> iOTask = IOTask.ofVoid("deleteFileTask(" + fileName + ")", () -> FileSystemService.deleteFileTask$lambda$11(this, fileName));
        Intrinsics.checkNotNullExpressionValue(iOTask, "ofVoid(\"deleteFileTask($\u2026eleteFile(fileName)\n    }");
        return iOTask;
    }

    @NotNull
    public final IOTask<Void> deleteDirectoryTask(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter(dirName, "dirName");
        IOTask<Void> iOTask = IOTask.ofVoid("deleteDirectoryTask(" + dirName + ")", () -> FileSystemService.deleteDirectoryTask$lambda$12(this, dirName));
        Intrinsics.checkNotNullExpressionValue(iOTask, "ofVoid(\"deleteDirectoryT\u2026eDirectory(dirName)\n    }");
        return iOTask;
    }

    private final String normalize(String dirName) {
        return StringsKt.endsWith$default((CharSequence)dirName, File.separatorChar, false, 2, null) ? dirName : dirName + File.separatorChar;
    }

    private final void checkWriteAllowed() {
        if (!this.isFileSystemWriteAllowed) {
            boolean bl = false;
            this.log.warning("Attempted to make a write call but FS write is not allowed");
            String string = "isFileSystemWriteAllowed is false";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final Optional onInit$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final RuntimeException onInit$lambda$1() {
        return new RuntimeException("No private storage present");
    }

    private static final void createDirectoryTask$lambda$2(FileSystemService this$0, String $dirName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        fileSystemAccess.createDirectory($dirName);
    }

    private static final void writeDataTask$lambda$3(FileSystemService this$0, Serializable $data, String $fileName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($data, "$data");
        Intrinsics.checkNotNullParameter($fileName, "$fileName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        fileSystemAccess.writeData($data, $fileName);
    }

    private static final void writeDataTask$lambda$4(FileSystemService this$0, List $text, String $fileName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($text, "$text");
        Intrinsics.checkNotNullParameter($fileName, "$fileName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        fileSystemAccess.writeData($text, $fileName);
    }

    private static final Object readDataTask$lambda$5(FileSystemService this$0, String $fileName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($fileName, "$fileName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        return fileSystemAccess.readData($fileName);
    }

    private static final List loadFileNamesTask$lambda$6(FileSystemService this$0, String $dirName, boolean $recursive) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        return fileSystemAccess.loadFileNames($dirName, $recursive);
    }

    private static final List loadFileNamesTask$lambda$7(FileSystemService this$0, String $dirName, boolean $recursive, List $extensions) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        Intrinsics.checkNotNullParameter($extensions, "$extensions");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        return fileSystemAccess.loadFileNames($dirName, $recursive, $extensions);
    }

    private static final List loadDirectoryNamesTask$lambda$8(FileSystemService this$0, String $dirName, boolean $recursive) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        return fileSystemAccess.loadDirectoryNames($dirName, $recursive);
    }

    private static final String loadLastModifiedFileTask$lambda$9(FileSystemService this$0, String $dirName, boolean $recursive) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        return fileSystemAccess.loadLastModifiedFileName($dirName, $recursive);
    }

    private static final IOTask loadLastModifiedFileTask$lambda$10(FileSystemService this$0, String $dirName, String fileName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        return this$0.readDataTask(this$0.normalize($dirName) + fileName);
    }

    private static final void deleteFileTask$lambda$11(FileSystemService this$0, String $fileName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($fileName, "$fileName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        fileSystemAccess.deleteFile($fileName);
    }

    private static final void deleteDirectoryTask$lambda$12(FileSystemService this$0, String $dirName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($dirName, "$dirName");
        this$0.checkWriteAllowed();
        FileSystemAccess fileSystemAccess = this$0.fs;
        if (fileSystemAccess == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fs");
            fileSystemAccess = null;
        }
        fileSystemAccess.deleteDirectory($dirName);
    }
}

