/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.inventory;

import com.almasb.fxgl.inventory.ItemConfig;
import com.almasb.fxgl.inventory.ItemData;
import com.almasb.fxgl.inventory.ItemStack;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.IntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00028\u00002\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010$J5\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00028\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010*J\u001f\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0,2\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\u00020\u00042\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00020\u000f2\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u00101J\u001b\u00102\u001a\u00020\u000f2\u0006\u0010 \u001a\u00028\u00002\u0006\u00103\u001a\u00020\u0004\u00a2\u0006\u0002\u00104J\u0013\u00105\u001a\u0002062\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u00107J\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012J\u0013\u00108\u001a\u0002092\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010:J\u0014\u0010;\u001a\u00020\u000f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J-\u0010=\u001a\u00020\u000f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010 \u001a\u00028\u00002\b\b\u0002\u0010#\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010>R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0005R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010RJ\u0010\u0011\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0014*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0013 \u0014*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0014*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0013\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0015\u001a*\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0016j\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u0018\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0014*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0013 \u0014*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0014*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00130\u0013\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\f\u00a8\u0006?"}, d2={"Lcom/almasb/fxgl/inventory/Inventory;", "T", "", "capacity", "", "(I)V", "allData", "", "Lcom/almasb/fxgl/inventory/ItemData;", "getAllData", "()Ljava/util/Map;", "getCapacity", "()I", "setCapacity", "isFull", "", "()Z", "items", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/inventory/ItemStack;", "kotlin.jvm.PlatformType", "itemsData", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "itemsProperty", "log", "Lcom/almasb/fxgl/logging/Logger;", "numFreeStacks", "getNumFreeStacks", "size", "getSize", "add", "item", "config", "Lcom/almasb/fxgl/inventory/ItemConfig;", "quantity", "(Ljava/lang/Object;Lcom/almasb/fxgl/inventory/ItemConfig;I)Z", "name", "", "description", "view", "Ljavafx/scene/Node;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljavafx/scene/Node;I)Z", "getData", "Ljava/util/Optional;", "(Ljava/lang/Object;)Ljava/util/Optional;", "getItemQuantity", "(Ljava/lang/Object;)I", "hasItem", "(Ljava/lang/Object;)Z", "incrementQuantity", "amount", "(Ljava/lang/Object;I)Z", "itemQuantityProperty", "Ljavafx/beans/property/IntegerProperty;", "(Ljava/lang/Object;)Ljavafx/beans/property/IntegerProperty;", "remove", "", "(Ljava/lang/Object;)V", "transferAllFrom", "other", "transferFrom", "(Lcom/almasb/fxgl/inventory/Inventory;Ljava/lang/Object;I)Z", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nInventory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Inventory.kt\ncom/almasb/fxgl/inventory/Inventory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n766#2:380\n857#2,2:381\n1855#2,2:383\n1855#2,2:385\n*S KotlinDebug\n*F\n+ 1 Inventory.kt\ncom/almasb/fxgl/inventory/Inventory\n*L\n177#1:380\n177#1:381,2\n195#1:383,2\n218#1:385,2\n*E\n"})
public final class Inventory<T> {
    private int capacity;
    @NotNull
    private final Logger log;
    private final ObservableList<ItemStack<T>> items;
    private final ObservableList<ItemStack<T>> itemsProperty;
    @NotNull
    private final HashMap<T, ItemData<T>> itemsData;

    public Inventory(int capacity) {
        this.capacity = capacity;
        this.log = Logger.Companion.get(this.getClass());
        this.items = FXCollections.observableArrayList();
        this.itemsProperty = FXCollections.unmodifiableObservableList(this.items);
        this.itemsData = new HashMap();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void setCapacity(int n) {
        this.capacity = n;
    }

    @NotNull
    public final ObservableList<ItemStack<T>> itemsProperty() {
        ObservableList<ItemStack<T>> observableList = this.itemsProperty;
        Intrinsics.checkNotNullExpressionValue(observableList, "itemsProperty");
        return observableList;
    }

    public final int getSize() {
        return this.items.size();
    }

    @NotNull
    public final Map<T, ItemData<T>> getAllData() {
        return MapsKt.toMap((Map)this.itemsData);
    }

    @NotNull
    public final Optional<ItemData<T>> getData(T item) {
        Optional<ItemData<T>> optional = Optional.ofNullable(this.itemsData.get(item));
        Intrinsics.checkNotNullExpressionValue(optional, "ofNullable(itemsData[item])");
        return optional;
    }

    public final boolean hasItem(T item) {
        return ((Map)this.itemsData).containsKey(item);
    }

    public final int getNumFreeStacks() {
        return this.capacity - this.getSize();
    }

    public final boolean isFull() {
        return this.getSize() == this.capacity;
    }

    @NotNull
    public final IntegerProperty itemQuantityProperty(T item) {
        ItemData<T> itemData = this.itemsData.get(item);
        if (itemData == null || (itemData = itemData.quantityProperty()) == null) {
            throw new IllegalArgumentException("Item " + item + " is not in " + this.itemsData);
        }
        return (IntegerProperty)((Object)itemData);
    }

    public final int getItemQuantity(T item) {
        int n;
        try {
            Integer n2 = this.itemQuantityProperty(item).getValue();
            Intrinsics.checkNotNullExpressionValue(n2, "{\n            itemQuanti\u2026rty(item).value\n        }");
            n = ((Number)n2).intValue();
        }
        catch (IllegalArgumentException e) {
            n = 0;
        }
        return n;
    }

    @Deprecated(message="Use add(ItemConfig)", replaceWith=@ReplaceWith(expression="add(com.almasb.fxgl.inventory.ItemConfig)", imports={}))
    public final boolean add(T item, @NotNull String name, @NotNull String description, @NotNull Node view2, int quantity) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(description, "description");
        Intrinsics.checkNotNullParameter(view2, "view");
        return this.add(item, new ItemConfig(name, description, Integer.MAX_VALUE, view2), quantity);
    }

    @JvmOverloads
    public final boolean add(T item, @NotNull ItemConfig config, int quantity) {
        Intrinsics.checkNotNullParameter(config, "config");
        if (this.hasItem(item)) {
            return this.incrementQuantity(item, quantity);
        }
        if (this.isFull()) {
            return false;
        }
        if (quantity <= 0) {
            this.log.warning("Attempted to add a *NEW* item with 0 or negative quantity. Ignoring");
            return false;
        }
        int numStacksNeeded = (int)Math.ceil((double)quantity / (double)config.getMaxStackQuantity());
        if (numStacksNeeded > this.getNumFreeStacks()) {
            return false;
        }
        Object object = new ItemData<T>(item);
        ItemData<T> it = object;
        boolean bl = false;
        it.setName(config.getName());
        it.setDescription(config.getDescription());
        it.setView(config.getView());
        it.setMaxStackQuantity(config.getMaxStackQuantity());
        it.incrementQuantity$fxgl_gameplay(quantity);
        ItemData<T> data = object;
        ((Map)this.itemsData).put(item, data);
        ObservableList<ItemStack<T>> observableList = this.items;
        Intrinsics.checkNotNullExpressionValue(observableList, "items");
        object = observableList;
        ObservableList<ItemStack<T>> observableList2 = data.getStacks();
        Intrinsics.checkNotNullExpressionValue(observableList2, "data.stacks");
        CollectionsKt.addAll(object, (Iterable)observableList2);
        return true;
    }

    public static /* synthetic */ boolean add$default(Inventory inventory, Object object, ItemConfig itemConfig, int n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            itemConfig = new ItemConfig(null, null, 0, null, 15, null);
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return inventory.add(object, itemConfig, n);
    }

    public final void remove(T item) {
        this.items.removeIf(arg_0 -> Inventory.remove$lambda$1(new Function1<ItemStack<T>, Boolean>(item){
            final /* synthetic */ T $item;
            {
                this.$item = $item;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ItemStack<T> it) {
                return Intrinsics.areEqual(it.getUserItem(), this.$item);
            }
        }, arg_0));
        ((Map)this.itemsData).remove(item);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean incrementQuantity(T item, int amount) {
        if (amount == 0) {
            return false;
        }
        if (!this.hasItem(item)) {
            this.log.warning("Attempted to increment qty of item that is not in inventory. Ignoring");
            return false;
        }
        ItemData<T> itemData = this.itemsData.get(item);
        Intrinsics.checkNotNull(itemData);
        ItemData<T> data = itemData;
        if (amount > 0 && data.getMaxStackQuantity() < Integer.MAX_VALUE) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            int n = this.getNumFreeStacks() * data.getMaxStackQuantity();
            ObservableList<ItemStack<T>> observableList = this.items;
            Intrinsics.checkNotNullExpressionValue(observableList, "items");
            Iterable iterable = observableList;
            int n2 = n;
            boolean $i$f$filter = false;
            void var7_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemStack it = (ItemStack)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getUserItem(), item)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            int maxPossibleQuantityForItem = n2 + list.size();
            if (amount + data.getQuantity() > maxPossibleQuantityForItem) {
                return false;
            }
        }
        if (amount < 0 && -amount > data.getQuantity()) {
            return false;
        }
        data.incrementQuantity$fxgl_gameplay(amount);
        this.items.removeIf(arg_0 -> Inventory.incrementQuantity$lambda$3(new Function1<ItemStack<T>, Boolean>(item, data){
            final /* synthetic */ T $item;
            final /* synthetic */ ItemData<T> $data;
            {
                this.$item = $item;
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ItemStack<T> it) {
                return Intrinsics.areEqual(it.getUserItem(), this.$item) && !this.$data.getStacks().contains(it);
            }
        }, arg_0));
        ObservableList<ItemStack<T>> observableList = data.getStacks();
        Intrinsics.checkNotNullExpressionValue(observableList, "data.stacks");
        Iterable $this$forEach$iv = observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            if (this.items.contains(it)) continue;
            ObservableList<ItemStack<T>> observableList2 = this.items;
            Intrinsics.checkNotNullExpressionValue(observableList2, "items");
            ((Collection)observableList2).add(it);
        }
        if (data.getQuantity() == 0) {
            ((Map)this.itemsData).remove(item);
        }
        return true;
    }

    public final boolean transferAllFrom(@NotNull Inventory<T> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        boolean isPartiallySuccess = false;
        ObservableList<ItemStack<T>> observableList = other.items;
        Intrinsics.checkNotNullExpressionValue(observableList, "other.items");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)observableList);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            if (!this.transferFrom(other, it.getUserItem(), it.getQuantity())) continue;
            isPartiallySuccess = true;
        }
        return isPartiallySuccess;
    }

    @JvmOverloads
    public final boolean transferFrom(@NotNull Inventory<T> other, T item, int quantity) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!other.hasItem(item)) {
            return false;
        }
        if (other.getItemQuantity(item) < quantity) {
            return false;
        }
        boolean isOK = Inventory.add$default(this, item, null, quantity, 2, null);
        if (isOK) {
            return other.incrementQuantity(item, -quantity);
        }
        return false;
    }

    public static /* synthetic */ boolean transferFrom$default(Inventory inventory, Inventory inventory2, Object object, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return inventory.transferFrom(inventory2, object, n);
    }

    @JvmOverloads
    public final boolean add(T item, @NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        return Inventory.add$default(this, item, config, 0, 4, null);
    }

    @JvmOverloads
    public final boolean add(T item) {
        return Inventory.add$default(this, item, null, 0, 6, null);
    }

    @JvmOverloads
    public final boolean transferFrom(@NotNull Inventory<T> other, T item) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Inventory.transferFrom$default(this, other, item, 0, 4, null);
    }

    private static final boolean remove$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean incrementQuantity$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

