/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input;

import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.logging.Logger;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/almasb/fxgl/input/MouseTrigger;", "Lcom/almasb/fxgl/input/Trigger;", "button", "Ljavafx/scene/input/MouseButton;", "modifier", "Lcom/almasb/fxgl/input/InputModifier;", "(Ljavafx/scene/input/MouseButton;Lcom/almasb/fxgl/input/InputModifier;)V", "getButton", "()Ljavafx/scene/input/MouseButton;", "isButton", "", "()Z", "isKey", "getModifier", "()Lcom/almasb/fxgl/input/InputModifier;", "name", "", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "isReleased", "event", "Ljavafx/scene/input/InputEvent;", "isTriggered", "toString", "Companion", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nTriggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Triggers.kt\ncom/almasb/fxgl/input/MouseTrigger\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n*L\n1#1,169:1\n157#2:170\n*S KotlinDebug\n*F\n+ 1 Triggers.kt\ncom/almasb/fxgl/input/MouseTrigger\n*L\n116#1:170\n*E\n"})
public final class MouseTrigger
implements Trigger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MouseButton button;
    @NotNull
    private final InputModifier modifier;
    @NotNull
    private final String name;
    private final boolean isKey;
    private final boolean isButton;
    @NotNull
    private static final Logger log;

    @JvmOverloads
    public MouseTrigger(@NotNull MouseButton button, @NotNull InputModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)button, "button");
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        this.button = button;
        this.modifier = modifier;
        this.name = Companion.buttonToString(this.button);
        this.isButton = true;
    }

    public /* synthetic */ MouseTrigger(MouseButton mouseButton, InputModifier inputModifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        this(mouseButton, inputModifier);
    }

    @NotNull
    public final MouseButton getButton() {
        return this.button;
    }

    @Override
    @NotNull
    public InputModifier getModifier() {
        return this.modifier;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public boolean isButton() {
        return this.isButton;
    }

    @Override
    public boolean isTriggered(@NotNull InputEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        return ((MouseEvent)event).getButton() == this.button && this.getModifier().isTriggered((MouseEvent)event);
    }

    @Override
    public boolean isReleased(@NotNull InputEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof KeyEvent) {
            KeyCode keyCode = ((KeyEvent)event).getCode();
            return switch (keyCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                case 1 -> {
                    if (this.getModifier() == InputModifier.CTRL) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (this.getModifier() == InputModifier.SHIFT) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (this.getModifier() == InputModifier.ALT) {
                        yield true;
                    }
                    yield false;
                }
                default -> this.isTriggered(event);
            };
        }
        return this.isTriggered(event);
    }

    @NotNull
    public String toString() {
        return (String)(this.getModifier() == InputModifier.NONE ? "" : this.getModifier() + "+") + this.getName();
    }

    @NotNull
    public final MouseButton component1() {
        return this.button;
    }

    @NotNull
    public final InputModifier component2() {
        return this.getModifier();
    }

    @NotNull
    public final MouseTrigger copy(@NotNull MouseButton button, @NotNull InputModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)button, "button");
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        return new MouseTrigger(button, modifier);
    }

    public static /* synthetic */ MouseTrigger copy$default(MouseTrigger mouseTrigger, MouseButton mouseButton, InputModifier inputModifier, int n, Object object) {
        if ((n & 1) != 0) {
            mouseButton = mouseTrigger.button;
        }
        if ((n & 2) != 0) {
            inputModifier = mouseTrigger.getModifier();
        }
        return mouseTrigger.copy(mouseButton, inputModifier);
    }

    public int hashCode() {
        int result = this.button.hashCode();
        result = result * 31 + this.getModifier().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MouseTrigger)) {
            return false;
        }
        MouseTrigger mouseTrigger = (MouseTrigger)other;
        if (this.button != mouseTrigger.button) {
            return false;
        }
        return this.getModifier() == mouseTrigger.getModifier();
    }

    @JvmOverloads
    public MouseTrigger(@NotNull MouseButton button) {
        Intrinsics.checkNotNullParameter((Object)button, "button");
        this(button, null, 2, null);
    }

    static {
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        log = this_$iv.get(MouseTrigger.class);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/input/MouseTrigger$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "buttonFromString", "Ljavafx/scene/input/MouseButton;", "value", "", "buttonToString", "button", "fxgl-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MouseButton buttonFromString(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return switch (value) {
                case "LMB" -> MouseButton.PRIMARY;
                case "MMB" -> MouseButton.MIDDLE;
                case "RMB" -> MouseButton.SECONDARY;
                case "BMB" -> MouseButton.BACK;
                case "FMB" -> MouseButton.FORWARD;
                default -> {
                    log.warning("Unknown button String form: " + value);
                    yield MouseButton.NONE;
                }
            };
        }

        @NotNull
        public final String buttonToString(@NotNull MouseButton button) {
            Intrinsics.checkNotNullParameter((Object)button, "button");
            return switch (WhenMappings.$EnumSwitchMapping$0[button.ordinal()]) {
                case 1 -> "LMB";
                case 2 -> "MMB";
                case 3 -> "RMB";
                case 4 -> "BMB";
                case 5 -> "FMB";
                default -> {
                    log.warning("Unknown button: " + button);
                    yield "NMB";
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MouseButton.values().length];
                try {
                    nArray[MouseButton.PRIMARY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MouseButton.MIDDLE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MouseButton.SECONDARY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MouseButton.BACK.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MouseButton.FORWARD.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyCode.values().length];
            try {
                nArray[KeyCode.CONTROL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.SHIFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.ALT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

