/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input;

import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/almasb/fxgl/input/KeyTrigger;", "Lcom/almasb/fxgl/input/Trigger;", "key", "Ljavafx/scene/input/KeyCode;", "modifier", "Lcom/almasb/fxgl/input/InputModifier;", "(Ljavafx/scene/input/KeyCode;Lcom/almasb/fxgl/input/InputModifier;)V", "isButton", "", "()Z", "isKey", "getKey", "()Ljavafx/scene/input/KeyCode;", "getModifier", "()Lcom/almasb/fxgl/input/InputModifier;", "name", "", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "isReleased", "event", "Ljavafx/scene/input/InputEvent;", "isTriggered", "toString", "fxgl-core"})
public final class KeyTrigger
implements Trigger {
    @NotNull
    private final KeyCode key;
    @NotNull
    private final InputModifier modifier;
    @NotNull
    private final String name;
    private final boolean isKey;
    private final boolean isButton;

    @JvmOverloads
    public KeyTrigger(@NotNull KeyCode key, @NotNull InputModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)key, "key");
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        this.key = key;
        this.modifier = modifier;
        String string = this.key.getName();
        Intrinsics.checkNotNullExpressionValue(string, "key.getName()");
        this.name = string;
        this.isKey = true;
    }

    public /* synthetic */ KeyTrigger(KeyCode keyCode, InputModifier inputModifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        this(keyCode, inputModifier);
    }

    @NotNull
    public final KeyCode getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public InputModifier getModifier() {
        return this.modifier;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public boolean isButton() {
        return this.isButton;
    }

    @Override
    public boolean isTriggered(@NotNull InputEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event instanceof KeyEvent)) {
            return false;
        }
        return ((KeyEvent)event).getCode() == this.key && this.getModifier().isTriggered((KeyEvent)event);
    }

    @Override
    public boolean isReleased(@NotNull InputEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event instanceof KeyEvent)) {
            return false;
        }
        KeyCode keyCode = ((KeyEvent)event).getCode();
        return switch (keyCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
            case 1 -> {
                if (this.getModifier() == InputModifier.CTRL) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.getModifier() == InputModifier.SHIFT) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.getModifier() == InputModifier.ALT) {
                    yield true;
                }
                yield false;
            }
            default -> ((KeyEvent)event).getCode() == this.key;
        };
    }

    @NotNull
    public String toString() {
        return (String)(this.getModifier() == InputModifier.NONE ? "" : this.getModifier() + "+") + this.key.getName();
    }

    @NotNull
    public final KeyCode component1() {
        return this.key;
    }

    @NotNull
    public final InputModifier component2() {
        return this.getModifier();
    }

    @NotNull
    public final KeyTrigger copy(@NotNull KeyCode key, @NotNull InputModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)key, "key");
        Intrinsics.checkNotNullParameter((Object)modifier, "modifier");
        return new KeyTrigger(key, modifier);
    }

    public static /* synthetic */ KeyTrigger copy$default(KeyTrigger keyTrigger, KeyCode keyCode, InputModifier inputModifier, int n, Object object) {
        if ((n & 1) != 0) {
            keyCode = keyTrigger.key;
        }
        if ((n & 2) != 0) {
            inputModifier = keyTrigger.getModifier();
        }
        return keyTrigger.copy(keyCode, inputModifier);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = result * 31 + this.getModifier().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyTrigger)) {
            return false;
        }
        KeyTrigger keyTrigger = (KeyTrigger)other;
        if (this.key != keyTrigger.key) {
            return false;
        }
        return this.getModifier() == keyTrigger.getModifier();
    }

    @JvmOverloads
    public KeyTrigger(@NotNull KeyCode key) {
        Intrinsics.checkNotNullParameter((Object)key, "key");
        this(key, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyCode.values().length];
            try {
                nArray[KeyCode.CONTROL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.SHIFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyCode.ALT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

