/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.event;

import com.almasb.fxgl.event.Subscriber;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Group;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0010\u001a\u00020\u000e\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00110\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0018J.\u0010\u001b\u001a\u00020\u0018\"\b\b\u0000\u0010\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00110\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/event/EventBus;", "", "()V", "eventHandlers", "Ljavafx/scene/Group;", "isLoggingEnabled", "", "()Z", "setLoggingEnabled", "(Z)V", "log", "Lcom/almasb/fxgl/logging/Logger;", "subscribers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/event/Subscriber;", "Lkotlin/collections/ArrayList;", "addEventHandler", "T", "Ljavafx/event/Event;", "eventType", "Ljavafx/event/EventType;", "eventHandler", "Ljavafx/event/EventHandler;", "fireEvent", "", "event", "removeAllEventHandlers", "removeEventHandler", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\ncom/almasb/fxgl/event/EventBus\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1#2:69\n1855#3,2:70\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\ncom/almasb/fxgl/event/EventBus\n*L\n51#1:70,2\n*E\n"})
public final class EventBus {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    @NotNull
    private final Group eventHandlers = new Group();
    @NotNull
    private final ArrayList<Subscriber> subscribers = new ArrayList();
    private boolean isLoggingEnabled = true;

    public final boolean isLoggingEnabled() {
        return this.isLoggingEnabled;
    }

    public final void setLoggingEnabled(boolean bl) {
        this.isLoggingEnabled = bl;
    }

    @NotNull
    public final <T extends Event> Subscriber addEventHandler(@NotNull EventType<T> eventType, @NotNull EventHandler<? super T> eventHandler) {
        Subscriber subscriber;
        Intrinsics.checkNotNullParameter(eventType, "eventType");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.eventHandlers.addEventHandler(eventType, eventHandler);
        Subscriber it = subscriber = new Subscriber(this, eventType, eventHandler);
        boolean bl = false;
        this.subscribers.add(it);
        return subscriber;
    }

    public final <T extends Event> void removeEventHandler(@NotNull EventType<T> eventType, @NotNull EventHandler<? super T> eventHandler) {
        Intrinsics.checkNotNullParameter(eventType, "eventType");
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        this.eventHandlers.removeEventHandler(eventType, eventHandler);
    }

    public final void removeAllEventHandlers() {
        Iterable $this$forEach$iv = this.subscribers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Subscriber it = (Subscriber)element$iv;
            boolean bl = false;
            it.unsubscribe();
        }
        this.subscribers.clear();
    }

    public final void fireEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.isLoggingEnabled) {
            this.log.debug("Firing event: " + event);
        }
        this.eventHandlers.fireEvent(event);
    }
}

