/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.components;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.SerializableComponent;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CoreComponent
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010`\u001a\u00020(J\u000e\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u0000J\u000e\u0010d\u001a\u00020b2\u0006\u0010c\u001a\u00020\u0000J\u000e\u0010e\u001a\u00020\b2\u0006\u0010c\u001a\u00020\u0000J\u000e\u0010f\u001a\u00020\b2\u0006\u0010c\u001a\u00020\u0000J\b\u0010g\u001a\u00020hH\u0016J\u000e\u0010i\u001a\u00020b2\u0006\u0010j\u001a\u00020\u0019J\u000e\u0010k\u001a\u00020b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010l\u001a\u00020b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010m\u001a\u00020b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010n\u001a\u00020b2\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010o\u001a\u00020b2\u0006\u0010e\u001a\u00020\bJ\u000e\u0010p\u001a\u00020b2\u0006\u0010e\u001a\u00020\bJ\u000e\u0010q\u001a\u00020b2\u0006\u0010e\u001a\u00020\bJ\u000e\u0010r\u001a\u00020b2\u0006\u0010e\u001a\u00020\bJ\u000e\u0010s\u001a\u00020b2\u0006\u0010e\u001a\u00020\bJ\u000e\u0010t\u001a\u00020b2\u0006\u0010e\u001a\u00020\bJ\u0010\u0010u\u001a\u00020b2\u0006\u0010v\u001a\u00020\bH\u0016J\u0006\u0010w\u001a\u00020(J\u0006\u0010x\u001a\u00020(J\u0006\u0010y\u001a\u00020(J\u0010\u0010z\u001a\u00020b2\u0006\u0010{\u001a\u00020|H\u0016J\u000e\u0010}\u001a\u00020b2\u0006\u0010~\u001a\u00020\bJ\u000f\u0010\u007f\u001a\u00020b2\u0007\u0010\u0080\u0001\u001a\u00020\u0004J\u0007\u0010\u0081\u0001\u001a\u00020(J\u0007\u0010\u0082\u0001\u001a\u00020(J\u0007\u0010\u0083\u0001\u001a\u00020(J\u0007\u0010\u0084\u0001\u001a\u00020(J\u0007\u0010\u0085\u0001\u001a\u00020(J\u0007\u0010\u0086\u0001\u001a\u00020(J\u0007\u0010\u0087\u0001\u001a\u00020(J\u0007\u0010\u0088\u0001\u001a\u00020(J\u0007\u0010\u0089\u0001\u001a\u00020(J\u0007\u0010\u008a\u0001\u001a\u000205J\u0007\u0010\u008b\u0001\u001a\u000205J\u0007\u0010\u008c\u0001\u001a\u000205J\u0010\u0010\u008d\u0001\u001a\u00020b2\u0007\u0010\u008e\u0001\u001a\u00020\u0019J\u0016\u0010\"\u001a\u00020b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010%\u001a\u00020b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010]\u001a\u00020\bJ\n\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0016J\u0010\u0010\u0091\u0001\u001a\u00020b2\u0007\u0010\u0080\u0001\u001a\u00020\u0004J\u0017\u0010\u0091\u0001\u001a\u00020b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\u0092\u0001\u001a\u00020b2\u0007\u0010\u0080\u0001\u001a\u00020\u0019J\u001f\u0010\u0092\u0001\u001a\u00020b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010]\u001a\u00020\bJ\u0017\u0010\u0093\u0001\u001a\u00020b2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010e\u001a\u00020\bJ\u000f\u0010\u0094\u0001\u001a\u00020b2\u0006\u0010\u0007\u001a\u00020\bJ\u000f\u0010\u0095\u0001\u001a\u00020b2\u0006\u0010\t\u001a\u00020\bJ\u000f\u0010\u0096\u0001\u001a\u00020b2\u0006\u0010]\u001a\u00020\bJ\u0007\u0010\u0097\u0001\u001a\u00020bJ\t\u0010\u0098\u0001\u001a\u00020bH\u0002J\u0011\u0010\u0099\u0001\u001a\u00020b2\u0006\u0010{\u001a\u00020|H\u0016J\u0007\u0010\u009a\u0001\u001a\u000205J\u0007\u0010\u009b\u0001\u001a\u000205J\u0007\u0010\u009c\u0001\u001a\u000205R$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0005R$\u0010\n\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0005R$\u0010 \u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0005R$\u0010#\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010;\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010\u0011\"\u0004\b=\u0010\u0005R$\u0010>\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\u001c\"\u0004\b@\u0010&R$\u0010A\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010\u0014\"\u0004\bC\u0010\u0016R$\u0010D\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010\u0014\"\u0004\bF\u0010\u0016R$\u0010G\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010\u0014\"\u0004\bI\u0010\u0016R$\u0010J\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010\u0011\"\u0004\bL\u0010\u0005R$\u0010M\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010\u001c\"\u0004\bO\u0010&R$\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010\u0014\"\u0004\bQ\u0010\u0016R$\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010\u0014\"\u0004\bS\u0010\u0016R$\u0010T\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010\u0014\"\u0004\bV\u0010\u0016R\u001e\u0010W\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u001cR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010\u0014\"\u0004\bZ\u0010\u0016R$\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010\u0014\"\u0004\b\\\u0010\u0016R$\u0010]\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010\u0014\"\u0004\b_\u0010\u0016\u00a8\u0006\u009d\u0001"}, d2={"Lcom/almasb/fxgl/entity/components/TransformComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "Lcom/almasb/fxgl/entity/component/SerializableComponent;", "p", "Ljavafx/geometry/Point2D;", "(Ljavafx/geometry/Point2D;)V", "()V", "x", "", "y", "angle", "scaleX", "scaleY", "(DDDDD)V", "value", "anchoredPosition", "getAnchoredPosition", "()Ljavafx/geometry/Point2D;", "setAnchoredPosition", "getAngle", "()D", "setAngle", "(D)V", "boundLookAt", "<set-?>", "Ljavafx/geometry/Point3D;", "direction3D", "getDirection3D", "()Ljavafx/geometry/Point3D;", "localAnchor", "getLocalAnchor", "setLocalAnchor", "position", "getPosition", "setPosition", "position3D", "getPosition3D", "setPosition3D", "(Ljavafx/geometry/Point3D;)V", "propPositionOriginX", "Ljavafx/beans/property/SimpleDoubleProperty;", "propPositionOriginY", "propPositionOriginZ", "propRotationOriginX", "propRotationOriginY", "propRotationOriginZ", "propRotationX", "propRotationY", "propRotationZ", "propScaleOriginX", "propScaleOriginY", "propScaleOriginZ", "propScaleX", "Ljavafx/beans/property/DoubleProperty;", "propScaleY", "propScaleZ", "propX", "propY", "propZ", "rotationOrigin", "getRotationOrigin", "setRotationOrigin", "rotationOrigin3D", "getRotationOrigin3D", "setRotationOrigin3D", "rotationX", "getRotationX", "setRotationX", "rotationY", "getRotationY", "setRotationY", "rotationZ", "getRotationZ", "setRotationZ", "scaleOrigin", "getScaleOrigin", "setScaleOrigin", "scaleOrigin3D", "getScaleOrigin3D", "setScaleOrigin3D", "getScaleX", "setScaleX", "getScaleY", "setScaleY", "scaleZ", "getScaleZ", "setScaleZ", "up3D", "getUp3D", "getX", "setX", "getY", "setY", "z", "getZ", "setZ", "angleProperty", "bindToLookAt3D", "", "other", "bindTranslation", "distance", "distance3D", "isComponentInjectionRequired", "", "lookAt", "point", "lookDownBy", "lookLeftBy", "lookRightBy", "lookUpBy", "moveBack", "moveBackXZ", "moveForward", "moveForwardXZ", "moveLeft", "moveRight", "onUpdate", "tpf", "positionOriginXProperty", "positionOriginYProperty", "positionOriginZProperty", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "rotateBy", "byAngle", "rotateToVector", "vector", "rotationOriginXProperty", "rotationOriginYProperty", "rotationOriginZProperty", "rotationXProperty", "rotationYProperty", "rotationZProperty", "scaleOriginXProperty", "scaleOriginYProperty", "scaleOriginZProperty", "scaleXProperty", "scaleYProperty", "scaleZProperty", "setDirectionVector3D", "directionToLook", "toString", "", "translate", "translate3D", "translateTowards", "translateX", "translateY", "translateZ", "unbindToLookAt3D", "updateDirection", "write", "xProperty", "yProperty", "zProperty", "fxgl-entity"})
public final class TransformComponent
extends Component
implements SerializableComponent {
    @NotNull
    private final DoubleProperty propX;
    @NotNull
    private final DoubleProperty propY;
    @NotNull
    private final DoubleProperty propZ;
    @NotNull
    private final DoubleProperty propScaleX;
    @NotNull
    private final DoubleProperty propScaleY;
    @NotNull
    private final DoubleProperty propScaleZ;
    @NotNull
    private final SimpleDoubleProperty propPositionOriginX;
    @NotNull
    private final SimpleDoubleProperty propPositionOriginY;
    @NotNull
    private final SimpleDoubleProperty propPositionOriginZ;
    @NotNull
    private final SimpleDoubleProperty propScaleOriginX;
    @NotNull
    private final SimpleDoubleProperty propScaleOriginY;
    @NotNull
    private final SimpleDoubleProperty propScaleOriginZ;
    @NotNull
    private final SimpleDoubleProperty propRotationOriginX;
    @NotNull
    private final SimpleDoubleProperty propRotationOriginY;
    @NotNull
    private final SimpleDoubleProperty propRotationOriginZ;
    @NotNull
    private final SimpleDoubleProperty propRotationX;
    @NotNull
    private final SimpleDoubleProperty propRotationY;
    @NotNull
    private final SimpleDoubleProperty propRotationZ;
    @NotNull
    private Point2D localAnchor;
    @NotNull
    private Point3D direction3D;
    @NotNull
    private Point3D up3D;
    @Nullable
    private TransformComponent boundLookAt;

    public TransformComponent(double x, double y, double angle, double scaleX, double scaleY) {
        this.propX = new SimpleDoubleProperty(x);
        this.propY = new SimpleDoubleProperty(y);
        this.propZ = new SimpleDoubleProperty(0.0);
        this.propScaleX = new SimpleDoubleProperty(scaleX);
        this.propScaleY = new SimpleDoubleProperty(scaleY);
        this.propScaleZ = new SimpleDoubleProperty(1.0);
        this.propPositionOriginX = new SimpleDoubleProperty(0.0);
        this.propPositionOriginY = new SimpleDoubleProperty(0.0);
        this.propPositionOriginZ = new SimpleDoubleProperty(0.0);
        this.propScaleOriginX = new SimpleDoubleProperty(0.0);
        this.propScaleOriginY = new SimpleDoubleProperty(0.0);
        this.propScaleOriginZ = new SimpleDoubleProperty(0.0);
        this.propRotationOriginX = new SimpleDoubleProperty(0.0);
        this.propRotationOriginY = new SimpleDoubleProperty(0.0);
        this.propRotationOriginZ = new SimpleDoubleProperty(0.0);
        this.propRotationX = new SimpleDoubleProperty(0.0);
        this.propRotationY = new SimpleDoubleProperty(0.0);
        this.propRotationZ = new SimpleDoubleProperty(angle);
        this.propRotationX.addListener((ChangeListener<? super Number>)((ChangeListener<Object>)(arg_0, arg_1, arg_2) -> TransformComponent._init_$lambda$0(new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(){

            @Override
            public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                this.updateDirection();
            }
        }, arg_0, arg_1, arg_2)));
        this.propRotationY.addListener((ChangeListener<? super Number>)((ChangeListener<Object>)(arg_0, arg_1, arg_2) -> TransformComponent._init_$lambda$1(new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(){

            @Override
            public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                this.updateDirection();
            }
        }, arg_0, arg_1, arg_2)));
        Point2D point2D = Point2D.ZERO;
        Intrinsics.checkNotNullExpressionValue(point2D, "ZERO");
        this.localAnchor = point2D;
        this.direction3D = new Point3D(0.0, 0.0, 1.0);
        this.up3D = new Point3D(0.0, -1.0, 0.0);
    }

    public TransformComponent(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter(p, "p");
        this(p.getX(), p.getY(), 0.0, 1.0, 1.0);
    }

    public TransformComponent() {
        this(0.0, 0.0, 0.0, 1.0, 1.0);
    }

    public final double getX() {
        Double d = this.propX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propX.value");
        return ((Number)d).doubleValue();
    }

    public final void setX(double value) {
        this.propX.setValue(value);
    }

    public final double getY() {
        Double d = this.propY.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propY.value");
        return ((Number)d).doubleValue();
    }

    public final void setY(double value) {
        this.propY.setValue(value);
    }

    public final double getZ() {
        Double d = this.propZ.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setZ(double value) {
        this.propZ.setValue(value);
    }

    public final double getAngle() {
        Double d = this.propRotationZ.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propRotationZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setAngle(double value) {
        this.propRotationZ.setValue(value);
    }

    public final double getScaleX() {
        Double d = this.propScaleX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propScaleX.value");
        return ((Number)d).doubleValue();
    }

    public final void setScaleX(double value) {
        this.propScaleX.setValue(value);
    }

    public final double getScaleY() {
        Double d = this.propScaleY.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propScaleY.value");
        return ((Number)d).doubleValue();
    }

    public final void setScaleY(double value) {
        this.propScaleY.setValue(value);
    }

    public final double getScaleZ() {
        Double d = this.propScaleZ.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propScaleZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setScaleZ(double value) {
        this.propScaleZ.setValue(value);
    }

    @NotNull
    public final Point2D getPosition() {
        return new Point2D(this.getX(), this.getY());
    }

    public final void setPosition(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.setPosition(value.getX(), value.getY());
    }

    @NotNull
    public final Point3D getPosition3D() {
        return new Point3D(this.getX(), this.getY(), this.getZ());
    }

    public final void setPosition3D(@NotNull Point3D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.setPosition3D(value.getX(), value.getY(), value.getZ());
    }

    public final double getRotationX() {
        Double d = this.propRotationX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propRotationX.value");
        return ((Number)d).doubleValue();
    }

    public final void setRotationX(double value) {
        this.propRotationX.setValue(value);
    }

    public final double getRotationY() {
        Double d = this.propRotationY.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propRotationY.value");
        return ((Number)d).doubleValue();
    }

    public final void setRotationY(double value) {
        this.propRotationY.setValue(value);
    }

    public final double getRotationZ() {
        Double d = this.propRotationZ.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propRotationZ.value");
        return ((Number)d).doubleValue();
    }

    public final void setRotationZ(double value) {
        this.propRotationZ.setValue(value);
    }

    @NotNull
    public final Point2D getScaleOrigin() {
        Double d = this.propScaleOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propScaleOriginX.value");
        double d2 = ((Number)d).doubleValue();
        Double d3 = this.propScaleOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue(d3, "propScaleOriginY.value");
        return new Point2D(d2, ((Number)d3).doubleValue());
    }

    public final void setScaleOrigin(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.propScaleOriginX.setValue(value.getX());
        this.propScaleOriginY.setValue(value.getY());
    }

    @NotNull
    public final Point3D getScaleOrigin3D() {
        Double d = this.propScaleOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propScaleOriginX.value");
        double d2 = ((Number)d).doubleValue();
        Double d3 = this.propScaleOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue(d3, "propScaleOriginY.value");
        double d4 = ((Number)d3).doubleValue();
        Double d5 = this.propScaleOriginZ.getValue();
        Intrinsics.checkNotNullExpressionValue(d5, "propScaleOriginZ.value");
        return new Point3D(d2, d4, ((Number)d5).doubleValue());
    }

    public final void setScaleOrigin3D(@NotNull Point3D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.propScaleOriginX.setValue(value.getX());
        this.propScaleOriginY.setValue(value.getY());
        this.propScaleOriginZ.setValue(value.getZ());
    }

    @NotNull
    public final Point2D getRotationOrigin() {
        Double d = this.propRotationOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propRotationOriginX.value");
        double d2 = ((Number)d).doubleValue();
        Double d3 = this.propRotationOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue(d3, "propRotationOriginY.value");
        return new Point2D(d2, ((Number)d3).doubleValue());
    }

    public final void setRotationOrigin(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.propRotationOriginX.setValue(value.getX());
        this.propRotationOriginY.setValue(value.getY());
    }

    @NotNull
    public final Point3D getRotationOrigin3D() {
        Double d = this.propRotationOriginX.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "propRotationOriginX.value");
        double d2 = ((Number)d).doubleValue();
        Double d3 = this.propRotationOriginY.getValue();
        Intrinsics.checkNotNullExpressionValue(d3, "propRotationOriginY.value");
        double d4 = ((Number)d3).doubleValue();
        Double d5 = this.propRotationOriginZ.getValue();
        Intrinsics.checkNotNullExpressionValue(d5, "propRotationOriginZ.value");
        return new Point3D(d2, d4, ((Number)d5).doubleValue());
    }

    public final void setRotationOrigin3D(@NotNull Point3D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.propRotationOriginX.setValue(value.getX());
        this.propRotationOriginY.setValue(value.getY());
        this.propRotationOriginZ.setValue(value.getZ());
    }

    @NotNull
    public final DoubleProperty xProperty() {
        return this.propX;
    }

    @NotNull
    public final DoubleProperty yProperty() {
        return this.propY;
    }

    @NotNull
    public final DoubleProperty zProperty() {
        return this.propZ;
    }

    @NotNull
    public final DoubleProperty scaleXProperty() {
        return this.propScaleX;
    }

    @NotNull
    public final DoubleProperty scaleYProperty() {
        return this.propScaleY;
    }

    @NotNull
    public final DoubleProperty scaleZProperty() {
        return this.propScaleZ;
    }

    @NotNull
    public final SimpleDoubleProperty angleProperty() {
        return this.propRotationZ;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginXProperty() {
        return this.propPositionOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginYProperty() {
        return this.propPositionOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty positionOriginZProperty() {
        return this.propPositionOriginZ;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginXProperty() {
        return this.propScaleOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginYProperty() {
        return this.propScaleOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty scaleOriginZProperty() {
        return this.propScaleOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginXProperty() {
        return this.propRotationOriginX;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginYProperty() {
        return this.propRotationOriginY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationOriginZProperty() {
        return this.propRotationOriginZ;
    }

    @NotNull
    public final SimpleDoubleProperty rotationXProperty() {
        return this.propRotationX;
    }

    @NotNull
    public final SimpleDoubleProperty rotationYProperty() {
        return this.propRotationY;
    }

    @NotNull
    public final SimpleDoubleProperty rotationZProperty() {
        return this.propRotationZ;
    }

    public final void setPosition(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public final void setPosition3D(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public final void translateX(double x) {
        this.setX(this.getX() + x);
    }

    public final void translateY(double y) {
        this.setY(this.getY() + y);
    }

    public final void translateZ(double z) {
        this.setZ(this.getZ() + z);
    }

    public final void translate(double x, double y) {
        this.translateX(x);
        this.translateY(y);
    }

    public final void translate3D(double x, double y, double z) {
        this.translateX(x);
        this.translateY(y);
        this.translateZ(z);
    }

    public final void translate(@NotNull Point2D vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        this.translate(vector.getX(), vector.getY());
    }

    public final void translate3D(@NotNull Point3D vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        this.translate3D(vector.getX(), vector.getY(), vector.getZ());
    }

    public final void translateTowards(@NotNull Point2D position, double distance) {
        Intrinsics.checkNotNullParameter(position, "position");
        Point2D point2D = position.subtract(this.getX(), this.getY()).normalize().multiply(distance);
        Intrinsics.checkNotNullExpressionValue(point2D, "position.subtract(x, y).\u2026lize().multiply(distance)");
        this.translate(point2D);
    }

    public final double distance(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.getPosition().distance(other.getPosition());
    }

    public final double distance3D(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.getPosition3D().distance(other.getPosition3D());
    }

    public final void rotateBy(double byAngle) {
        SimpleDoubleProperty simpleDoubleProperty = this.propRotationZ;
        simpleDoubleProperty.setValue(simpleDoubleProperty.getValue() + byAngle);
    }

    public final void rotateToVector(@NotNull Point2D vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        this.propRotationZ.setValue(Math.toDegrees(Math.atan2(vector.getY(), vector.getX())));
    }

    @NotNull
    public final Point2D getLocalAnchor() {
        return this.localAnchor;
    }

    public final void setLocalAnchor(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter(point2D, "<set-?>");
        this.localAnchor = point2D;
    }

    @NotNull
    public final Point2D getAnchoredPosition() {
        return new Point2D(this.getX() + this.localAnchor.getX(), this.getY() + this.localAnchor.getY());
    }

    public final void setAnchoredPosition(@NotNull Point2D value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.setPosition(value.getX() - this.localAnchor.getX(), value.getY() - this.localAnchor.getY());
    }

    @NotNull
    public final Point3D getDirection3D() {
        return this.direction3D;
    }

    @NotNull
    public final Point3D getUp3D() {
        return this.up3D;
    }

    public final void lookUpBy(double angle) {
        this.setRotationX(this.getRotationX() + angle);
    }

    public final void lookDownBy(double angle) {
        this.setRotationX(this.getRotationX() - angle);
    }

    public final void lookLeftBy(double angle) {
        this.setRotationY(this.getRotationY() - angle);
    }

    public final void lookRightBy(double angle) {
        this.setRotationY(this.getRotationY() + angle);
    }

    public final void lookAt(@NotNull Point3D point) {
        Intrinsics.checkNotNullParameter(point, "point");
        Point3D directionToLook = point.subtract(this.getX(), this.getY(), this.getZ());
        Intrinsics.checkNotNullExpressionValue(directionToLook, "directionToLook");
        this.setDirectionVector3D(directionToLook);
    }

    public final void setDirectionVector3D(@NotNull Point3D directionToLook) {
        Intrinsics.checkNotNullParameter(directionToLook, "directionToLook");
        this.setRotationY((double)90 - Math.toDegrees(Math.atan2(directionToLook.getZ(), directionToLook.getX())));
        double theta = Math.toDegrees(Math.asin(Math.abs(directionToLook.getY()) / directionToLook.magnitude()));
        if (directionToLook.getY() > 0.0) {
            this.setRotationX(-theta);
        } else {
            this.setRotationX(theta);
        }
    }

    public final void bindToLookAt3D(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.boundLookAt = other;
    }

    public final void unbindToLookAt3D() {
        this.boundLookAt = null;
    }

    @Override
    public void onUpdate(double tpf) {
        block0: {
            TransformComponent transformComponent = this.boundLookAt;
            if (transformComponent == null) break block0;
            TransformComponent it = transformComponent;
            boolean bl = false;
            this.lookAt(it.getPosition3D());
        }
    }

    public final void moveForwardXZ(double distance) {
        Point3D vector = this.direction3D.multiply(distance);
        this.translate3D(vector.getX(), 0.0, vector.getZ());
    }

    public final void moveBackXZ(double distance) {
        Point3D vector = this.direction3D.multiply(distance);
        this.translate3D(-vector.getX(), 0.0, -vector.getZ());
    }

    public final void moveForward(double distance) {
        Point3D vector = this.direction3D.multiply(distance);
        Intrinsics.checkNotNullExpressionValue(vector, "vector");
        this.translate3D(vector);
    }

    public final void moveBack(double distance) {
        Point3D vector = this.direction3D.multiply(-distance);
        Intrinsics.checkNotNullExpressionValue(vector, "vector");
        this.translate3D(vector);
    }

    public final void moveLeft(double distance) {
        Point3D left = this.up3D.crossProduct(this.direction3D).normalize().multiply(distance);
        this.translateX(left.getX());
        this.translateZ(left.getZ());
    }

    public final void moveRight(double distance) {
        Point3D right = this.direction3D.crossProduct(this.up3D).normalize().multiply(distance);
        this.translateX(right.getX());
        this.translateZ(right.getZ());
    }

    private final void updateDirection() {
        double adjustedRotationY = (double)90 - this.getRotationY();
        Point3D point3D = new Point3D(FXGLMath.cosDeg(adjustedRotationY), 0.0, FXGLMath.sinDeg(adjustedRotationY)).normalize();
        Intrinsics.checkNotNullExpressionValue(point3D, "Point3D(cosDeg(adjustedR\u2026edRotationY)).normalize()");
        this.direction3D = point3D;
        Point3D point3D2 = new Point3D(this.direction3D.getX(), -FXGLMath.sinDeg(this.getRotationX()), this.direction3D.getZ() * FXGLMath.cosDeg(this.getRotationX())).normalize();
        Intrinsics.checkNotNullExpressionValue(point3D2, "Point3D(direction3D.x, -\u2026g(rotationX)).normalize()");
        this.direction3D = point3D2;
    }

    public final void bindTranslation(@NotNull TransformComponent other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.xProperty().bind(other.xProperty());
        this.yProperty().bind(other.yProperty());
        this.zProperty().bind(other.zProperty());
    }

    @Override
    @NotNull
    public String toString() {
        return "Transform(" + this.getX() + ", " + this.getY() + ", " + this.getAngle() + ", " + this.getScaleX() + ", " + this.getScaleY() + ")";
    }

    @Override
    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        bundle.put("propX", Double.valueOf(this.getX()));
        bundle.put("propY", Double.valueOf(this.getY()));
        bundle.put("angle", Double.valueOf(this.getAngle()));
        bundle.put("scaleX", Double.valueOf(this.getScaleX()));
        bundle.put("scaleY", Double.valueOf(this.getScaleY()));
        bundle.put("scaleOriginX", Double.valueOf(this.getScaleOrigin().getX()));
        bundle.put("scaleOriginY", Double.valueOf(this.getScaleOrigin().getY()));
        bundle.put("rotationOriginX", Double.valueOf(this.getRotationOrigin().getX()));
        bundle.put("rotationOriginY", Double.valueOf(this.getRotationOrigin().getY()));
    }

    @Override
    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        this.setPosition(((Number)bundle.get("propX")).doubleValue(), ((Number)bundle.get("propY")).doubleValue());
        this.setScaleOrigin(new Point2D(((Number)bundle.get("scaleOriginX")).doubleValue(), ((Number)bundle.get("scaleOriginY")).doubleValue()));
        this.setRotationOrigin(new Point2D(((Number)bundle.get("rotationOriginX")).doubleValue(), ((Number)bundle.get("rotationOriginY")).doubleValue()));
        this.setAngle(((Number)bundle.get("angle")).doubleValue());
        this.setScaleX(((Number)bundle.get("scaleX")).doubleValue());
        this.setScaleY(((Number)bundle.get("scaleY")).doubleValue());
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }

    private static final void _init_$lambda$0(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }
}

