/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.animation.Animatable;
import com.almasb.fxgl.core.Copyable;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.entity.EntityHelper;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.ComponentHelper;
import com.almasb.fxgl.entity.component.ComponentListener;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.entity.components.TypeComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.HitBox;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;

public class Entity
implements Animatable,
Copyable<Entity> {
    private static final Logger log = Logger.get(Entity.class);
    private PropertyMap properties = new PropertyMap();
    private ComponentMap components = new ComponentMap();
    private Map<String, ComponentMethod> componentMethods = new HashMap<String, ComponentMethod>();
    private List<ComponentListener> componentListeners = new ArrayList<ComponentListener>();
    private ReadOnlyBooleanWrapper active = new ReadOnlyBooleanWrapper(false);
    private Runnable onActive = EmptyRunnable.INSTANCE;
    private Runnable onNotActive = EmptyRunnable.INSTANCE;
    private boolean isEverUpdated = true;
    private boolean isUpdateEnabled = true;
    private boolean isUpdating = false;
    private boolean isReusable = false;
    private TypeComponent type = new TypeComponent();
    private TransformComponent transform = new TransformComponent();
    private BoundingBoxComponent bbox = new BoundingBoxComponent(new HitBox[0]);
    private ViewComponent view = new ViewComponent();
    private GameWorld world = null;

    public Entity() {
        this.addComponentNoChecks(this.type);
        this.addComponentNoChecks(this.transform);
        this.addComponentNoChecks(this.bbox);
        this.addComponentNoChecks(this.view);
    }

    public final GameWorld getWorld() {
        return this.world;
    }

    void init(GameWorld world) {
        this.world = world;
        this.onActive.run();
        this.active.set(true);
    }

    void clean() {
        if (this.isReusable) {
            this.world = null;
            return;
        }
        this.removeAllComponents();
        this.properties.clear();
        this.componentListeners.clear();
        this.componentMethods.clear();
        this.world = null;
        this.onActive = EmptyRunnable.INSTANCE;
        this.onNotActive = EmptyRunnable.INSTANCE;
        this.isUpdateEnabled = true;
        this.isUpdating = false;
    }

    public final void removeFromWorld() {
        if (this.world != null) {
            this.world.removeEntity(this);
        }
    }

    public final boolean isEverUpdated() {
        return this.isEverUpdated;
    }

    public final void setEverUpdated(boolean everUpdated) {
        this.isEverUpdated = everUpdated;
    }

    public final void setUpdateEnabled(boolean b) {
        this.isUpdateEnabled = b;
    }

    public boolean isReusable() {
        return this.isReusable;
    }

    public void setReusable(boolean isReusable) {
        this.isReusable = isReusable;
    }

    void update(double tpf) {
        if (!this.isUpdateEnabled) {
            return;
        }
        this.isUpdating = true;
        this.components.update(tpf);
        this.isUpdating = false;
    }

    void markForRemoval() {
        this.onNotActive.run();
        this.active.set(false);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.active.getReadOnlyProperty();
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void setOnActive(Runnable action) {
        this.onActive = action;
    }

    public final void setOnNotActive(Runnable action) {
        this.onNotActive = action;
    }

    public final PropertyMap getProperties() {
        return this.properties;
    }

    public final void setProperty(String key, Object value) {
        this.properties.setValue(key, value);
    }

    public final <T> Optional<T> getPropertyOptional(String key) {
        return this.properties.getValueOptional(key);
    }

    public final int getInt(String key) {
        return this.properties.getInt(key);
    }

    public final double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public final boolean getBoolean(String key) {
        return this.properties.getBoolean(key);
    }

    public final String getString(String key) {
        return this.properties.getString(key);
    }

    public final <T> T getObject(String key) {
        return this.properties.getObject(key);
    }

    public final void addComponentListener(ComponentListener listener2) {
        this.componentListeners.add(listener2);
    }

    public final void removeComponentListener(ComponentListener listener2) {
        this.componentListeners.remove(listener2);
    }

    public final boolean hasComponent(Class<? extends Component> type) {
        return this.components.has(type);
    }

    public final <T extends Component> Optional<T> getComponentOptional(Class<T> type) {
        return Optional.ofNullable((Component)type.cast(this.components.get(type)));
    }

    public final <T extends Component> T getComponent(Class<T> type) {
        Component component = this.components.get(type);
        if (component == null) {
            throw new IllegalArgumentException("Component " + type.getSimpleName() + " not found!");
        }
        return (T)((Component)type.cast(component));
    }

    public final List<Component> getComponents() {
        return this.components.getAll();
    }

    public final void addComponent(Component component) {
        if (this.isUpdating) {
            log.warning("Cannot add / remove components during updating");
            return;
        }
        if (this.checkRequirementsMet(component.getClass())) {
            this.addComponentNoChecks(component);
        }
    }

    private void addComponentNoChecks(Component component) {
        this.injectFields(component);
        component.onAdded();
        this.notifyComponentAdded(component);
        this.components.add(component);
    }

    public final boolean removeComponent(Class<? extends Component> type) {
        if (!this.hasComponent(type)) {
            return false;
        }
        if (this.isCoreComponent(type)) {
            log.warning("Removing a core component: " + String.valueOf(type) + " is not allowed. Ignoring");
            return false;
        }
        if (this.isUpdating) {
            log.warning("Cannot add / remove components during updating");
            return false;
        }
        this.checkNotRequiredByAny(type);
        this.removeComponent(this.getComponent(type));
        this.components.remove(type);
        return true;
    }

    public <T> T call(String componentMethodName, Object ... args2) {
        ComponentMethod method;
        if (this.componentMethods.containsKey(componentMethodName)) {
            method = this.componentMethods.get(componentMethodName);
        } else {
            Class[] types = (Class[])Arrays.stream(args2).map(Object::getClass).map(ReflectionUtils::convertToPrimitive).toArray(Class[]::new);
            method = this.findMethod(componentMethodName, types).orElseThrow(() -> new IllegalArgumentException("Cannot find method: " + this.format(componentMethodName, types)));
            this.componentMethods.put(componentMethodName, method);
        }
        try {
            return method.call(args2);
        }
        catch (Exception e) {
            String message2 = "Failed to call: " + this.format(componentMethodName, args2) + " Cause: " + String.valueOf(ReflectionUtils.getRootCause(e));
            throw new IllegalArgumentException(message2, e);
        }
    }

    private String format(String methodName, Object[] args2) {
        String argsString = Arrays.toString(args2);
        return methodName + "(" + argsString.substring(1, argsString.length() - 1) + ")";
    }

    private Optional<ComponentMethod> findMethod(String name, Class<?> ... types) {
        for (Component c : this.components.getAll()) {
            try {
                Method method = c.getClass().getDeclaredMethod(name, types);
                return Optional.of(new ComponentMethod(c, method));
            }
            catch (NoSuchMethodException e) {
            }
        }
        return Optional.empty();
    }

    private void removeAllComponents() {
        this.getComponents().forEach(this::removeComponent);
        this.components.clear();
    }

    private void injectFields(Component component) {
        ComponentHelper.setEntity(component, this);
        if (!component.isComponentInjectionRequired()) {
            return;
        }
        ReflectionUtils.findFieldsByTypeRecursive(component, Component.class).forEach(field -> this.getComponentOptional(field.getType()).ifPresent(comp -> ReflectionUtils.inject(field, component, comp)));
    }

    private void removeComponent(Component component) {
        this.notifyComponentRemoved(component);
        component.onRemoved();
        ComponentHelper.setEntity(component, null);
    }

    private <T extends Component> void notifyComponentAdded(T c) {
        this.componentListeners.forEach(l -> l.onAdded(c));
    }

    private <T extends Component> void notifyComponentRemoved(T c) {
        this.componentListeners.forEach(l -> l.onRemoved(c));
    }

    private boolean isCoreComponent(Class<? extends Component> type) {
        return type.getAnnotation(CoreComponent.class) != null;
    }

    private boolean checkRequirementsMet(Class<? extends Component> type) {
        if (this.hasComponent(type)) {
            log.warning("Entity already has component: " + type.getCanonicalName());
            return false;
        }
        for (Required r : (Required[])type.getAnnotationsByType(Required.class)) {
            if (this.hasComponent(r.value())) continue;
            throw new IllegalStateException("Required component: [" + r.value().getSimpleName() + "] for: " + type.getSimpleName() + " is missing");
        }
        return true;
    }

    private void checkNotRequiredByAny(Class<? extends Component> type) {
        for (Class<? extends Component> t : this.components.types()) {
            this.checkNotRequiredBy(t, type);
        }
    }

    private void checkNotRequiredBy(Class<? extends Component> requiringType, Class<? extends Component> type) {
        for (Required required : (Required[])requiringType.getAnnotationsByType(Required.class)) {
            if (!required.value().equals(type)) continue;
            throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + requiringType.getSimpleName());
        }
    }

    public final TypeComponent getTypeComponent() {
        return this.type;
    }

    public final TransformComponent getTransformComponent() {
        return this.transform;
    }

    public final BoundingBoxComponent getBoundingBoxComponent() {
        return this.bbox;
    }

    public final ViewComponent getViewComponent() {
        return this.view;
    }

    public final Serializable getType() {
        return (Serializable)this.type.getValue();
    }

    public final void setType(Serializable type) {
        this.type.setValue(type);
    }

    public final boolean isType(Object type) {
        return this.type.isType(type);
    }

    public final ObjectProperty<Serializable> typeProperty() {
        return this.type.valueProperty();
    }

    public final Point2D getPosition() {
        return this.transform.getPosition();
    }

    public final Point3D getPosition3D() {
        return this.transform.getPosition3D();
    }

    public final void setPosition(Point2D position) {
        this.transform.setPosition(position);
    }

    public final void setPosition(Vec2 position) {
        this.transform.setPosition(position.x, position.y);
    }

    public final void setPosition3D(Point3D position) {
        this.transform.setPosition3D(position);
    }

    public final void setPosition(double x, double y) {
        this.transform.setPosition(x, y);
    }

    public final void setPosition3D(double x, double y, double z) {
        this.transform.setPosition3D(x, y, z);
    }

    public final double getX() {
        return this.transform.getX();
    }

    public final double getY() {
        return this.transform.getY();
    }

    public final double getZ() {
        return this.transform.getZ();
    }

    public final void setX(double x) {
        this.transform.setX(x);
    }

    public final void setY(double y) {
        this.transform.setY(y);
    }

    public final void setZ(double z) {
        this.transform.setZ(z);
    }

    @Override
    public final DoubleProperty xProperty() {
        return this.transform.xProperty();
    }

    @Override
    public final DoubleProperty yProperty() {
        return this.transform.yProperty();
    }

    @Override
    public final DoubleProperty zProperty() {
        return this.transform.zProperty();
    }

    public final Point2D getLocalAnchor() {
        return this.transform.getLocalAnchor();
    }

    public final void setLocalAnchorFromCenter() {
        this.setLocalAnchor(this.bbox.getCenterLocal());
    }

    public final void setLocalAnchor(Point2D localAnchor) {
        this.transform.setLocalAnchor(localAnchor);
    }

    public final void setAnchoredPosition(double x, double y) {
        this.transform.setAnchoredPosition(new Point2D(x, y));
    }

    public final void setAnchoredPosition(Point2D p) {
        this.transform.setAnchoredPosition(p);
    }

    public final void setAnchoredPosition(double x, double y, Point2D localAnchor) {
        this.setPosition(x - localAnchor.getX(), y - localAnchor.getY());
    }

    public final Point2D getAnchoredPosition() {
        return this.transform.getAnchoredPosition();
    }

    public final Point2D getAnchoredPosition(Point2D localAnchor) {
        return new Point2D(this.getX() + localAnchor.getX(), this.getY() + localAnchor.getY());
    }

    public final void translate(Point2D vector) {
        this.transform.translate(vector);
    }

    public final void translate(Vec2 vector) {
        this.transform.translate(vector.x, vector.y);
    }

    public final void translate(double dx, double dy) {
        this.transform.translate(dx, dy);
    }

    public final void translate3D(Point3D vector) {
        this.transform.translate3D(vector);
    }

    public final void translate3D(double dx, double dy, double dz) {
        this.transform.translate3D(dx, dy, dz);
    }

    public final void translateX(double dx) {
        this.transform.translateX(dx);
    }

    public final void translateY(double dy) {
        this.transform.translateY(dy);
    }

    public final void translateZ(double dz) {
        this.transform.translateZ(dz);
    }

    public final void translateTowards(Point2D point, double distance) {
        this.transform.translateTowards(point, distance);
    }

    public final double distance(Entity other) {
        return this.transform.distance(other.transform);
    }

    public final double distanceBBox(Entity other) {
        Rectangle2D rect1 = this.bbox.range(0.0, 0.0);
        Rectangle2D rect2 = other.bbox.range(0.0, 0.0);
        return FXGLMath.distance(rect1, rect2);
    }

    public final double getRotation() {
        return this.transform.getAngle();
    }

    public final void setRotation(double angle) {
        this.transform.setAngle(angle);
    }

    public final DoubleProperty angleProperty() {
        return this.transform.angleProperty();
    }

    public final void rotateBy(double angle) {
        this.transform.rotateBy(angle);
    }

    public final void rotateToVector(Point2D vector) {
        this.transform.rotateToVector(vector);
    }

    public final void setScaleUniform(double scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.setScaleZ(scale);
    }

    public final void setScaleX(double scaleX) {
        this.transform.setScaleX(scaleX);
    }

    public final void setScaleY(double scaleY) {
        this.transform.setScaleY(scaleY);
    }

    public final void setScaleZ(double scaleZ) {
        this.transform.setScaleZ(scaleZ);
    }

    public final double getScaleX() {
        return this.transform.getScaleX();
    }

    public final double getScaleY() {
        return this.transform.getScaleY();
    }

    public final double getScaleZ() {
        return this.transform.getScaleZ();
    }

    public final double getWidth() {
        return this.bbox.getWidth();
    }

    public final double getHeight() {
        return this.bbox.getHeight();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.bbox.widthProperty();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.bbox.heightProperty();
    }

    public final double getRightX() {
        return this.bbox.getMaxXWorld();
    }

    public final double getBottomY() {
        return this.bbox.getMaxYWorld();
    }

    public final Point2D getCenter() {
        return this.bbox.getCenterWorld();
    }

    public final boolean isColliding(Entity other) {
        return this.bbox.isCollidingWith(other.bbox);
    }

    public final boolean isWithin(Rectangle2D bounds) {
        return this.bbox.isWithin(bounds);
    }

    public final void setOpacity(double opacity) {
        this.view.setOpacity(opacity);
    }

    public final double getOpacity() {
        return this.view.getOpacity();
    }

    public final void setVisible(boolean isVisible) {
        this.view.setVisible(isVisible);
    }

    public final boolean isVisible() {
        return this.view.isVisible();
    }

    public final void setZIndex(int z) {
        this.view.setZIndex(z);
    }

    public final int getZIndex() {
        return this.view.getZIndex();
    }

    @Override
    public DoubleProperty scaleXProperty() {
        return this.transform.scaleXProperty();
    }

    @Override
    public DoubleProperty scaleYProperty() {
        return this.transform.scaleYProperty();
    }

    @Override
    public DoubleProperty scaleZProperty() {
        return this.transform.scaleZProperty();
    }

    @Override
    public DoubleProperty rotationXProperty() {
        return this.transform.rotationXProperty();
    }

    @Override
    public DoubleProperty rotationYProperty() {
        return this.transform.rotationYProperty();
    }

    @Override
    public DoubleProperty rotationZProperty() {
        return this.transform.rotationZProperty();
    }

    @Override
    public DoubleProperty opacityProperty() {
        return this.view.opacityProperty();
    }

    public void setScaleOrigin(Point2D pivotPoint) {
        this.transform.setScaleOrigin(pivotPoint);
    }

    public void setRotationOrigin(Point2D pivotPoint) {
        this.transform.setRotationOrigin(pivotPoint);
    }

    @Override
    public void setScaleOrigin(Point3D pivotPoint) {
        this.transform.setScaleOrigin3D(pivotPoint);
    }

    @Override
    public void setRotationOrigin(Point3D pivotPoint) {
        this.transform.setRotationOrigin3D(pivotPoint);
    }

    @Override
    public Entity copy() {
        return EntityHelper.INSTANCE.copy(this);
    }

    public String toString() {
        List<Component> comps = this.getComponents();
        ArrayList coreComponentsAsString = new ArrayList(comps.size());
        ArrayList otherComponentsAsString = new ArrayList(comps.size());
        comps.forEach(c -> {
            if (this.isCoreComponent(c.getClass())) {
                coreComponentsAsString.add(c.toString());
            } else {
                otherComponentsAsString.add(c.toString());
            }
        });
        Collections.sort(coreComponentsAsString);
        Collections.sort(otherComponentsAsString);
        return "Entity(" + String.valueOf(coreComponentsAsString) + String.valueOf(otherComponentsAsString) + ")";
    }

    private static class ComponentMap {
        private Map<Class<? extends Component>, Component> components = new HashMap<Class<? extends Component>, Component>();
        private List<Component> componentList = new ArrayList<Component>();

        private ComponentMap() {
        }

        void update(double tpf) {
            for (int i2 = 0; i2 < this.componentList.size(); ++i2) {
                Component c = this.componentList.get(i2);
                if (c.isPaused()) continue;
                c.onUpdate(tpf);
            }
        }

        <T extends Component> boolean has(Class<T> type) {
            return this.components.containsKey(type);
        }

        void add(Component c) {
            this.components.put(c.getClass(), c);
            this.componentList.add(c);
        }

        void remove(Class<? extends Component> type) {
            Component c = this.components.remove(type);
            this.componentList.remove(c);
        }

        <T extends Component> Component get(Class<T> type) {
            return this.components.get(type);
        }

        Set<Class<? extends Component>> types() {
            return this.components.keySet();
        }

        List<Component> getAll() {
            return new ArrayList<Component>(this.componentList);
        }

        void clear() {
            this.components.clear();
            this.componentList.clear();
        }
    }

    private static class ComponentMethod {
        private Method method;
        private Component component;

        ComponentMethod(Component component, Method method) {
            this.component = component;
            this.method = method;
        }

        <T> T call(Object ... args2) throws Exception {
            return (T)this.method.invoke((Object)this.component, args2);
        }
    }
}

