/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.components;

import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/almasb/fxgl/dsl/components/WaypointMoveComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "speed", "", "waypoints", "", "Ljavafx/geometry/Point2D;", "(DLjava/util/List;)V", "isAtDestinationProp", "Ljavafx/beans/property/ReadOnlyBooleanWrapper;", "log", "Lcom/almasb/fxgl/logging/Logger;", "nextPoint", "points", "", "getSpeed", "()D", "setSpeed", "(D)V", "atDestinationProperty", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "isComponentInjectionRequired", "", "move", "", "onUpdate", "tpf", "fxgl"})
@SourceDebugExtension(value={"SMAP\nWaypointMoveComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaypointMoveComponent.kt\ncom/almasb/fxgl/dsl/components/WaypointMoveComponent\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n*L\n1#1,71:1\n157#2:72\n*S KotlinDebug\n*F\n+ 1 WaypointMoveComponent.kt\ncom/almasb/fxgl/dsl/components/WaypointMoveComponent\n*L\n24#1:72\n*E\n"})
public final class WaypointMoveComponent
extends Component {
    private double speed;
    @NotNull
    private final Logger log;
    @NotNull
    private List<Point2D> points;
    @NotNull
    private Point2D nextPoint;
    @NotNull
    private final ReadOnlyBooleanWrapper isAtDestinationProp;

    public WaypointMoveComponent(double speed, @NotNull List<? extends Point2D> waypoints) {
        Intrinsics.checkNotNullParameter(waypoints, "waypoints");
        this.speed = speed;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(WaypointMoveComponent.class);
        this.points = new ArrayList();
        Point2D point2D = Point2D.ZERO;
        Intrinsics.checkNotNullExpressionValue(point2D, "ZERO");
        this.nextPoint = point2D;
        this.isAtDestinationProp = new ReadOnlyBooleanWrapper(true);
        this.move(waypoints);
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    @NotNull
    public final ReadOnlyBooleanProperty atDestinationProperty() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = this.isAtDestinationProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue(readOnlyBooleanProperty, "isAtDestinationProp.readOnlyProperty");
        return readOnlyBooleanProperty;
    }

    public final void move(@NotNull List<? extends Point2D> waypoints) {
        Intrinsics.checkNotNullParameter(waypoints, "waypoints");
        this.points.clear();
        this.points.addAll((Collection<Point2D>)waypoints);
        if (this.points.isEmpty()) {
            this.log.warning("No waypoints given. Using Point2D.ZERO as dummy");
            Point2D point2D = Point2D.ZERO;
            Intrinsics.checkNotNullExpressionValue(point2D, "ZERO");
            this.points.add(point2D);
        }
        this.nextPoint = this.points.remove(0);
        this.isAtDestinationProp.setValue(false);
    }

    @Override
    public void onUpdate(double tpf) {
        Boolean bl = this.isAtDestinationProp.getValue();
        Intrinsics.checkNotNullExpressionValue(bl, "isAtDestinationProp.value");
        if (bl.booleanValue()) {
            return;
        }
        double dist = tpf * this.speed;
        if (this.nextPoint.distance(this.entity.getAnchoredPosition()) < dist) {
            this.entity.setAnchoredPosition(this.nextPoint);
            if (!((Collection)this.points).isEmpty()) {
                this.nextPoint = this.points.remove(0);
            } else {
                this.isAtDestinationProp.setValue(true);
            }
        } else {
            this.entity.translateTowards(this.nextPoint, dist);
        }
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }
}

