/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl.components;

import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.CopyableComponent;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u000eJ\b\u0010\u001d\u001a\u00020\u0000H\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020 H\u0002R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\n\u00a8\u0006'"}, d2={"Lcom/almasb/fxgl/dsl/components/ProjectileComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "Lcom/almasb/fxgl/entity/component/CopyableComponent;", "()V", "direction", "Ljavafx/geometry/Point2D;", "speed", "", "(Ljavafx/geometry/Point2D;D)V", "getDirection", "()Ljavafx/geometry/Point2D;", "setDirection", "(Ljavafx/geometry/Point2D;)V", "isAllowRotation", "", "value", "getSpeed", "()D", "setSpeed", "(D)V", "speedListener", "Ljavafx/beans/value/ChangeListener;", "", "speedProp", "Ljavafx/beans/property/SimpleDoubleProperty;", "<set-?>", "velocity", "getVelocity", "allowRotation", "copy", "isComponentInjectionRequired", "onAdded", "", "onRemoved", "onUpdate", "tpf", "speedProperty", "Ljavafx/beans/property/DoubleProperty;", "updateRotation", "fxgl"})
public final class ProjectileComponent
extends Component
implements CopyableComponent<ProjectileComponent> {
    @NotNull
    private Point2D velocity;
    @NotNull
    private final SimpleDoubleProperty speedProp;
    @NotNull
    private final ChangeListener<Number> speedListener;
    private boolean isAllowRotation;

    public ProjectileComponent(@NotNull Point2D direction, double speed) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        Point2D point2D = direction.normalize().multiply(speed);
        Intrinsics.checkNotNullExpressionValue(point2D, "direction.normalize().multiply(speed)");
        this.velocity = point2D;
        this.speedProp = new SimpleDoubleProperty(speed);
        this.speedListener = (arg_0, arg_1, arg_2) -> ProjectileComponent.speedListener$lambda$0(this, arg_0, arg_1, arg_2);
        this.isAllowRotation = true;
    }

    public ProjectileComponent() {
        this(new Point2D(1.0, 0.0), 1.0);
    }

    @NotNull
    public final Point2D getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final Point2D getDirection() {
        Point2D point2D = this.velocity.normalize();
        Intrinsics.checkNotNullExpressionValue(point2D, "velocity.normalize()");
        return point2D;
    }

    public final void setDirection(@NotNull Point2D direction) {
        Intrinsics.checkNotNullParameter(direction, "direction");
        Point2D point2D = direction.normalize().multiply(this.getSpeed());
        Intrinsics.checkNotNullExpressionValue(point2D, "direction.normalize().multiply(speed)");
        this.velocity = point2D;
        this.updateRotation();
    }

    @NotNull
    public final DoubleProperty speedProperty() {
        return this.speedProp;
    }

    public final double getSpeed() {
        Double d = this.speedProp.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "speedProp.value");
        return ((Number)d).doubleValue();
    }

    public final void setSpeed(double value) {
        this.speedProp.setValue(value);
    }

    @NotNull
    public final ProjectileComponent allowRotation(boolean allowRotation) {
        this.isAllowRotation = allowRotation;
        return this;
    }

    private final void updateRotation() {
        if (this.isAllowRotation) {
            this.entity.rotateToVector(this.velocity);
        }
    }

    @Override
    public void onAdded() {
        this.updateRotation();
        this.speedProp.addListener((ChangeListener<? super Number>)this.speedListener);
    }

    @Override
    public void onUpdate(double tpf) {
        this.entity.translate(this.velocity.multiply(tpf));
    }

    @Override
    public void onRemoved() {
        this.speedProp.removeListener((ChangeListener<? super Number>)this.speedListener);
    }

    @Override
    @NotNull
    public ProjectileComponent copy() {
        return new ProjectileComponent(this.getDirection(), this.getSpeed());
    }

    @Override
    public boolean isComponentInjectionRequired() {
        return false;
    }

    private static final void speedListener$lambda$0(ProjectileComponent this$0, ObservableValue observableValue, Number number, Number newSpeed) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Point2D point2D = this$0.velocity.normalize().multiply(newSpeed.doubleValue());
        Intrinsics.checkNotNullExpressionValue(point2D, "velocity.normalize().multiply(newSpeed.toDouble())");
        this$0.velocity = point2D;
        this$0.updateRotation();
    }
}

