/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dsl;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.CollidableComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Sphere;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\rJ\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u001e\u0010\t\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0007J\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001c\u001a\u00020\u0007J\u0006\u0010\u001d\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000fJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010!\u001a\u00020\u0000J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010#\u001a\u00020\u0000J\u0014\u0010$\u001a\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&J\u0014\u0010'\u001a\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&J\u0014\u0010(\u001a\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070&J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\fJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\fJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\rJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u001e\u0010/\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u00100\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\fJ\u0016\u00100\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0012\u00101\u001a\u00020\u00002\n\u00102\u001a\u0006\u0012\u0002\b\u000303J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u000e\u00104\u001a\u00020\u00002\u0006\u00107\u001a\u000208J\u000e\u00104\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020\u00002\u0006\u00105\u001a\u000206J\u000e\u0010;\u001a\u00020\u00002\u0006\u00107\u001a\u000208J\u000e\u0010;\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u001f\u0010<\u001a\u00020\u00002\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020?0>\"\u00020?\u00a2\u0006\u0002\u0010@J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020\u0001J\u000e\u0010C\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020DR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/almasb/fxgl/dsl/EntityBuilder;", "", "()V", "data", "Lcom/almasb/fxgl/entity/SpawnData;", "(Lcom/almasb/fxgl/entity/SpawnData;)V", "entity", "Lcom/almasb/fxgl/entity/Entity;", "anchorFromCenter", "at", "p", "Lcom/almasb/fxgl/core/math/Vec2;", "Ljavafx/geometry/Point2D;", "Ljavafx/geometry/Point3D;", "x", "", "y", "z", "atAnchored", "localAnchor", "position", "bbox", "shape", "Lcom/almasb/fxgl/physics/BoundingShape;", "box", "Lcom/almasb/fxgl/physics/HitBox;", "build", "buildAndAttach", "buildOrigin3D", "buildOrigin3DAndAttach", "buildScreenBounds", "thickness", "buildScreenBoundsAndAttach", "collidable", "from", "neverUpdated", "onActive", "action", "Ljava/util/function/Consumer;", "onClick", "onNotActive", "opacity", "value", "rotate", "angle", "rotationOrigin", "point", "scale", "scaleOrigin", "type", "t", "", "view", "url", "Ljava/net/URL;", "node", "Ljavafx/scene/Node;", "textureName", "", "viewWithBBox", "with", "comps", "", "Lcom/almasb/fxgl/entity/component/Component;", "([Lcom/almasb/fxgl/entity/component/Component;)Lcom/almasb/fxgl/dsl/EntityBuilder;", "propertyKey", "propertyValue", "zIndex", "", "fxgl"})
@SourceDebugExtension(value={"SMAP\nEntityBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityBuilder.kt\ncom/almasb/fxgl/dsl/EntityBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n215#2,2:264\n13579#3,2:266\n1#4:268\n*S KotlinDebug\n*F\n+ 1 EntityBuilder.kt\ncom/almasb/fxgl/dsl/EntityBuilder\n*L\n54#1:264,2\n202#1:266,2\n*E\n"})
public final class EntityBuilder {
    @NotNull
    private final Entity entity;

    public EntityBuilder() {
        this.entity = new Entity();
    }

    public EntityBuilder(@NotNull SpawnData data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.entity = new Entity();
        this.from(data);
    }

    @Deprecated(message="Use FXGL.entityBuilder(data)")
    @NotNull
    public final EntityBuilder from(@NotNull SpawnData data) {
        Object value;
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(data, "data");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.at(data.getX(), data.getY(), data.getZ());
        if (data.hasKey("type") && (value = data.get("type")) instanceof Enum) {
            this.type((Enum)value);
        }
        Map $this$forEach$iv = data.getData();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = iterator2.next();
            boolean bl2 = false;
            this.entity.setProperty((String)it2.getKey(), it2.getValue());
        }
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder type(@NotNull Enum<?> t) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(t, "t");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setType((Serializable)((Object)t));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(double x, double y) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition(x, y);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(double x, double y, double z) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition3D(x, y, z);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(@NotNull Vec2 p) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(p, "p");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition(p);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(@NotNull Point2D p) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(p, "p");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition(p);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder at(@NotNull Point3D p) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(p, "p");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setPosition3D(p);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder atAnchored(@NotNull Point2D localAnchor, @NotNull Point2D position) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(localAnchor, "localAnchor");
        Intrinsics.checkNotNullParameter(position, "position");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setLocalAnchor(localAnchor);
        this.entity.setAnchoredPosition(position);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder anchorFromCenter() {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setLocalAnchorFromCenter();
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder rotationOrigin(double x, double y) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getTransformComponent().setRotationOrigin(new Point2D(x, y));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder rotationOrigin(@NotNull Point2D point) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(point, "point");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getTransformComponent().setRotationOrigin(point);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder rotate(double angle) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.rotateBy(angle);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scaleOrigin(double x, double y) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getTransformComponent().setScaleOrigin(new Point2D(x, y));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scaleOrigin(@NotNull Point2D point) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(point, "point");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getTransformComponent().setScaleOrigin(point);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scale(double x, double y, double z) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setScaleX(x);
        this.entity.setScaleY(y);
        this.entity.setScaleZ(z);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scale(double x, double y) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setScaleX(x);
        this.entity.setScaleY(y);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scale(@NotNull Point2D scale) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(scale, "scale");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.scale(scale.getX(), scale.getY());
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder scale(@NotNull Point3D scale) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(scale, "scale");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.scale(scale.getX(), scale.getY(), scale.getZ());
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder opacity(double value) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getViewComponent().setOpacity(value);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder bbox(@NotNull HitBox box) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(box, "box");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.getBoundingBoxComponent().addHitBox(box);
        Point2D center = this.entity.getBoundingBoxComponent().getCenterLocal();
        this.entity.getTransformComponent().setScaleOrigin(center);
        this.entity.getTransformComponent().setRotationOrigin(center);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder bbox(@NotNull BoundingShape shape) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(shape, "shape");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        HitBox hitBox = new HitBox(shape);
        this.bbox(hitBox);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder view(@NotNull Node node) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(node, "node");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        ViewComponent viewComponent = this.entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue(viewComponent, "entity.viewComponent");
        ViewComponent.addChild$default(viewComponent, node, false, 2, null);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder viewWithBBox(@NotNull Node node) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(node, "node");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.view(node);
        this.entity.getBoundingBoxComponent().clearHitBoxes();
        double w = node.getLayoutBounds().getWidth();
        double h = node.getLayoutBounds().getHeight();
        this.bbox(new HitBox("__VIEW__", BoundingShape.Companion.box(w, h)));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder view(@NotNull String textureName) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(textureName, "textureName");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.view(FXGL.Companion.texture(textureName));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder viewWithBBox(@NotNull String textureName) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(textureName, "textureName");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.viewWithBBox(FXGL.Companion.texture(textureName));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder view(@NotNull URL url) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(url, "url");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.view(FXGLForKtKt.getAssetLoader().loadTexture(url));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder viewWithBBox(@NotNull URL url) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(url, "url");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.viewWithBBox(FXGLForKtKt.getAssetLoader().loadTexture(url));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder zIndex(int z) {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setZIndex(z);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder onClick(@NotNull Consumer<Entity> action) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(action, "action");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        ViewComponent viewComponent = this.entity.getViewComponent();
        EventType<MouseEvent> eventType = MouseEvent.MOUSE_CLICKED;
        Intrinsics.checkNotNullExpressionValue(eventType, "MOUSE_CLICKED");
        viewComponent.addEventHandler(eventType, arg_0 -> EntityBuilder.onClick$lambda$30$lambda$29(action, this, arg_0));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder onActive(@NotNull Consumer<Entity> action) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(action, "action");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setOnActive(() -> EntityBuilder.onActive$lambda$32$lambda$31(action, this));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder onNotActive(@NotNull Consumer<Entity> action) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(action, "action");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setOnNotActive(() -> EntityBuilder.onNotActive$lambda$34$lambda$33(action, this));
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder neverUpdated() {
        EntityBuilder entityBuilder;
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setEverUpdated(false);
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder collidable() {
        Component[] componentArray = new Component[]{new CollidableComponent(true)};
        return this.with(componentArray);
    }

    @NotNull
    public final EntityBuilder with(Component ... comps) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(comps, "comps");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        Component[] $this$forEach$iv = comps;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Component element$iv;
            Component it2 = element$iv = $this$forEach$iv[j];
            boolean bl2 = false;
            this.entity.addComponent(it2);
        }
        return entityBuilder;
    }

    @NotNull
    public final EntityBuilder with(@NotNull String propertyKey, @NotNull Object propertyValue) {
        EntityBuilder entityBuilder;
        Intrinsics.checkNotNullParameter(propertyKey, "propertyKey");
        Intrinsics.checkNotNullParameter(propertyValue, "propertyValue");
        EntityBuilder it = entityBuilder = this;
        boolean bl = false;
        this.entity.setProperty(propertyKey, propertyValue);
        return entityBuilder;
    }

    @NotNull
    public final Entity build() {
        return this.entity;
    }

    @NotNull
    public final Entity buildAndAttach() {
        Entity entity;
        Entity it = entity = this.entity;
        boolean bl = false;
        FXGL.Companion.getGameWorld().addEntity(it);
        return entity;
    }

    @NotNull
    public final Entity buildScreenBounds(double thickness) {
        double w = FXGL.Companion.getAppWidth();
        double h = FXGL.Companion.getAppHeight();
        Component[] componentArray = new Component[]{new PhysicsComponent()};
        return this.bbox(new HitBox("LEFT", new Point2D(-thickness, 0.0), BoundingShape.Companion.box(thickness, h))).bbox(new HitBox("RIGHT", new Point2D(w, 0.0), BoundingShape.Companion.box(thickness, h))).bbox(new HitBox("TOP", new Point2D(0.0, -thickness), BoundingShape.Companion.box(w, thickness))).bbox(new HitBox("BOT", new Point2D(0.0, h), BoundingShape.Companion.box(w, thickness))).with(componentArray).build();
    }

    @NotNull
    public final Entity buildScreenBoundsAndAttach(double thickness) {
        Entity entity;
        Entity it = entity = this.entity;
        boolean bl = false;
        FXGL.Companion.getGameWorld().addEntity(this.buildScreenBounds(thickness));
        return entity;
    }

    @NotNull
    public final Entity buildOrigin3D() {
        Sphere sp = new Sphere(0.1);
        sp.setMaterial(new PhongMaterial(Color.YELLOW));
        Box axisX = new Box(1.0, 0.1, 0.1);
        axisX.setTranslateX(0.5);
        axisX.setMaterial(new PhongMaterial(Color.RED));
        Box axisY = new Box(0.1, 1.0, 0.1);
        axisY.setTranslateY(0.5);
        axisY.setMaterial(new PhongMaterial(Color.LIGHTGREEN));
        Box axisZ = new Box(0.1, 0.1, 1.0);
        axisZ.setTranslateZ(0.5);
        axisZ.setMaterial(new PhongMaterial(Color.BLUE));
        return this.view(sp).view(axisX).view(axisY).view(axisZ).build();
    }

    @NotNull
    public final Entity buildOrigin3DAndAttach() {
        Entity entity;
        Entity it = entity = this.buildOrigin3D();
        boolean bl = false;
        FXGL.Companion.getGameWorld().addEntity(it);
        return entity;
    }

    private static final void onClick$lambda$30$lambda$29(Consumer $action, EntityBuilder this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter($action, "$action");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $action.accept(this$0.entity);
    }

    private static final void onActive$lambda$32$lambda$31(Consumer $action, EntityBuilder this$0) {
        Intrinsics.checkNotNullParameter($action, "$action");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $action.accept(this$0.entity);
    }

    private static final void onNotActive$lambda$34$lambda$33(Consumer $action, EntityBuilder this$0) {
        Intrinsics.checkNotNullParameter($action, "$action");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $action.accept(this$0.entity);
    }
}

