/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev.profiling;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.dev.profiling.ProfilerWindow;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.SceneService;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "cpuProfilerWindow", "Lcom/almasb/fxgl/dev/profiling/ProfilerWindow;", "fpsProfilerWindow", "gcRuns", "", "ramProfilerWindow", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "usedRAM", "", "onExit", "", "onInit", "onUpdate", "tpf", "", "Companion", "fxgl"})
public final class ProfilerService
extends EngineService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private SceneService sceneService;
    private long usedRAM;
    private int gcRuns;
    private ProfilerWindow cpuProfilerWindow;
    private ProfilerWindow fpsProfilerWindow;
    private ProfilerWindow ramProfilerWindow;
    private static final Runtime runtime = Runtime.getRuntime();
    private static final double MB = 1048576.0;

    @Override
    public void onInit() {
        this.fpsProfilerWindow = new ProfilerWindow(300.0, 100.0, "FPS");
        ProfilerWindow profilerWindow = this.fpsProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fpsProfilerWindow");
            profilerWindow = null;
        }
        profilerWindow.setNumYTicks(2);
        ProfilerWindow profilerWindow2 = this.fpsProfilerWindow;
        if (profilerWindow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fpsProfilerWindow");
            profilerWindow2 = null;
        }
        profilerWindow2.setPreferredMaxValue(60.0);
        this.cpuProfilerWindow = new ProfilerWindow(300.0, 100.0, "CPU (ms)");
        ProfilerWindow profilerWindow3 = this.cpuProfilerWindow;
        if (profilerWindow3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cpuProfilerWindow");
            profilerWindow3 = null;
        }
        profilerWindow3.setNumYTicks(5);
        ProfilerWindow profilerWindow4 = this.cpuProfilerWindow;
        if (profilerWindow4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cpuProfilerWindow");
            profilerWindow4 = null;
        }
        profilerWindow4.setPreferredMaxValue(17.0);
        ProfilerWindow profilerWindow5 = this.cpuProfilerWindow;
        if (profilerWindow5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cpuProfilerWindow");
            profilerWindow5 = null;
        }
        profilerWindow5.relocate(300.0, 0.0);
        this.ramProfilerWindow = new ProfilerWindow(300.0, 100.0, "RAM (MB)");
        ProfilerWindow profilerWindow6 = this.ramProfilerWindow;
        if (profilerWindow6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ramProfilerWindow");
            profilerWindow6 = null;
        }
        profilerWindow6.setNumYTicks(5);
        ProfilerWindow profilerWindow7 = this.ramProfilerWindow;
        if (profilerWindow7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ramProfilerWindow");
            profilerWindow7 = null;
        }
        profilerWindow7.setPreferredMaxValue(300.0);
        ProfilerWindow profilerWindow8 = this.ramProfilerWindow;
        if (profilerWindow8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ramProfilerWindow");
            profilerWindow8 = null;
        }
        profilerWindow8.relocate(600.0, 0.0);
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sceneService");
            sceneService = null;
        }
        ObservableList<Node> observableList = sceneService.getOverlayRoot().getChildren();
        Node[] nodeArray = new Node[3];
        ProfilerWindow profilerWindow9 = this.fpsProfilerWindow;
        if (profilerWindow9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fpsProfilerWindow");
            profilerWindow9 = null;
        }
        nodeArray[0] = profilerWindow9;
        ProfilerWindow profilerWindow10 = this.cpuProfilerWindow;
        if (profilerWindow10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cpuProfilerWindow");
            profilerWindow10 = null;
        }
        nodeArray[1] = profilerWindow10;
        ProfilerWindow profilerWindow11 = this.ramProfilerWindow;
        if (profilerWindow11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ramProfilerWindow");
            profilerWindow11 = null;
        }
        nodeArray[2] = profilerWindow11;
        observableList.addAll((Node[])nodeArray);
    }

    @Override
    public void onUpdate(double tpf) {
        ProfilerWindow profilerWindow = this.fpsProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fpsProfilerWindow");
            profilerWindow = null;
        }
        profilerWindow.update(1.0 / tpf);
        ProfilerWindow profilerWindow2 = this.cpuProfilerWindow;
        if (profilerWindow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cpuProfilerWindow");
            profilerWindow2 = null;
        }
        profilerWindow2.update((double)FXGL.Companion.cpuNanoTime() / 1000000.0);
        long used = runtime.totalMemory() - runtime.freeMemory();
        if (used < 0L) {
            return;
        }
        if (used < this.usedRAM) {
            int n = this.gcRuns;
            this.gcRuns = n + 1;
        }
        this.usedRAM = used;
        ProfilerWindow profilerWindow3 = this.ramProfilerWindow;
        if (profilerWindow3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ramProfilerWindow");
            profilerWindow3 = null;
        }
        profilerWindow3.update((double)this.usedRAM / 1048576.0);
    }

    @Override
    public void onExit() {
        Logger log = Logger.Companion.get(this.getClass());
        ProfilerWindow profilerWindow = this.fpsProfilerWindow;
        if (profilerWindow == null) {
            Intrinsics.throwUninitializedPropertyAccessException("fpsProfilerWindow");
            profilerWindow = null;
        }
        profilerWindow.log();
        ProfilerWindow profilerWindow2 = this.cpuProfilerWindow;
        if (profilerWindow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cpuProfilerWindow");
            profilerWindow2 = null;
        }
        profilerWindow2.log();
        ProfilerWindow profilerWindow3 = this.ramProfilerWindow;
        if (profilerWindow3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("ramProfilerWindow");
            profilerWindow3 = null;
        }
        profilerWindow3.log();
        log.info("Estimated GC runs: " + this.gcRuns);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/almasb/fxgl/dev/profiling/ProfilerService$Companion;", "", "()V", "MB", "", "runtime", "Ljava/lang/Runtime;", "kotlin.jvm.PlatformType", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

