/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev;

import com.almasb.fxgl.app.scene.GameView;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.dev.Console;
import com.almasb.fxgl.dev.DevPane;
import com.almasb.fxgl.dev.DevService;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.LoggerLevel;
import com.almasb.fxgl.logging.LoggerOutput;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.Box3DShapeData;
import com.almasb.fxgl.physics.BoxShapeData;
import com.almasb.fxgl.physics.ChainShapeData;
import com.almasb.fxgl.physics.CircleShapeData;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PolygonShapeData;
import com.almasb.fxgl.scene.SceneService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u001bH\u0016J\u0006\u0010$\u001a\u00020\u001bJ\u0006\u0010%\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/dev/DevService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "console", "Lcom/almasb/fxgl/dev/Console;", "getConsole", "()Lcom/almasb/fxgl/dev/Console;", "console$delegate", "Lkotlin/Lazy;", "consoleOutput", "com/almasb/fxgl/dev/DevService$consoleOutput$1", "Lcom/almasb/fxgl/dev/DevService$consoleOutput$1;", "debugViews", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/entity/Entity;", "Lcom/almasb/fxgl/app/scene/GameView;", "Lkotlin/collections/HashMap;", "devPane", "Lcom/almasb/fxgl/dev/DevPane;", "isConsoleOpen", "", "()Z", "isDevEnabled", "isDevPaneOpen", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "addDebugView", "", "entity", "closeConsole", "closeDevPane", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "onInit", "onMainLoopStarting", "openConsole", "openDevPane", "pushDebugMessage", "message", "", "removeDebugView", "fxgl"})
@SourceDebugExtension(value={"SMAP\nDevService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevService.kt\ncom/almasb/fxgl/dev/DevService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,197:1\n1855#2:198\n1856#2:211\n10242#3:199\n10664#3,5:200\n10242#3:205\n10664#3,5:206\n*S KotlinDebug\n*F\n+ 1 DevService.kt\ncom/almasb/fxgl/dev/DevService\n*L\n135#1:198\n135#1:211\n155#1:199\n155#1:200,5\n159#1:205\n159#1:206,5\n*E\n"})
public final class DevService
extends EngineService {
    private SceneService sceneService;
    private DevPane devPane;
    @NotNull
    private final Lazy console$delegate = LazyKt.lazy(console.2.INSTANCE);
    @NotNull
    private final consoleOutput.1 consoleOutput = new LoggerOutput(this){
        final /* synthetic */ DevService this$0;
        {
            this.this$0 = $receiver;
        }

        public void append(@NotNull String message2) {
            Intrinsics.checkNotNullParameter(message2, "message");
            DevService.access$getConsole(this.this$0).pushMessage(message2);
        }

        public void close() {
        }
    };
    @NotNull
    private final HashMap<Entity, GameView> debugViews = new HashMap();

    private final Console getConsole() {
        Lazy lazy = this.console$delegate;
        return (Console)lazy.getValue();
    }

    public final boolean isConsoleOpen() {
        return this.getConsole().isOpen();
    }

    public final boolean isDevPaneOpen() {
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException("devPane");
            devPane = null;
        }
        return devPane.isOpen();
    }

    private final boolean isDevEnabled() {
        return !FXGLForKtKt.isReleaseMode() && FXGL.Companion.getSettings().isDeveloperMenuEnabled();
    }

    @Override
    public void onInit() {
        if (!this.isDevEnabled()) {
            return;
        }
        SceneService sceneService = this.sceneService;
        if (sceneService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sceneService");
            sceneService = null;
        }
        this.devPane = new DevPane(sceneService, FXGL.Companion.getSettings());
    }

    public final void openConsole() {
        if (!this.isDevEnabled()) {
            return;
        }
        this.getConsole().open();
    }

    public final void closeConsole() {
        if (!this.isDevEnabled()) {
            return;
        }
        this.getConsole().close();
    }

    public final void openDevPane() {
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException("devPane");
            devPane = null;
        }
        devPane.open();
    }

    public final void closeDevPane() {
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException("devPane");
            devPane = null;
        }
        devPane.close();
    }

    public final void pushDebugMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException("devPane");
            devPane = null;
        }
        devPane.pushMessage(message2);
    }

    @Override
    public void onMainLoopStarting() {
        if (!this.isDevEnabled()) {
            return;
        }
        Logger.Companion.addOutput(this.consoleOutput, LoggerLevel.DEBUG);
        FXGL.Companion.getSettings().devShowBBoxProperty().addListener((ChangeListener<? super Boolean>)((ChangeListener<Object>)(arg_0, arg_1, arg_2) -> DevService.onMainLoopStarting$lambda$0(new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>(this){
            final /* synthetic */ DevService this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean isSelected) {
                Intrinsics.checkNotNullExpressionValue(isSelected, "isSelected");
                if (isSelected.booleanValue()) {
                    void $this$forEach$iv;
                    Iterable iterable = FXGL.Companion.getGameWorld().getEntities();
                    DevService devService = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl2 = false;
                        DevService.access$addDebugView(devService, it);
                    }
                } else {
                    Iterable $this$forEach$iv = FXGL.Companion.getGameWorld().getEntities();
                    DevService devService = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl3 = false;
                        DevService.access$removeDebugView(devService, it);
                    }
                }
            }
        }, arg_0, arg_1, arg_2)));
        FXGL.Companion.getGameWorld().addWorldListener(new EntityWorldListener(this){
            final /* synthetic */ DevService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEntityAdded(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter(entity, "entity");
                Boolean bl = FXGL.Companion.getSettings().devShowBBoxProperty().getValue();
                Intrinsics.checkNotNullExpressionValue(bl, "FXGL.getSettings().devShowBBox.value");
                if (bl.booleanValue()) {
                    DevService.access$addDebugView(this.this$0, entity);
                }
            }

            public void onEntityRemoved(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter(entity, "entity");
                Boolean bl = FXGL.Companion.getSettings().devShowBBoxProperty().getValue();
                Intrinsics.checkNotNullExpressionValue(bl, "FXGL.getSettings().devShowBBox.value");
                if (bl.booleanValue()) {
                    DevService.access$removeDebugView(this.this$0, entity);
                }
            }
        });
    }

    private final void addDebugView(Entity entity) {
        Group group = new Group();
        Iterable $this$forEach$iv = entity.getBoundingBoxComponent().hitBoxesProperty();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape shape;
            HitBox it = (HitBox)element$iv;
            boolean bl = false;
            BoundingShape data = it.getShape();
            if (data instanceof CircleShapeData) {
                shape = new Circle(((CircleShapeData)data).getRadius(), ((CircleShapeData)data).getRadius(), ((CircleShapeData)data).getRadius());
            } else if (data instanceof BoxShapeData) {
                Rectangle bboxView = new Rectangle();
                bboxView.widthProperty().setValue(((BoxShapeData)data).getWidth());
                bboxView.heightProperty().setValue(((BoxShapeData)data).getHeight());
                bboxView.visibleProperty().bind(bboxView.widthProperty().greaterThan(0).and(bboxView.heightProperty().greaterThan(0)));
                shape = bboxView;
            } else if (data instanceof PolygonShapeData) {
                $this$flatMap$iv = ((PolygonShapeData)data).getPoints();
                $i$f$flatMap = false;
                Point2D[] point2DArray = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                var17_17 = $this$flatMapTo$iv$iv.length;
                for (var16_16 = 0; var16_16 < var17_17; ++var16_16) {
                    it = element$iv$iv = $this$flatMapTo$iv$iv[var16_16];
                    boolean bl2 = false;
                    var21_21 = new Double[]{it.getX(), it.getY()};
                    list$iv$iv = CollectionsKt.listOf(var21_21);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                var10_10 = CollectionsKt.toDoubleArray((List)destination$iv$iv);
                double[] dArray = Arrays.copyOf(var10_10, var10_10.length);
                shape = new Polygon(dArray);
            } else if (data instanceof ChainShapeData) {
                $this$flatMap$iv = ((ChainShapeData)data).getPoints();
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                $i$f$flatMapTo = false;
                var17_17 = $this$flatMapTo$iv$iv.length;
                for (var16_16 = 0; var16_16 < var17_17; ++var16_16) {
                    it = element$iv$iv = $this$flatMapTo$iv$iv[var16_16];
                    boolean bl3 = false;
                    var21_21 = new Double[]{it.getX(), it.getY()};
                    list$iv$iv = CollectionsKt.listOf(var21_21);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                var10_10 = CollectionsKt.toDoubleArray((List)destination$iv$iv);
                double[] dArray = Arrays.copyOf(var10_10, var10_10.length);
                shape = new Polyline(dArray);
            } else if (data instanceof Box3DShapeData) {
                shape = new Rectangle();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Shape shape2 = shape;
            shape2.setFill(null);
            shape2.setTranslateX(it.getMinX());
            shape2.setTranslateY(it.getMinY());
            shape2.setStrokeWidth(2.0);
            shape2.strokeProperty().bind((ObservableValue<Paint>)FXGL.Companion.getSettings().devBBoxColorProperty());
            ObservableList<Node> observableList = group.getChildren();
            Intrinsics.checkNotNullExpressionValue(observableList, "group.children");
            ((Collection)observableList).add(shape2);
        }
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue(viewComponent, "entity.viewComponent");
        ViewComponent.addChild$default(viewComponent, group, false, 2, null);
        GameView view2 = new GameView(group, Integer.MAX_VALUE);
        ((Map)this.debugViews).put(entity, view2);
    }

    private final void removeDebugView(Entity entity) {
        block0: {
            GameView gameView = this.debugViews.remove(entity);
            if (gameView == null) break block0;
            GameView view2 = gameView;
            boolean bl = false;
            entity.getViewComponent().removeChild(view2.getNode());
        }
    }

    @Override
    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkNotNullParameter(vars, "vars");
        if (!this.isDevEnabled()) {
            return;
        }
        DevPane devPane = this.devPane;
        if (devPane == null) {
            Intrinsics.throwUninitializedPropertyAccessException("devPane");
            devPane = null;
        }
        devPane.onGameReady(vars);
    }

    private static final void onMainLoopStarting$lambda$0(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    public static final /* synthetic */ void access$addDebugView(DevService $this, Entity entity) {
        $this.addDebugView(entity);
    }

    public static final /* synthetic */ void access$removeDebugView(DevService $this, Entity entity) {
        $this.removeDebugView(entity);
    }

    public static final /* synthetic */ Console access$getConsole(DevService $this) {
        return $this.getConsole();
    }
}

