/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.dev;

import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.time.Timer;
import com.almasb.fxgl.ui.FXGLCheckBox;
import com.almasb.fxgl.ui.InGamePanel;
import com.almasb.fxgl.ui.UIFactoryService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.IntegerExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import javafx.util.StringConverter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rJ\u0006\u0010 \u001a\u00020\u001eJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020$H\u0002J\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u001eJ\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lcom/almasb/fxgl/dev/DevPane;", "", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Lcom/almasb/fxgl/scene/SceneService;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "accordion", "Ljavafx/scene/control/Accordion;", "debugMessagesBox", "Ljavafx/scene/layout/VBox;", "debugPoints", "Ljava/util/HashMap;", "Ljavafx/geometry/Point2D;", "Ljavafx/scene/Node;", "Lkotlin/collections/HashMap;", "entities", "Ljavafx/collections/ObservableList;", "Lcom/almasb/fxgl/entity/Entity;", "kotlin.jvm.PlatformType", "isOpen", "", "()Z", "log", "Lcom/almasb/fxgl/logging/Logger;", "panel", "Lcom/almasb/fxgl/ui/InGamePanel;", "getSettings", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "addDebugPoint", "", "p", "close", "createContentDevVars", "Ljavafx/scene/layout/Pane;", "createContentEntities", "Ljavafx/scene/Parent;", "createContentGameVars", "onGameReady", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "open", "pushMessage", "message", "", "removeDebugPoint", "fxgl"})
@SourceDebugExtension(value={"SMAP\nDevPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevPane.kt\ncom/almasb/fxgl/dev/DevPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,349:1\n1#2:350\n3792#3:351\n4307#3,2:352\n1045#4:354\n1864#4,3:355\n1864#4,3:358\n*S KotlinDebug\n*F\n+ 1 DevPane.kt\ncom/almasb/fxgl/dev/DevPane\n*L\n127#1:351\n127#1:352,2\n128#1:354\n129#1:355,3\n170#1:358,3\n*E\n"})
public final class DevPane {
    @NotNull
    private final SceneService sceneService;
    @NotNull
    private final ReadOnlyGameSettings settings;
    @NotNull
    private final Logger log;
    @NotNull
    private final InGamePanel panel;
    @NotNull
    private final VBox debugMessagesBox;
    private final ObservableList<Entity> entities;
    @NotNull
    private final Accordion accordion;
    @NotNull
    private final HashMap<Point2D, Node> debugPoints;

    public DevPane(@NotNull SceneService sceneService, @NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkNotNullParameter(sceneService, "sceneService");
        Intrinsics.checkNotNullParameter(settings, "settings");
        this.sceneService = sceneService;
        this.settings = settings;
        this.log = Logger.Companion.get(this.getClass());
        this.panel = new InGamePanel(350.0, this.sceneService.getPrefHeight(), null, 4, null);
        this.debugMessagesBox = new VBox(5.0);
        this.entities = FXCollections.observableArrayList();
        this.panel.getStyleClass().add("dev-pane");
        TitledPane[] titledPaneArray = new TitledPane[]{new TitledPane("Dev vars", this.createContentDevVars())};
        this.accordion = new Accordion(titledPaneArray);
        this.accordion.setPrefWidth(340.0);
        ScrollPane scroll = new ScrollPane(this.accordion);
        scroll.setPrefSize(350.0, this.sceneService.getPrefHeight());
        ObservableList<Node> observableList = this.panel.getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "panel.children");
        ((Collection)observableList).add(scroll);
        this.debugMessagesBox.setMouseTransparent(true);
        Object[] objectArray = new BackgroundFill[]{new BackgroundFill(Color.color(0.7, 0.6, 0.7, 0.6), null, null)};
        this.debugMessagesBox.setBackground(new Background((BackgroundFill[])objectArray));
        objectArray = new Node[]{this.panel, this.debugMessagesBox};
        this.sceneService.getOverlayRoot().getChildren().addAll((Node[])objectArray);
        this.debugPoints = new HashMap();
    }

    @NotNull
    public final ReadOnlyGameSettings getSettings() {
        return this.settings;
    }

    public final boolean isOpen() {
        return this.panel.isOpen();
    }

    public final void addDebugPoint(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Circle n = new Circle(0.0, 0.0, 5.0, Color.color(0.0, 0.0, 1.0, 0.15));
        n.setStroke(Color.RED);
        Node[] nodeArray = new Node[]{n, new Text(p.getX() + ", " + p.getY())};
        VBox group = new VBox(nodeArray);
        group.setAlignment(Pos.TOP_LEFT);
        group.setTranslateX(p.getX() - n.getRadius());
        group.setTranslateY(p.getY() - n.getRadius());
        ObservableList<Node> observableList = this.sceneService.getOverlayRoot().getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "sceneService.overlayRoot.children");
        ((Collection)observableList).add(group);
        ((Map)this.debugPoints).put(p, group);
    }

    public final void removeDebugPoint(@NotNull Point2D p) {
        block0: {
            Intrinsics.checkNotNullParameter(p, "p");
            Node node = this.debugPoints.remove(p);
            if (node == null) break block0;
            Node it = node;
            boolean bl = false;
            ObservableList<Node> observableList = this.sceneService.getOverlayRoot().getChildren();
            Intrinsics.checkNotNullExpressionValue(observableList, "sceneService.overlayRoot.children");
            ((Collection)observableList).remove(it);
        }
    }

    public final void pushMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        this.log.debug(message2);
        Text text = new Text(message2);
        text.setFont(Font.font(18.0));
        text.setFill(Color.BLACK);
        text.setStroke(Color.BLACK);
        ObservableList<Node> observableList = this.debugMessagesBox.getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "debugMessagesBox.children");
        ((Collection)observableList).add(text);
        Timer timer2 = FXGL.Companion.getEngineTimer();
        Function0 function0 = new Function0<Unit>(this){
            final /* synthetic */ DevPane this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DevPane.access$getDebugMessagesBox$p(this.this$0).getChildren().remove(0);
            }
        };
        Duration duration = Duration.seconds(5.0);
        Intrinsics.checkNotNullExpressionValue(duration, "seconds(5.0)");
        timer2.runOnceAfter(function0, duration);
    }

    /*
     * WARNING - void declaration
     */
    private final Pane createContentDevVars() {
        int n;
        void $this$filterTo$iv$iv;
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(15.0));
        vbox.setAlignment(Pos.TOP_CENTER);
        GridPane pane = new GridPane();
        pane.setHgap(25.0);
        pane.setVgap(10.0);
        Method[] methodArray = this.settings.getClass().getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "settings.javaClass.declaredMethods");
        Object[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void element$iv$iv = $this$filterTo$iv$iv[n];
            Method it = (Method)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue(string, "it.name");
            if (!StringsKt.startsWith$default(string, "dev", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Method it = (Method)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Method)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Node[] nodeArray;
            Text text;
            void method;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Method method2 = (Method)item$iv;
            int index = n;
            boolean bl = false;
            Class<?> clazz = method.getReturnType();
            if (Intrinsics.areEqual(clazz, SimpleBooleanProperty.class)) {
                text = FXGL.Companion.getUIFactoryService().newText(method.getName(), Color.WHITE, 18.0);
                FXGLCheckBox checkBox = new FXGLCheckBox();
                BooleanProperty booleanProperty = checkBox.selectedProperty();
                Object object = method.invoke((Object)this.settings, new Object[0]);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type javafx.beans.property.SimpleBooleanProperty");
                booleanProperty.bindBidirectional((SimpleBooleanProperty)object);
                nodeArray = new Node[]{text, checkBox};
                pane.addRow(index, nodeArray);
                continue;
            }
            if (!Intrinsics.areEqual(clazz, SimpleObjectProperty.class)) continue;
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue(string, "method.name");
            String string2 = string.toLowerCase();
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase()");
            if (!StringsKt.contains$default((CharSequence)string2, "color", false, 2, null)) continue;
            text = FXGL.Companion.getUIFactoryService().newText(method.getName(), Color.WHITE, 18.0);
            ColorPicker colorPicker = new ColorPicker();
            ObjectProperty objectProperty = colorPicker.valueProperty();
            Object object = method.invoke((Object)this.settings, new Object[0]);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type javafx.beans.property.SimpleObjectProperty<javafx.scene.paint.Color>");
            objectProperty.bindBidirectional((SimpleObjectProperty)object);
            nodeArray = new Node[]{text, colorPicker};
            pane.addRow(index, nodeArray);
        }
        vbox.getChildren().add(pane);
        return vbox;
    }

    /*
     * WARNING - void declaration
     */
    private final Parent createContentGameVars() {
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(15.0));
        vbox.setAlignment(Pos.TOP_CENTER);
        GridPane pane = new GridPane();
        pane.setHgap(25.0);
        pane.setVgap(10.0);
        Iterable $this$forEachIndexed$iv = FXGL.Companion.getWorldProperties().keys();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void key;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            Text textKey = FXGL.Companion.getUIFactoryService().newText((String)key, Color.WHITE, 18.0);
            Object value = FXGL.Companion.getWorldProperties().getValueObservable((String)key);
            Text textValue = FXGL.Companion.getUIFactoryService().newText("", Color.WHITE, 18.0);
            Node[] nodeArray = value.getClass();
            if (Intrinsics.areEqual(nodeArray, SimpleBooleanProperty.class)) {
                StringProperty stringProperty = textValue.textProperty();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type javafx.beans.property.SimpleBooleanProperty");
                stringProperty.bind(((SimpleBooleanProperty)value).asString());
            } else if (Intrinsics.areEqual(nodeArray, SimpleIntegerProperty.class)) {
                StringProperty stringProperty = textValue.textProperty();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type javafx.beans.property.SimpleIntegerProperty");
                stringProperty.bind(((SimpleIntegerProperty)value).asString());
            } else if (Intrinsics.areEqual(nodeArray, SimpleDoubleProperty.class)) {
                StringProperty stringProperty = textValue.textProperty();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type javafx.beans.property.SimpleDoubleProperty");
                stringProperty.bind(((SimpleDoubleProperty)value).asString());
            } else if (Intrinsics.areEqual(nodeArray, SimpleStringProperty.class)) {
                StringProperty stringProperty = textValue.textProperty();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type javafx.beans.property.SimpleStringProperty");
                stringProperty.bind((SimpleStringProperty)value);
            } else if (Intrinsics.areEqual(nodeArray, SimpleObjectProperty.class)) {
                StringProperty stringProperty = textValue.textProperty();
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type javafx.beans.property.SimpleObjectProperty<*>");
                stringProperty.bind(((SimpleObjectProperty)value).asString());
            } else {
                throw new IllegalArgumentException("Unknown value type: " + value.getClass());
            }
            nodeArray = new Node[]{textKey, textValue};
            pane.addRow(index, nodeArray);
        }
        vbox.getChildren().add(pane);
        return vbox;
    }

    private final Parent createContentEntities() {
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(15.0));
        vbox.setAlignment(Pos.TOP_LEFT);
        FXGLForKtKt.getGameWorld().addWorldListener(new EntityWorldListener(this){
            final /* synthetic */ DevPane this$0;
            {
                this.this$0 = $receiver;
            }

            public void onEntityAdded(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter(entity, "entity");
                ObservableList observableList = DevPane.access$getEntities$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(observableList, "entities");
                ((Collection)observableList).add(entity);
            }

            public void onEntityRemoved(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter(entity, "entity");
                ObservableList observableList = DevPane.access$getEntities$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(observableList, "entities");
                ((Collection)observableList).remove(entity);
            }
        });
        this.entities.addAll((Collection<Entity>)FXGLForKtKt.getGameWorld().getEntities());
        VBox innerBox = new VBox(5.0);
        innerBox.setPadding(new Insets(15.0));
        innerBox.setAlignment(Pos.TOP_LEFT);
        ChoiceBox<Entity> choiceBox = new ChoiceBox<Entity>(this.entities);
        choiceBox.setConverter(new StringConverter<Entity>(){

            @NotNull
            public Entity fromString(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "string");
                throw new AssertionError((Object)"Not supposed to be called");
            }

            @NotNull
            public String toString(@NotNull Entity entity) {
                Intrinsics.checkNotNullParameter(entity, "entity");
                return entity.getType().toString();
            }
        });
        choiceBox.setPrefWidth(260.0);
        Rectangle highlight = new Rectangle(0.0, 0.0, null);
        highlight.setStrokeWidth(3.0);
        highlight.setStroke(Color.LIGHTGOLDENRODYELLOW);
        choiceBox.getSelectionModel().selectedItemProperty().addListener((arg_0, arg_1, arg_2) -> DevPane.createContentEntities$lambda$5(new Function3<ObservableValue<? extends Entity>, Entity, Entity, Unit>(highlight, innerBox){
            final /* synthetic */ Rectangle $highlight;
            final /* synthetic */ VBox $innerBox;
            {
                this.$highlight = $highlight;
                this.$innerBox = $innerBox;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ObservableValue<? extends Entity> observableValue, Entity old, Entity entity) {
                block16: {
                    void $this$forEach$iv;
                    Node node;
                    Entity entity2;
                    Entity entity3 = old;
                    if (entity3 != null) {
                        entity2 = entity3;
                        node = this.$highlight;
                        Entity it = entity2;
                        boolean bl = false;
                        it.getViewComponent().removeChild(node);
                    }
                    Entity entity4 = entity;
                    if (entity4 == null) break block16;
                    entity2 = entity4;
                    node = this.$innerBox;
                    Rectangle rectangle = this.$highlight;
                    Entity it = entity2;
                    boolean bl = false;
                    ((Pane)node).getChildren().clear();
                    rectangle.setWidth(it.getWidth());
                    rectangle.setHeight(it.getHeight());
                    ViewComponent viewComponent = it.getViewComponent();
                    Intrinsics.checkNotNullExpressionValue(viewComponent, "it.viewComponent");
                    ViewComponent.addChild$default(viewComponent, rectangle, false, 2, null);
                    List<Component> list = it.getComponents();
                    Intrinsics.checkNotNullExpressionValue(list, "it.components");
                    Iterable $this$sortedBy$iv = list;
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                        public final int compare(T a, T b) {
                            Component it = (Component)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getClass().getSimpleName());
                            it = (Component)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getClass().getSimpleName()));
                        }
                    });
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        void $this$forEach$iv2;
                        Iterable $this$sortedBy$iv2;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Component comp = (Component)element$iv;
                        boolean bl2 = false;
                        GridPane pane = new GridPane();
                        pane.setHgap(25.0);
                        pane.setVgap(10.0);
                        int index = 0;
                        UIFactoryService uIFactoryService = FXGL.Companion.getUIFactoryService();
                        String string = comp.getClass().getSimpleName();
                        Intrinsics.checkNotNullExpressionValue(string, "comp.javaClass.simpleName");
                        Text title = uIFactoryService.newText(StringsKt.removeSuffix(string, (CharSequence)"Component"), Color.ANTIQUEWHITE, 22.0);
                        int n = index;
                        index = n + 1;
                        Node[] nodeArray = new Node[]{title};
                        pane.addRow(n, nodeArray);
                        int n2 = index;
                        index = n2 + 1;
                        Object[] objectArray = new Node[]{new Rectangle(165.0, 2.0, Color.ANTIQUEWHITE)};
                        pane.addRow(n2, (Node[])objectArray);
                        Method[] methodArray = comp.getClass().getMethods();
                        Intrinsics.checkNotNullExpressionValue(methodArray, "comp.javaClass.methods");
                        objectArray = methodArray;
                        boolean $i$f$filter = false;
                        Iterator<T> iterator2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (void element$iv$iv : $this$filterTo$iv$iv) {
                            Method it2 = (Method)element$iv$iv;
                            boolean bl3 = false;
                            String string2 = it2.getName();
                            Intrinsics.checkNotNullExpressionValue(string2, "it.name");
                            if (!StringsKt.endsWith$default(string2, "Property", false, 2, null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$sortedBy2 = false;
                        $this$sortedBy$iv2 = CollectionsKt.sortedWith($this$sortedBy$iv2, new Comparator(){

                            public final int compare(T a, T b) {
                                Method it = (Method)a;
                                boolean bl = false;
                                Comparable comparable = (Comparable)((Object)it.getName());
                                it = (Method)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                            }
                        });
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            Node[] nodeArray2;
                            Method method = (Method)element$iv2;
                            boolean bl4 = false;
                            UIFactoryService uIFactoryService2 = FXGL.Companion.getUIFactoryService();
                            String string3 = method.getName();
                            Intrinsics.checkNotNullExpressionValue(string3, "method.name");
                            Text textKey = uIFactoryService2.newText(StringsKt.removeSuffix(string3, (CharSequence)"Property"), Color.WHITE, 18.0);
                            Object value = method.invoke((Object)comp, new Object[0]);
                            Text textValue = FXGL.Companion.getUIFactoryService().newText("", Color.WHITE, 18.0);
                            Object object = value;
                            if (object instanceof BooleanExpression) {
                                textValue.textProperty().bind(((BooleanExpression)value).asString());
                            } else if (object instanceof IntegerExpression) {
                                textValue.textProperty().bind(((IntegerExpression)value).asString());
                            } else if (object instanceof DoubleExpression) {
                                textValue.textProperty().bind(((DoubleExpression)value).asString("%.2f"));
                            } else if (object instanceof StringExpression) {
                                textValue.textProperty().bind((ObservableValue)value);
                            } else if (object instanceof ObjectExpression) {
                                textValue.textProperty().bind(((ObjectExpression)value).asString());
                            } else if (!(object instanceof ObservableList)) {
                                throw new IllegalArgumentException("Unknown value type: " + value.getClass());
                            }
                            if (value instanceof ObservableList) {
                                int n3 = index;
                                index = n3 + 1;
                                nodeArray2 = new Node[]{textKey, new ListView<T>((ObservableList)value)};
                                pane.addRow(n3, nodeArray2);
                                continue;
                            }
                            int n4 = index;
                            index = n4 + 1;
                            nodeArray2 = new Node[]{textKey, textValue};
                            pane.addRow(n4, nodeArray2);
                        }
                        int n5 = index;
                        index = n5 + 1;
                        Node[] nodeArray3 = new Node[]{new Text("")};
                        pane.addRow(n5, nodeArray3);
                        ObservableList<Node> observableList = ((Pane)node).getChildren();
                        Intrinsics.checkNotNullExpressionValue(observableList, "innerBox.children");
                        ((Collection)observableList).add(pane);
                    }
                }
            }
        }, arg_0, arg_1, arg_2));
        ObservableList<Entity> observableList = this.entities;
        Intrinsics.checkNotNullExpressionValue(observableList, "entities");
        if (!((Collection)observableList).isEmpty()) {
            choiceBox.getSelectionModel().selectFirst();
        }
        Node[] nodeArray = new Node[]{choiceBox, innerBox};
        vbox.getChildren().addAll((Node[])nodeArray);
        return vbox;
    }

    public final void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkNotNullParameter(vars, "vars");
    }

    public final void open() {
        this.panel.open();
    }

    public final void close() {
        this.panel.close();
    }

    private static final void createContentEntities$lambda$5(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    public static final /* synthetic */ VBox access$getDebugMessagesBox$p(DevPane $this) {
        return $this.debugMessagesBox;
    }

    public static final /* synthetic */ ObservableList access$getEntities$p(DevPane $this) {
        return $this.entities;
    }
}

