/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.cutscene.dialogue;

import com.almasb.fxgl.cutscene.dialogue.BranchNode;
import com.almasb.fxgl.cutscene.dialogue.DialogueEdge;
import com.almasb.fxgl.cutscene.dialogue.DialogueGraph;
import com.almasb.fxgl.cutscene.dialogue.DialogueNode;
import com.almasb.fxgl.cutscene.dialogue.DialogueNodeType;
import com.almasb.fxgl.cutscene.dialogue.FunctionNode;
import com.almasb.fxgl.cutscene.dialogue.Option;
import com.almasb.fxgl.cutscene.dialogue.SerializableEdge;
import com.almasb.fxgl.cutscene.dialogue.SerializableFunctionNode;
import com.almasb.fxgl.cutscene.dialogue.SerializableGraph;
import com.almasb.fxgl.cutscene.dialogue.SerializableOption;
import com.almasb.fxgl.cutscene.dialogue.SerializableTextNode;
import com.almasb.fxgl.cutscene.dialogue.SubDialogueNode;
import com.almasb.fxgl.cutscene.dialogue.TextNode;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000e0\f*\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/cutscene/dialogue/DialogueGraphSerializer;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fromSerializable", "Lcom/almasb/fxgl/cutscene/dialogue/DialogueGraph;", "sGraph", "Lcom/almasb/fxgl/cutscene/dialogue/SerializableGraph;", "toSerializable", "graph", "toDeserializable", "", "Lcom/almasb/fxgl/cutscene/dialogue/Option;", "Lcom/almasb/fxgl/cutscene/dialogue/SerializableOption;", "fxgl-gameplay"})
@SourceDebugExtension(value={"SMAP\nSerializableDialogueGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializableDialogueGraph.kt\ncom/almasb/fxgl/cutscene/dialogue/DialogueGraphSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,205:1\n483#2,7:206\n442#2:213\n392#2:214\n483#2,7:219\n442#2:226\n392#2:227\n1238#3,2:215\n1241#3:218\n1238#3,4:228\n1549#3:232\n1620#3,3:233\n1549#3:236\n1620#3,3:237\n1549#3:240\n1620#3,3:241\n1855#3,2:248\n1#4:217\n215#5,2:244\n215#5,2:246\n*S KotlinDebug\n*F\n+ 1 SerializableDialogueGraph.kt\ncom/almasb/fxgl/cutscene/dialogue/DialogueGraphSerializer\n*L\n135#1:206,7\n136#1:213\n136#1:214\n143#1:219,7\n144#1:226\n144#1:227\n136#1:215,2\n136#1:218\n144#1:228,4\n151#1:232\n151#1:233,3\n157#1:236\n157#1:237,3\n161#1:240\n161#1:241,3\n194#1:248,2\n172#1:244,2\n185#1:246,2\n*E\n"})
public final class DialogueGraphSerializer {
    @NotNull
    public static final DialogueGraphSerializer INSTANCE = new DialogueGraphSerializer();
    @NotNull
    private static final Logger log = Logger.Companion.get(INSTANCE.getClass());

    private DialogueGraphSerializer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SerializableGraph toSerializable(@NotNull DialogueGraph graph) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map $this$filterValues$iv;
        Object object;
        Object object2;
        Object k;
        Object object3;
        void $this$mapValuesTo$iv$iv2;
        Intrinsics.checkNotNullParameter(graph, "graph");
        ObservableMap<Integer, DialogueNode> observableMap = graph.getNodes();
        Intrinsics.checkNotNullExpressionValue(observableMap, "graph.nodes");
        Map $this$filterValues$iv2 = observableMap;
        boolean $i$f$filterValues = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv2.entrySet()) {
            DialogueNode it = (DialogueNode)entry$iv.getValue();
            boolean bl = false;
            if (!(it.getType() == DialogueNodeType.TEXT || it.getType() == DialogueNodeType.BRANCH)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapValues$iv2 = result$iv;
        boolean $i$f$mapValues22 = false;
        result$iv = $this$mapValues$iv2;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            SerializableTextNode serializableTextNode;
            List<SerializableOption> list;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = object3;
            boolean bl2 = false;
            DialogueNode n = (DialogueNode)entry2.getValue();
            if (n instanceof TextNode) {
                ObservableList<Option> observableList = ((TextNode)n).getOptions();
                Intrinsics.checkNotNullExpressionValue(observableList, "n.options");
                list = INSTANCE.toSerializable((List<Option>)observableList);
            } else {
                list = CollectionsKt.emptyList();
            }
            List<SerializableOption> options = list;
            SerializableTextNode it = serializableTextNode = new SerializableTextNode(n.getType(), n.getText(), options);
            boolean bl3 = false;
            it.setAudio(n.getAudioFileName());
            object = serializableTextNode;
            object2.put(k, object);
        }
        Map textNodes = destination$iv$iv;
        ObservableMap<Integer, DialogueNode> observableMap2 = graph.getNodes();
        Intrinsics.checkNotNullExpressionValue(observableMap2, "graph.nodes");
        Map $i$f$mapValues22 = observableMap2;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            DialogueNode it = (DialogueNode)entry$iv.getValue();
            boolean bl = false;
            if (!(it.getType() == DialogueNodeType.FUNCTION)) continue;
            result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv2;
        boolean $i$f$mapValues32 = false;
        result$iv2 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            SerializableFunctionNode serializableFunctionNode;
            void it$iv$iv;
            object3 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = map;
            boolean bl4 = false;
            DialogueNode n = (DialogueNode)entry.getValue();
            Intrinsics.checkNotNull(n, "null cannot be cast to non-null type com.almasb.fxgl.cutscene.dialogue.FunctionNode");
            FunctionNode node = (FunctionNode)n;
            SerializableFunctionNode it = serializableFunctionNode = new SerializableFunctionNode(n.getType(), n.getText(), node.getNumTimes());
            boolean bl5 = false;
            it.setAudio(n.getAudioFileName());
            object = serializableFunctionNode;
            object2.put(k, object);
        }
        Map functionNodes = destination$iv$iv2;
        ObservableList<DialogueEdge> observableList = graph.getEdges();
        Intrinsics.checkNotNullExpressionValue(observableList, "graph.edges");
        Iterable $i$f$mapValues32 = observableList;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (DialogueEdge)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            object2.add(new SerializableEdge(graph.findNodeID(it.getSource()), it.getOptionID(), graph.findNodeID(it.getTarget())));
        }
        List edges = (List)destination$iv$iv3;
        return new SerializableGraph(graph.getUniqueID$fxgl_gameplay(), graph.getStartNodeID(), textNodes, functionNodes, edges);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SerializableOption> toSerializable(List<Option> $this$toSerializable) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toSerializable;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Option option = (Option)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SerializableOption(it.getId(), it.getText(), it.getCondition()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Option> toDeserializable(List<SerializableOption> $this$toDeserializable) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toDeserializable;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializableOption serializableOption = (SerializableOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Option(it.getId(), it.getText(), it.getCondition()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DialogueGraph fromSerializable(@NotNull SerializableGraph sGraph) {
        Object n;
        int id;
        Map.Entry<Integer, SerializableTextNode> entry;
        Map.Entry<Integer, Object> element$iv;
        Intrinsics.checkNotNullParameter(sGraph, "sGraph");
        if (sGraph.getVersion() != 3) {
            log.warning("Deserializing graph with version=" + sGraph.getVersion() + ". Supported version: 3");
        }
        DialogueGraph graph = new DialogueGraph(sGraph.getUniqueID());
        graph.setStartNodeID(sGraph.getStartNodeID());
        Object $this$forEach$iv = sGraph.getTextNodes();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            id = ((Number)entry.getKey()).intValue();
            n = entry.getValue();
            DialogueNode node = switch (WhenMappings.$EnumSwitchMapping$0[((SerializableTextNode)n).getType().ordinal()]) {
                case 1 -> {
                    TextNode var11_12;
                    TextNode it = var11_12 = new TextNode(((SerializableTextNode)n).getText());
                    boolean $i$a$-also-DialogueGraphSerializer$fromSerializable$1$node$1 = false;
                    it.getOptions().setAll((Collection<Option>)INSTANCE.toDeserializable(((SerializableTextNode)n).getOptions()));
                    yield var11_12;
                }
                case 2 -> new BranchNode(((SerializableTextNode)n).getText());
                case 3 -> new SubDialogueNode(((SerializableTextNode)n).getText());
                default -> throw new IllegalArgumentException("Unknown node type: " + ((SerializableTextNode)n).getType());
            };
            node.getAudioFileNameProperty().setValue(((SerializableTextNode)n).getAudio());
            ObservableMap<Integer, DialogueNode> observableMap = graph.getNodes();
            Intrinsics.checkNotNullExpressionValue(observableMap, "graph.nodes");
            Map map = observableMap;
            map.put(id, node);
        }
        $this$forEach$iv = sGraph.getFunctionNodes();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            id = ((Number)entry.getKey()).intValue();
            n = (SerializableFunctionNode)((Object)entry.getValue());
            FunctionNode node = new FunctionNode(((SerializableFunctionNode)n).getText());
            node.getNumTimesProperty().setValue(((SerializableFunctionNode)n).getNumTimes());
            node.getAudioFileNameProperty().setValue(((SerializableFunctionNode)n).getAudio());
            ObservableMap<Integer, DialogueNode> observableMap = graph.getNodes();
            Intrinsics.checkNotNullExpressionValue(observableMap, "graph.nodes");
            Map map = observableMap;
            map.put(id, node);
        }
        $this$forEach$iv = sGraph.getEdges();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            SerializableEdge it = (SerializableEdge)((Object)element$iv);
            boolean bl = false;
            DialogueNode source = graph.getNodeByID(it.getSourceID());
            DialogueNode target = graph.getNodeByID(it.getTargetID());
            graph.addEdge(source, it.getOptionID(), target);
        }
        return graph;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DialogueNodeType.values().length];
            try {
                nArray[DialogueNodeType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DialogueNodeType.BRANCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DialogueNodeType.SUBDIALOGUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

