/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.cutscene;

import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.view.KeyView;
import com.almasb.fxgl.scene.SceneService;
import com.almasb.fxgl.scene.SubScene;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/cutscene/VideoScene;", "Lcom/almasb/fxgl/scene/SubScene;", "sceneService", "Lcom/almasb/fxgl/scene/SceneService;", "(Lcom/almasb/fxgl/scene/SceneService;)V", "onFinished", "Ljava/lang/Runnable;", "video", "Ljavafx/scene/media/MediaView;", "endScene", "", "start", "fxgl-gameplay"})
public final class VideoScene
extends SubScene {
    @NotNull
    private final SceneService sceneService;
    private MediaView video;
    private Runnable onFinished;

    public VideoScene(@NotNull SceneService sceneService) {
        Intrinsics.checkNotNullParameter(sceneService, "sceneService");
        this.sceneService = sceneService;
        Input.addAction$default(this.getInput(), new UserAction(){

            @Override
            protected void onActionBegin() {
                this.endScene();
            }
        }, KeyCode.ENTER, null, 4, null);
        Color color = Color.GREENYELLOW;
        Intrinsics.checkNotNullExpressionValue(color, "GREENYELLOW");
        KeyView keyView = new KeyView(KeyCode.ENTER, color, 18.0);
        keyView.setTranslateX(this.sceneService.getPrefWidth() - 80.0);
        keyView.setTranslateY(this.sceneService.getPrefHeight() - 40.0);
        ObservableList<Node> observableList = this.getContentRoot().getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "contentRoot.children");
        ((Collection)observableList).add(keyView);
    }

    private final void endScene() {
        this.getContentRoot().getChildren().remove(0);
        MediaView mediaView = this.video;
        if (mediaView == null) {
            Intrinsics.throwUninitializedPropertyAccessException("video");
            mediaView = null;
        }
        mediaView.getMediaPlayer().stop();
        this.sceneService.popSubScene();
        Runnable runnable = this.onFinished;
        if (runnable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("onFinished");
            runnable = null;
        }
        runnable.run();
    }

    public final void start(@NotNull MediaView video, @NotNull Runnable onFinished) {
        Intrinsics.checkNotNullParameter(video, "video");
        Intrinsics.checkNotNullParameter(onFinished, "onFinished");
        this.video = video;
        this.onFinished = onFinished;
        video.getMediaPlayer().play();
        video.getMediaPlayer().setOnEndOfMedia(() -> VideoScene.start$lambda$0(this));
        this.getContentRoot().getChildren().add(0, video);
        this.sceneService.pushSubScene(this);
    }

    private static final void start$lambda$0(VideoScene this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.endScene();
    }
}

