/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.reflect;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.reflect.ReflectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Method getMethod(Class<?> instanceClass, String methodName, Class<?> ... paramTypes) {
        try {
            return instanceClass.getDeclaredMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot get declared method <" + methodName + ">", e);
        }
    }

    public static <A extends Annotation> Map<A, Method> findMethods(Object instance, Class<A> annotationClass) {
        HashMap<A, Method> map = new HashMap<A, Method>();
        for (Method method : instance.getClass().getDeclaredMethods()) {
            A annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            map.put(annotation, method);
        }
        return map;
    }

    public static <T, R, A extends Annotation> Map<A, Function<T, R>> findMethodsMapToFunctions(Object instance, Class<A> annotationClass) {
        HashMap map = new HashMap();
        ReflectionUtils.findMethods(instance, annotationClass).forEach((annotation, method) -> map.put(annotation, ReflectionUtils.mapToFunction(instance, method)));
        return map;
    }

    public static <T, R, F extends Function<T, R>, A extends Annotation> Map<A, F> findMethodsMapToFunctions(Object instance, Class<A> annotationClass, Class<F> functionClass) {
        HashMap map = new HashMap();
        ReflectionUtils.findMethods(instance, annotationClass).forEach((annotation, method) -> {
            method.setAccessible(true);
            Function function = (Function)Proxy.newProxyInstance(functionClass.getClassLoader(), new Class[]{functionClass}, (proxy, proxyMethod, args2) -> method.invoke(instance, args2));
            map.put(annotation, function);
        });
        return map;
    }

    public static <T> T callInaccessible(Object instance, Method method, Object ... args2) {
        method.setAccessible(true);
        return ReflectionUtils.call(instance, method, args2);
    }

    public static <T> T call(Object instance, Method method, Object ... args2) {
        try {
            return (T)method.invoke(instance, args2);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot call " + method.getName() + " Error: " + String.valueOf(e), e);
        }
    }

    public static <T, R> Function<T, R> mapToFunction(Object instance, Method method) {
        return input -> ReflectionUtils.call(instance, method, input);
    }

    public static <A extends Annotation> Array<Field> findFieldsByAnnotation(Object instance, Class<A> annotationClass) {
        Array<Field> fields = new Array<Field>();
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (field.getAnnotation(annotationClass) == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Array<Field> findDeclaredFieldsByType(Object instance, Class<?> type) {
        Array<Field> fields = new Array<Field>();
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    public static Array<Field> findFieldsByTypeRecursive(Object instance, Class<?> type) {
        Array<Field> fields = new Array<Field>();
        for (Field field : ReflectionUtils.getAllFieldsRecursive(instance)) {
            if (!type.isAssignableFrom(field.getType())) continue;
            fields.add(field);
        }
        return fields;
    }

    private static Array<Field> getAllFieldsRecursive(Object instance) {
        Array<Field> result = new Array<Field>();
        for (Class<?> typeClass = instance.getClass(); typeClass != null && typeClass != Object.class; typeClass = typeClass.getSuperclass()) {
            result.addAll((Field[])typeClass.getDeclaredFields());
        }
        return result;
    }

    public static Optional<Field> getDeclaredField(String fieldName, Object instance) {
        try {
            return Optional.of(instance.getClass().getDeclaredField(fieldName));
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot get declared field: " + fieldName + " of " + String.valueOf(instance) + " Error: " + String.valueOf(e));
        }
    }

    public static void inject(Field field, Object instance, Object injectionInstance) {
        try {
            field.trySetAccessible();
            field.set(instance, injectionInstance);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot inject " + String.valueOf(injectionInstance) + " into " + field.getName() + " Error: " + String.valueOf(e));
        }
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable cause;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    public static <T> Class<? extends T> getCallingClass(Class<T> callerSupertype, String callingMethodName) {
        try {
            StackTraceElement[] cause = Thread.currentThread().getStackTrace();
            boolean foundThisMethod = false;
            String callingClassName = null;
            for (StackTraceElement se : cause) {
                String className = se.getClassName();
                String methodName = se.getMethodName();
                if (foundThisMethod) {
                    callingClassName = className;
                    break;
                }
                if (!callerSupertype.getName().equals(className) || !callingMethodName.equals(methodName)) continue;
                foundThisMethod = true;
            }
            if (callingClassName == null) {
                throw new ReflectionException("Error: unable to determine calling class name");
            }
            Class<?> theClass = Class.forName(callingClassName, false, Thread.currentThread().getContextClassLoader());
            if (!callerSupertype.isAssignableFrom(theClass)) {
                throw new ReflectionException("Error: " + String.valueOf(theClass) + " is not a subclass of " + String.valueOf(callerSupertype));
            }
            return theClass;
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static Class<?> convertToPrimitive(Class<?> type) {
        Map<Class<Character>, Class<Character>> wrappersToPrimitives = Map.of(Integer.class, Integer.TYPE, Double.class, Double.TYPE, Boolean.class, Boolean.TYPE, Character.class, Character.TYPE);
        return wrappersToPrimitives.getOrDefault(type, type);
    }
}

