/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.pool.Poolable;
import java.io.Serializable;
import javafx.geometry.Point2D;

public final class Vec2
implements Serializable,
Poolable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vec2() {
        this(0.0f, 0.0f);
    }

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2(double x, double y) {
        this((float)x, (float)y);
    }

    public Vec2(Vec2 toCopy) {
        this(toCopy.x, toCopy.y);
    }

    public Vec2(Point2D toCopy) {
        this(toCopy.getX(), toCopy.getY());
    }

    public void setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vec2 set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vec2 set(Vec2 v) {
        this.x = v.x;
        this.y = v.y;
        return this;
    }

    public Vec2 set(Point2D vector) {
        this.x = (float)vector.getX();
        this.y = (float)vector.getY();
        return this;
    }

    public Vec2 setFromAngle(double degrees) {
        this.x = (float)FXGLMath.cosDeg(degrees);
        this.y = (float)FXGLMath.sinDeg(degrees);
        return this;
    }

    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public Vec2 add(Point2D vector) {
        return this.add(vector.getX(), vector.getY());
    }

    public Vec2 add(double otherX, double otherY) {
        return new Vec2((double)this.x + otherX, (double)this.y + otherY);
    }

    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    public Vec2 sub(Point2D vector) {
        return this.sub(vector.getX(), vector.getY());
    }

    public Vec2 sub(double otherX, double otherY) {
        return new Vec2((double)this.x - otherX, (double)this.y - otherY);
    }

    public Vec2 mul(double a) {
        return new Vec2((double)this.x * a, (double)this.y * a);
    }

    public Vec2 negate() {
        return new Vec2(-this.x, -this.y);
    }

    public Vec2 negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vec2 addLocal(Vec2 v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public Vec2 addLocal(double x, double y) {
        this.x = (float)((double)this.x + x);
        this.y = (float)((double)this.y + y);
        return this;
    }

    public Vec2 subLocal(Vec2 v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public Vec2 subLocal(double x, double y) {
        this.x = (float)((double)this.x - x);
        this.y = (float)((double)this.y - y);
        return this;
    }

    public Vec2 mulLocal(double a) {
        this.x = (float)((double)this.x * a);
        this.y = (float)((double)this.y * a);
        return this;
    }

    public Vec2 perpendicularCCW() {
        return new Vec2(this.y, -this.x);
    }

    public Vec2 perpendicularCW() {
        return new Vec2(-this.y, this.x);
    }

    public Vec2 setLength(double length) {
        return this.normalizeLocal().mulLocal(length);
    }

    public float length() {
        return (float)FXGLMath.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double distance(Vec2 other) {
        return this.distance(other.x, other.y);
    }

    public float distanceF(Vec2 other) {
        return FXGLMath.sqrtF(this.distanceSquared(other));
    }

    public double distance(Point2D other) {
        return this.distance(other.getX(), other.getY());
    }

    public double distance(double otherX, double otherY) {
        double dx = otherX - (double)this.x;
        double dy = otherY - (double)this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public float distanceSquared(Vec2 v) {
        float dx = this.x - v.x;
        float dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    public double distanceSquared(double otherX, double otherY) {
        double dx = otherX - (double)this.x;
        double dy = otherY - (double)this.y;
        return dx * dx + dy * dy;
    }

    public Vec2 normalize() {
        float length = this.length();
        if ((double)length < 1.1920928955078125E-7) {
            return new Vec2();
        }
        float invLength = 1.0f / length;
        return new Vec2(this.x * invLength, this.y * invLength);
    }

    public float getLengthAndNormalize() {
        float length = this.length();
        if ((double)length < 1.1920928955078125E-7) {
            return 0.0f;
        }
        float invLength = 1.0f / length;
        this.x *= invLength;
        this.y *= invLength;
        return length;
    }

    public Vec2 normalizeLocal() {
        this.getLengthAndNormalize();
        return this;
    }

    public Vec2 midpoint(Vec2 other) {
        return new Vec2(this.x + (other.x - this.x) / 2.0f, this.y + (other.y - this.y) / 2.0f);
    }

    public Vec2 midpoint(Point2D other) {
        return new Vec2((double)this.x + (other.getX() - (double)this.x) / 2.0, (double)this.y + (other.getY() - (double)this.y) / 2.0);
    }

    public Vec2 abs() {
        return new Vec2(FXGLMath.abs(this.x), FXGLMath.abs(this.y));
    }

    public Vec2 absLocal() {
        this.x = FXGLMath.abs(this.x);
        this.y = FXGLMath.abs(this.y);
        return this;
    }

    public float angle() {
        return this.angle(1.0, 0.0);
    }

    public float angle(Vec2 other) {
        return this.angle(other.x, other.y);
    }

    public float angle(Point2D other) {
        return this.angle(other.getX(), other.getY());
    }

    public float angle(double otherX, double otherY) {
        double angle1 = Math.toDegrees(Math.atan2(this.y, this.x));
        double angle2 = Math.toDegrees(Math.atan2(otherY, otherX));
        return (float)(angle1 - angle2);
    }

    public Vec2 copy() {
        return new Vec2(this.x, this.y);
    }

    public Point2D toPoint2D() {
        return new Point2D(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    @Override
    public void reset() {
        this.setZero();
    }

    public static Vec2 fromAngle(double degrees) {
        return new Vec2(FXGLMath.cosDeg((float)degrees), FXGLMath.sinDeg((float)degrees));
    }

    public static float dot(Vec2 a, Vec2 b) {
        return a.x * b.x + a.y * b.y;
    }

    public static float cross(Vec2 a, Vec2 b) {
        return a.x * b.y - a.y * b.x;
    }

    public static void crossToOutUnsafe(Vec2 in, float scale, Vec2 out) {
        out.x = scale * in.y;
        out.y = -scale * in.x;
    }

    public static void crossToOutUnsafe(float scale, Vec2 in, Vec2 out) {
        out.x = -scale * in.y;
        out.y = scale * in.x;
    }

    public static void minToOut(Vec2 a, Vec2 b, Vec2 out) {
        out.x = a.x < b.x ? a.x : b.x;
        out.y = a.y < b.y ? a.y : b.y;
    }

    public static void maxToOut(Vec2 a, Vec2 b, Vec2 out) {
        out.x = a.x > b.x ? a.x : b.x;
        out.y = a.y > b.y ? a.y : b.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vec2) {
            Vec2 other = (Vec2)obj;
            return Float.floatToIntBits(this.x) == Float.floatToIntBits(other.x) && Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
        }
        return false;
    }

    public boolean isNearlyEqualTo(Point2D p) {
        return this.isCloseTo(p, 0.1);
    }

    public boolean isCloseTo(Point2D p, double tolerance) {
        return Math.abs(this.distance(p)) <= tolerance;
    }
}

