/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.math;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import java.util.Random;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/almasb/fxgl/core/math/PerlinNoiseGenerator;", "", "seed", "", "(J)V", "NOISE_MASK", "", "NOISE_TABLE_SIZE", "gx", "", "gy", "p", "", "noise1D", "", "t", "setSeedAndReinitialize", "", "fxgl-core"})
public final class PerlinNoiseGenerator {
    private final int NOISE_TABLE_SIZE;
    private final int NOISE_MASK;
    @NotNull
    private final int[] p;
    @NotNull
    private final float[] gx;
    @NotNull
    private final float[] gy;

    public PerlinNoiseGenerator(long seed) {
        this.NOISE_TABLE_SIZE = 256;
        this.NOISE_MASK = 255;
        this.p = new int[this.NOISE_TABLE_SIZE];
        this.gx = new float[this.NOISE_TABLE_SIZE];
        this.gy = new float[this.NOISE_TABLE_SIZE];
        this.setSeedAndReinitialize(seed);
    }

    private final void setSeedAndReinitialize(long seed) {
        int i2 = 0;
        int j = 0;
        int nSwap = 0;
        Random random = FXGLMath.getRandom(seed);
        for (i2 = 0; i2 < this.NOISE_TABLE_SIZE; ++i2) {
            this.p[i2] = i2;
        }
        for (i2 = 0; i2 < this.NOISE_TABLE_SIZE; ++i2) {
            j = FXGLMath.random(1, Integer.MAX_VALUE) & this.NOISE_MASK;
            nSwap = this.p[i2];
            this.p[i2] = this.p[j];
            this.p[j] = nSwap;
        }
        int i3 = 0;
        int n = this.NOISE_TABLE_SIZE - 1;
        if (i3 <= n) {
            while (true) {
                Vec2 v = new Vec2();
                v.x = random.nextFloat() - 0.5f;
                v.y = random.nextFloat() - 0.5f;
                v.normalizeLocal();
                this.gx[i3] = v.x;
                this.gy[i3] = v.y;
                if (i3 == n) break;
                ++i3;
            }
        }
    }

    public final double noise1D(double t) {
        int qx0 = (int)Math.floor(t);
        int qx1 = qx0 + 1;
        double tx0 = t - (double)qx0;
        double tx1 = tx0 - 1.0;
        double v0 = (double)this.gx[qx0 &= this.NOISE_MASK] * tx0;
        double v1 = (double)this.gx[qx1 &= this.NOISE_MASK] * tx1;
        double wx = ((double)3 - (double)2 * tx0) * tx0 * tx0;
        return v0 - wx * (v0 - v1) + 0.5;
    }
}

