/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.fsm;

import com.almasb.fxgl.core.fsm.State;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\u001a\u0010\u001c\u001a\u00020\u00152\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150\u001eJ\b\u0010\u001f\u001a\u00020\u0015H\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR&\u0010\u000e\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0005R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/almasb/fxgl/core/fsm/StateMachine;", "S", "Lcom/almasb/fxgl/core/fsm/State;", "", "initialState", "(Lcom/almasb/fxgl/core/fsm/State;)V", "activeStates", "Ljava/util/concurrent/CopyOnWriteArrayList;", "getActiveStates", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "currentState", "getCurrentState", "()Lcom/almasb/fxgl/core/fsm/State;", "value", "parentState", "getParentState", "setParentState", "Lcom/almasb/fxgl/core/fsm/State;", "subStates", "Ljava/util/ArrayDeque;", "changeState", "", "newState", "isInHierarchy", "", "state", "(Lcom/almasb/fxgl/core/fsm/State;)Z", "popSubState", "runOnActiveStates", "action", "Lkotlin/Function1;", "updateActiveStates", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachine.kt\ncom/almasb/fxgl/core/fsm/StateMachine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1855#2,2:167\n*S KotlinDebug\n*F\n+ 1 StateMachine.kt\ncom/almasb/fxgl/core/fsm/StateMachine\n*L\n69#1:167,2\n*E\n"})
public final class StateMachine<S extends State<S>> {
    @NotNull
    private final CopyOnWriteArrayList<S> activeStates;
    @NotNull
    private final ArrayDeque<S> subStates;
    @NotNull
    private S parentState;

    public StateMachine(@NotNull S initialState) {
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        this.activeStates = new CopyOnWriteArrayList();
        this.subStates = new ArrayDeque();
        this.parentState = initialState;
        this.setParentState(initialState);
        initialState.onCreate();
        ((Collection)this.activeStates).add(this.parentState);
    }

    @NotNull
    public final CopyOnWriteArrayList<S> getActiveStates() {
        return this.activeStates;
    }

    @NotNull
    public final S getParentState() {
        return this.parentState;
    }

    private final void setParentState(S value) {
        if (!(!value.isSubState())) {
            boolean bl = false;
            String string = "Parent state " + value + " cannot be a substate";
            throw new IllegalArgumentException(string.toString());
        }
        this.parentState = value;
    }

    @NotNull
    public final S getCurrentState() {
        Object object;
        if (!((Collection)this.subStates).isEmpty()) {
            S s = this.subStates.getLast();
            Intrinsics.checkNotNullExpressionValue(s, "subStates.last");
            object = (State)s;
        } else {
            object = this.parentState;
        }
        return object;
    }

    public final boolean isInHierarchy(@NotNull S state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return state == this.parentState || this.subStates.contains(state);
    }

    public final void runOnActiveStates(@NotNull Function1<? super S, Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        Iterable $this$forEach$iv = this.activeStates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            State it = (State)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            action.invoke(it);
        }
    }

    public final void changeState(@NotNull S newState) {
        Intrinsics.checkNotNullParameter(newState, "newState");
        if (this.subStates.isEmpty()) {
            if (newState.isSubState()) {
                S prevState = this.getCurrentState();
                newState.onCreate();
                prevState.onExitingTo(newState);
                this.subStates.addLast(newState);
                newState.onEnteredFrom(this.parentState);
            } else {
                S prevState = this.getCurrentState();
                newState.onCreate();
                prevState.onExitingTo(newState);
                this.setParentState(newState);
                newState.onEnteredFrom(prevState);
                prevState.onDestroy();
            }
        } else {
            if (!newState.isSubState()) {
                return;
            }
            S prevState = this.getCurrentState();
            newState.onCreate();
            prevState.onExitingTo(newState);
            this.subStates.addLast(newState);
            newState.onEnteredFrom(prevState);
        }
        this.updateActiveStates();
    }

    public final boolean popSubState() {
        if (this.subStates.isEmpty()) {
            return false;
        }
        S prevState = this.getCurrentState();
        S newState = this.subStates.size() == 1 ? this.parentState : (State)CollectionsKt.elementAt((Iterable)this.subStates, this.subStates.size() - 2);
        Intrinsics.checkNotNullExpressionValue(newState, "newState");
        prevState.onExitingTo(newState);
        this.subStates.removeLast();
        newState.onEnteredFrom(prevState);
        prevState.onDestroy();
        this.updateActiveStates();
        return true;
    }

    private final void updateActiveStates() {
        this.activeStates.clear();
        if (this.subStates.isEmpty()) {
            ((Collection)this.activeStates).add(this.parentState);
            return;
        }
        for (State s : this.subStates.reversed()) {
            if (s.isAllowConcurrency()) {
                ((Collection)this.activeStates).add(s);
                continue;
            }
            ((Collection)this.activeStates).add(s);
            break;
        }
        if (((State)this.subStates.getFirst()).isAllowConcurrency()) {
            ((Collection)this.activeStates).add(this.parentState);
        }
        CollectionsKt.reverse((List)this.activeStates);
    }
}

