/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.concurrent;

import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.logging.Logger;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.concurrent.Task;

public abstract class IOTask<T> {
    private static final Logger log = Logger.get(IOTask.class);
    private static final String DEFAULT_NAME = "NoName";
    private final String name;
    private Consumer<T> successAction = result -> {};
    private Consumer<Throwable> failAction = e -> log.warning(this.getName() + " failed", (Throwable)e);
    private Runnable cancelAction = EmptyRunnable.INSTANCE;
    private boolean hasFailAction = false;
    private boolean isCancelled = false;

    public IOTask() {
        this(DEFAULT_NAME);
    }

    public IOTask(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean hasFailAction() {
        return this.hasFailAction;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public final IOTask<T> onSuccess(Consumer<T> successAction) {
        this.successAction = successAction;
        return this;
    }

    public final IOTask<T> onFailure(Consumer<Throwable> failAction) {
        this.hasFailAction = true;
        this.failAction = failAction;
        return this;
    }

    public final IOTask<T> onCancel(Runnable cancelAction) {
        this.cancelAction = cancelAction;
        return this;
    }

    protected abstract T onExecute() throws Exception;

    protected void throwCancelException() {
        throw new IOTaskCancelledException();
    }

    public final T run() {
        try {
            if (this.isCancelled) {
                this.throwCancelException();
            }
            T value = this.onExecute();
            this.succeed(value);
            return value;
        }
        catch (Exception e) {
            this.fail(e);
            return null;
        }
    }

    public final <R> IOTask<R> then(Function<T, IOTask<R>> mapper) {
        return IOTask.of(this.name, () -> ((IOTask)mapper.apply(this.onExecute())).onExecute());
    }

    public final <R> IOTask<R> thenWrap(Function<T, R> mapper) {
        return this.then(t -> IOTask.of(() -> mapper.apply(t)));
    }

    public final Task<T> toJavaFXTask() {
        return new Task<T>(){

            @Override
            protected T call() throws Exception {
                if (IOTask.this.isCancelled) {
                    IOTask.this.throwCancelException();
                }
                return IOTask.this.onExecute();
            }

            @Override
            protected void succeeded() {
                IOTask.this.succeed(this.getValue());
            }

            @Override
            protected void failed() {
                IOTask.this.fail(this.getException());
            }
        };
    }

    private void succeed(T result) {
        this.successAction.accept(result);
    }

    private void fail(Throwable error) {
        if (error instanceof IOTaskCancelledException) {
            this.cancelAction.run();
            return;
        }
        this.failAction.accept(error);
    }

    public static IOTask<Void> ofVoid(Runnable action) {
        return IOTask.ofVoid(DEFAULT_NAME, action);
    }

    public static IOTask<Void> ofVoid(String name, Runnable action) {
        return IOTask.of(name, () -> {
            action.run();
            return null;
        });
    }

    public static <R> IOTask<R> of(Callable<R> action) {
        return IOTask.of(DEFAULT_NAME, action);
    }

    public static <R> IOTask<R> of(String name, final Callable<R> action) {
        return new IOTask<R>(name){

            @Override
            protected R onExecute() throws Exception {
                return action.call();
            }
        };
    }

    private static class IOTaskCancelledException
    extends RuntimeException {
        IOTaskCancelledException() {
            super("IOTask was cancelled with cancel()");
        }
    }
}

