/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.concurrent;

import com.almasb.fxgl.core.concurrent.AsyncTask;
import com.almasb.fxgl.core.concurrent.Coroutine;
import com.almasb.fxgl.core.concurrent.Executor;
import com.almasb.fxgl.core.concurrent.FXCoroutine;
import com.almasb.fxgl.core.concurrent.FXGLThreadFactory;
import com.almasb.fxgl.logging.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0015\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/core/concurrent/Async;", "Lcom/almasb/fxgl/core/concurrent/Executor;", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "schedulerService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "service", "Ljava/util/concurrent/ExecutorService;", "execute", "", "task", "Ljava/lang/Runnable;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "action", "delay", "Ljavafx/util/Duration;", "shutdownNow", "startAsync", "Lcom/almasb/fxgl/core/concurrent/AsyncTask;", "Ljava/lang/Void;", "func", "T", "", "Ljava/util/concurrent/Callable;", "startAsyncFX", "fxgl-core"})
public final class Async
implements Executor {
    @NotNull
    public static final Async INSTANCE = new Async();
    @NotNull
    private static final Logger log = Logger.Companion.get(INSTANCE.getClass());
    private static final ExecutorService service = Executors.newCachedThreadPool(FXGLThreadFactory.INSTANCE);
    private static final ScheduledExecutorService schedulerService = Executors.newScheduledThreadPool(2, FXGLThreadFactory.INSTANCE);

    private Async() {
    }

    @Override
    public void execute(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        service.submit(task2);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable action, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter(action, "action");
        Intrinsics.checkNotNullParameter(delay, "delay");
        ScheduledFuture<?> scheduledFuture = schedulerService.schedule(action, (long)delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "schedulerService.schedul\u2026), TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    @Override
    @NotNull
    public <T> AsyncTask<T> startAsync(@NotNull Callable<T> func) {
        Intrinsics.checkNotNullParameter(func, "func");
        ExecutorService executorService = service;
        Intrinsics.checkNotNullExpressionValue(executorService, "service");
        return new Coroutine<T>(func, executorService);
    }

    @NotNull
    public AsyncTask<Void> startAsync(@NotNull Runnable func) {
        Intrinsics.checkNotNullParameter(func, "func");
        Callable<Void> callable = () -> Async.startAsync$lambda$0(func);
        ExecutorService executorService = service;
        Intrinsics.checkNotNullExpressionValue(executorService, "service");
        return new Coroutine<Void>(callable, executorService);
    }

    @Override
    @NotNull
    public <T> AsyncTask<T> startAsyncFX(@NotNull Callable<T> func) {
        Intrinsics.checkNotNullParameter(func, "func");
        return new FXCoroutine<T>(func);
    }

    @NotNull
    public AsyncTask<Void> startAsyncFX(@NotNull Runnable func) {
        Intrinsics.checkNotNullParameter(func, "func");
        return new FXCoroutine<Void>(() -> Async.startAsyncFX$lambda$1(func));
    }

    @Override
    public void shutdownNow() {
        log.debug("Shutting down background threads");
        service.shutdownNow();
        schedulerService.shutdownNow();
    }

    private static final Void startAsync$lambda$0(Runnable $func) {
        Intrinsics.checkNotNullParameter($func, "$func");
        $func.run();
        return null;
    }

    private static final Void startAsyncFX$lambda$1(Runnable $func) {
        Intrinsics.checkNotNullParameter($func, "$func");
        $func.run();
        return null;
    }
}

