/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio.impl;

import com.almasb.fxgl.audio.Audio;
import com.almasb.fxgl.audio.AudioKt;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.impl.AudioLoader;
import com.almasb.fxgl.audio.impl.DesktopAndMobileAudioLoader;
import com.almasb.fxgl.audio.impl.DesktopMusic;
import com.almasb.fxgl.audio.impl.DesktopSound;
import com.almasb.fxgl.logging.Logger;
import com.gluonhq.attach.audio.AudioService;
import java.net.URL;
import java.util.Optional;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/audio/impl/DesktopAndMobileAudioLoader;", "Lcom/almasb/fxgl/audio/impl/AudioLoader;", "()V", "loadAudio", "Lcom/almasb/fxgl/audio/Audio;", "type", "Lcom/almasb/fxgl/audio/AudioType;", "resourceURL", "Ljava/net/URL;", "isMobile", "", "loadMobileAudio", "unloadAudio", "", "audio", "Companion", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nDesktopAndMobileAudioLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopAndMobileAudioLoader.kt\ncom/almasb/fxgl/audio/impl/DesktopAndMobileAudioLoader\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n*L\n1#1,97:1\n157#2:98\n*S KotlinDebug\n*F\n+ 1 DesktopAndMobileAudioLoader.kt\ncom/almasb/fxgl/audio/impl/DesktopAndMobileAudioLoader\n*L\n26#1:98\n*E\n"})
public final class DesktopAndMobileAudioLoader
implements AudioLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Lazy<Optional<AudioService>> attachService$delegate;

    @Override
    @NotNull
    public Audio loadAudio(@NotNull AudioType type, @NotNull URL resourceURL, boolean isMobile) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(resourceURL, "resourceURL");
        if (!isMobile) {
            String url = resourceURL.toExternalForm();
            return type == AudioType.MUSIC ? (Audio)new DesktopMusic(new MediaPlayer(new Media(url))) : (Audio)new DesktopSound(new AudioClip(url));
        }
        return this.loadMobileAudio(type, resourceURL);
    }

    private final Audio loadMobileAudio(AudioType type, URL resourceURL) {
        Optional<com.gluonhq.attach.audio.Audio> nativeAudio;
        if (!DesktopAndMobileAudioLoader.Companion.getAttachService().isPresent()) {
            log.warning("Attach Audio not present. Returning dummy audio");
            return AudioKt.getDummyAudio();
        }
        Optional<com.gluonhq.attach.audio.Audio> optional = nativeAudio = type == AudioType.MUSIC ? ((AudioService)DesktopAndMobileAudioLoader.Companion.getAttachService().get()).loadMusic(resourceURL) : ((AudioService)DesktopAndMobileAudioLoader.Companion.getAttachService().get()).loadSound(resourceURL);
        if (nativeAudio.isPresent()) {
            log.debug("Attach Audio correctly loaded: " + resourceURL);
        } else {
            log.warning("Attach Audio could not load: " + resourceURL);
        }
        return new Audio(type, nativeAudio){
            final /* synthetic */ Optional<com.gluonhq.attach.audio.Audio> $nativeAudio;
            {
                this.$nativeAudio = $nativeAudio;
                super($type);
            }

            public void setLooping(boolean looping) {
                this.$nativeAudio.ifPresent(arg_0 -> loadMobileAudio.1.setLooping$lambda$0(new Function1<com.gluonhq.attach.audio.Audio, Unit>(looping){
                    final /* synthetic */ boolean $looping;
                    {
                        this.$looping = $looping;
                        super(1);
                    }

                    public final void invoke(@NotNull com.gluonhq.attach.audio.Audio it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        it.setLooping(this.$looping);
                    }
                }, arg_0));
            }

            public void setVolume(double volume) {
                this.$nativeAudio.ifPresent(arg_0 -> loadMobileAudio.1.setVolume$lambda$1(new Function1<com.gluonhq.attach.audio.Audio, Unit>(volume){
                    final /* synthetic */ double $volume;
                    {
                        this.$volume = $volume;
                        super(1);
                    }

                    public final void invoke(@NotNull com.gluonhq.attach.audio.Audio it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        it.setVolume(this.$volume);
                    }
                }, arg_0));
            }

            public void setOnFinished(@NotNull Runnable action) {
                Intrinsics.checkNotNullParameter(action, "action");
            }

            public void play() {
                this.$nativeAudio.ifPresent(arg_0 -> loadMobileAudio.1.play$lambda$2(loadMobileAudio.play.1.INSTANCE, arg_0));
            }

            public void pause() {
                this.$nativeAudio.ifPresent(arg_0 -> loadMobileAudio.1.pause$lambda$3(loadMobileAudio.pause.1.INSTANCE, arg_0));
            }

            public void stop() {
                this.$nativeAudio.ifPresent(arg_0 -> loadMobileAudio.1.stop$lambda$4(loadMobileAudio.stop.1.INSTANCE, arg_0));
            }

            public void dispose$fxgl_core() {
                this.$nativeAudio.ifPresent(arg_0 -> loadMobileAudio.1.dispose$lambda$5(loadMobileAudio.dispose.1.INSTANCE, arg_0));
            }

            private static final void setLooping$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void setVolume$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void play$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void pause$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void stop$lambda$4(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void dispose$lambda$5(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }
        };
    }

    @Override
    public void unloadAudio(@NotNull Audio audio2) {
        Intrinsics.checkNotNullParameter(audio2, "audio");
        audio2.dispose$fxgl_core();
    }

    static {
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        log = this_$iv.get(DesktopAndMobileAudioLoader.class);
        attachService$delegate = LazyKt.lazy(Companion.attachService.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R?\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/almasb/fxgl/audio/impl/DesktopAndMobileAudioLoader$Companion;", "", "()V", "attachService", "Ljava/util/Optional;", "Lcom/gluonhq/attach/audio/AudioService;", "kotlin.jvm.PlatformType", "getAttachService", "()Ljava/util/Optional;", "attachService$delegate", "Lkotlin/Lazy;", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Optional<AudioService> getAttachService() {
            Lazy lazy = attachService$delegate;
            return (Optional)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

